VERSION 5.00
Begin VB.Form frmThreadSimple 
   AutoRedraw      =   -1  'True
   Caption         =   "Click the Form"
   ClientHeight    =   4815
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   6165
   LinkTopic       =   "Form1"
   ScaleHeight     =   4815
   ScaleWidth      =   6165
   StartUpPosition =   3  'Windows-Standard
End
Attribute VB_Name = "frmThreadSimple"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'ensure a unique Key for each of your Threads...
Private Const ThreadKey$ = "ThreadSimple"
'and specify the Class, for which an instance is created on the Thread
Private Const ThreadClass$ = "cThreadSimple"

'this is the clientside ThreadHandler - if you set this to nothing,
'then also the Thread it "controls" will be terminated
Private WithEvents TH As cThreadHandler
Attribute TH.VB_VarHelpID = -1

Private Sub Form_Load()
Dim ThreadLibPath As String 'specify, where your ThreadClasses reside in
 ThreadLibPath = App.Path & "\ThreadLibSimple.dll"
  
 Set TH = regfree.ThreadObjectCreate(ThreadKey, ThreadLibPath, ThreadClass)
End Sub

Private Sub Form_Click()
Dim i As Long, T As Single, StrResult As String
  Cls
  
  If Not TH.IsConnected Then
    MsgBox "Thread is not connected anymore": Exit Sub
  End If
  
  'first a performance-test, which demonstrates the synchronous
  'calling-mode, but also the Calls-per-second which you can
  'achieve, when "talking" to a thread-object...
  T = Timer
  For i = 1 To 1000
    StrResult = TH.CallSynchronous("StringReflection", CStr(i))
    If StrReverse(StrResult) <> CStr(i) Then
      'this shouldn't happen... ;-)
      Print "Error, calling StrReverse synchronously!"
    End If
  Next i
  Print Now, CLng(i / (Timer - T)) & " Calls per second"
  
  'now three async-calls, which make use of the TH-Events to talk-back to us
  TH.CallAsync "StringReflection", "ABC"
  TH.CallAsync "LongCall", 5 'a 5 rounds-loop-count, involving thread-events
  TH.CallAsync "DivByZero" 'demonstrate the Error-Backtransport
End Sub

Private Sub TH_ThreadEvent(MethodName As String, EventName As String, ByVal ParamCount As Long, P1 As Variant, P2 As Variant, P3 As Variant, P4 As Variant, P5 As Variant, P6 As Variant, P7 As Variant, P8 As Variant)
  Print "TH-"; MethodName, EventName, ParamCount, P1
End Sub

Private Sub TH_MethodFinished(MethodName As String, Result As Variant, ErrString As String, ErrSource As String, ByVal ErrNumber As Long)
  If Len(ErrString) Then
    Print "TH-"; MethodName, ErrString, ErrSource, ErrNumber
    Exit Sub
  End If
  
  Print "TH-"; MethodName, "Result: "; Result
End Sub


