VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cThreadAdvanced"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

'an Event-Naming-Convention, to allow better cooperation with the clients
'this Event does not go through to the clients, it is received by the
'(hidden in dhRichClient) cThreadProxy-Class, which is our host for this ThreadClass
Event CancelCheck(Cancel As Boolean)
'another (the last one) Naming-Convention, for an Event, which can deliver a RichClient-Factory-Instance
Event GetFactory(Factory As cFactory)

'and our normal ThreadEvents - these are raised asynchronuously,
'so don't expect return-values from ByRef-Parameters, instead use the
'Event-Naming-Convention from above, to check at least for Execution-Cancel-Messages
Event Progress(ByVal RatePercent As Double)
Event ThreadTimer(ByVal Time As Date)

Private WithEvents T As cTimer 'our internal "Threadobject-Timer"
Attribute T.VB_VarHelpID = -1
Private Cnn As cConnection 'a threadinternal DB-Connection-Object

Public Function LongCall(ByVal Steps As Long) As Long 'a simulation of a longer Call
Dim i As Long
  For i = 0 To Steps - 1
    Sleep 250 ' simulate "heavier processing, which takes some time"
    If CancelExecution Then Exit Function
    RaiseEvent Progress((i + 1) / Steps)
  Next i
  LongCall = i 'just return the successfully processed rounds
End Function

Public Sub SetThreadInternalTimer(ByVal Enabled As Boolean, ByVal Interval As Long)
  If T Is Nothing Then
    Set T = dhF.C.Timer
  End If
  T.Interval = Interval
  T.Enabled = Enabled
End Sub

Public Function GetRecordset(SQL As String) As cRecordset 'demonstrate Object-Backtransport
Dim i As Long
  If Cnn Is Nothing Then 'not yet instantiated (and not prefilled with some DemoData)
    Set Cnn = dhF.C.Connection(, DBCreateInMemory) 'so we use an InMemoryDB here...
    'and create a simple table 'T' on it...
    Cnn.Execute "Create Table T(ID Integer Primary Key, TxtFld Text)"
    'followed by some data-inserts.
    For i = 1 To 100
      Cnn.Execute "Insert Into T(TxtFld) Values('SomeText_" & i & "')"
    Next i
  End If
  
  'finally we have only to perform the Select here in this line - the above
  'block is usually only called once (the first time this routine is entered)
  Set GetRecordset = Cnn.OpenRecordset(SQL)
End Function

'small internal helper-function, to catch an eventual cancel-request from the
'clientside more "comfortable". These clientside Cancel-Requests are send
'from the clientside ThreadHandler to the (hidden) ThreadProxy-Class, which
'is the hosting parent of this ThreadObject-Class. There are two cases, where
'the Cancel-Flag of this Event returns with 'True':
'Case 1: The clientside ThreadHandler, which was the Creator of this Thread
'        goes "Out of Scope" (is Set to Nothing at the clientside).
'Case 2: The clientside ThreadHandler-Method .CancelExecution is called...
'        a "cooperative ThreadRoutine" (usually a LongRunner) should react accordingly -
'        as is demonstrated here in the LongRun-Function.
Private Function CancelExecution() As Boolean
  RaiseEvent CancelCheck(CancelExecution)
End Function

'a similar helper as above, making use of the other Event-Convention,
'to deliver a RichClient-Factory, which saves us from creating one
'ourself (which would be a bit more difficult than using this Event,
'in case we wanted to create the RichClient-Factory regfree, this
'way we can avoid, to fiddle around with App.Path-Parsing-Routines,
'to determine the dhRichClient3.dll-Path, in case the (this) Thread-Dll,
'where our (this) ThreadObject comes from is placed on a different
'Path than dhRichClient3.dll
Private Function dhF() As cFactory
Static F As cFactory
  If F Is Nothing Then
    RaiseEvent GetFactory(F)
  End If
  Set dhF = F
End Function

'the following Event (our internal Timer-Event) is interesting,
'because it forces a special broadcasting-behaviour, which sends
'to *all* connected Clients of this thread-object - this is different
'from Events, which are raised inside directly-called-ThreadObject-
'Methods, as for example the Progress-Event inside the LongRun-
'Method, these are raised to the calling-client only.
Private Sub T_Timer()
  RaiseEvent ThreadTimer(Now)
End Sub
