VERSION 5.00
Begin VB.Form fServer 
   Caption         =   "Simple Webserver using cTCPServer from dhRichClient"
   ClientHeight    =   3855
   ClientLeft      =   60
   ClientTop       =   405
   ClientWidth     =   6720
   LinkTopic       =   "Form1"
   ScaleHeight     =   3855
   ScaleWidth      =   6720
   StartUpPosition =   3  'Windows-Standard
   Begin VB.TextBox tUrlCopy 
      Height          =   315
      Left            =   2310
      Locked          =   -1  'True
      TabIndex        =   1
      Top             =   270
      Width           =   3765
   End
   Begin VB.Label lblComment 
      BorderStyle     =   1  'Fest Einfach
      Caption         =   $"WebServer.frx":0000
      Height          =   735
      Left            =   240
      TabIndex        =   2
      Top             =   810
      Width           =   5835
      WordWrap        =   -1  'True
   End
   Begin VB.Label lblUrl 
      Caption         =   "Paste this into your Browser:"
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   300
      Width           =   2145
   End
End
Attribute VB_Name = "fServer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This example demonstrates, how to use the TCPServer-Class from
'dhRichClient, to create a multiconnection-capable Webserver,
'hosting a simple WebApp which you have full control over.
'It is based on Frames, to keep the refresh of the Page-Areas
'where they belong - and the Bottom-Frame retriggers itself
'with an User-adjustable Interval - useful e.g. if you want
'to show serverside Data - e.g. from a serial Port - or whatever.
'The example also supports the Standard-Authentication-Scheme
'built into Standard-Browsers - so you will have to login
'into your first session with User | Pass = 'a' | 'b'.

Option Explicit

Private WithEvents TCPServer As cTCPServer, CnnHdls As Collection
Attribute TCPServer.VB_VarHelpID = -1
Private Host As String, Port As Long

Private Sub Form_Load()
  Set CnnHdls = New Collection 'storage for client-socket-handles
  Set TCPServer = New_c.TCPServer
  
  Host = TCPServer.GetIP("") 'get the default-IP of this machine
  Port = 8080
  
  TCPServer.Listen Host, Port 'start-up
  
  tUrlCopy.Text = "http://" & Host & ":" & Port 'just something to copy the Url from
End Sub

Private Sub TCPServer_TCPAccepted(ByVal hSocket As Long)
Dim NewCnn As cReq
  On Error Resume Next
    CnnHdls.Remove CStr(hSocket) 'just to make sure, it really doesn't exist
  If Err Then Err.Clear
  
  Set NewCnn = New cReq 'create a new ClientRequest-Instance
  NewCnn.hSocket = hSocket 'store the socket-handle in it
  CnnHdls.Add NewCnn, CStr(hSocket) 'and add the new Connetion to our Collection
End Sub

Private Sub TCPServer_DataArrival(ByVal hSocket As Long, ByVal BytesTotal As Long, ByVal FirstBufferAfterOverflow As Boolean)
Dim ClReq As cReq, B() As Byte, lDLen As Long
  On Error Resume Next
    Set ClReq = CnnHdls(CStr(hSocket))
  If ClReq Is Nothing Then Err.Clear: Exit Sub
  
  'we always read all bytes from the Inbuffer, to free the queue
  ReDim B(BytesTotal - 1)
  TCPServer.GetData hSocket, VarPtr(B(0)), BytesTotal
  ClReq.ProcessBytes B, TCPServer 'and process the received Bytes inside the Class
End Sub

Private Sub TCPServer_TCPDisConnect(ByVal hSocket As Long)
  On Error Resume Next
    CnnHdls.Remove CStr(hSocket)
  If Err Then Err.Clear
End Sub

Private Sub TCPServer_SockError(ByVal hSocket As Long, ErrString As String)
  On Error Resume Next
    TCPServer.Disconnect hSocket
    CnnHdls.Remove CStr(hSocket)
  If Err Then Err.Clear
End Sub


