Attribute VB_Name = "mIntelJPEGLibrary"
Option Explicit

Private Enum TIJL_COLOR
  IJL_RGB = 1        'Red-Green-Blue color space
  IJL_BGR = 2        'Reversed channel ordering from IJL_RGB
  IJL_YCBCR = 3      'Luminance-Chrominance color space
  IJL_G = 4          'Grayscale color space
  IJL_RGBA_FPX = 5   'FlashPix RGBA 4 channel color space
  IJL_YCBCRA_FPX = 6 'FlashPix YCBCRA 4 channel color space
End Enum

Private Enum IJLERR
  IJL_OK = 0
  IJL_INTERRUPT_OK = 1
  IJL_ROI_OK = 2

  IJL_EXCEPTION_DETECTED = -1
  IJL_INVALID_ENCODER = -2
  IJL_UNSUPPORTED_SUBSAMPLING = -3
  IJL_UNSUPPORTED_BYTES_PER_PIXEL = -4
  IJL_MEMORY_ERROR = -5
  IJL_BAD_HUFFMAN_TABLE = -6
  IJL_BAD_QUANT_TABLE = -7
  IJL_INVALID_JPEG_PROPERTIES = -8
  IJL_ERR_FILECLOSE = -9
  IJL_INVALID_FILENAME = -10
  IJL_ERROR_EOF = -11
  IJL_PROG_NOT_SUPPORTED = -12
  IJL_ERR_NOT_JPEG = -13
  IJL_ERR_COMP = -14
  IJL_ERR_SOF = -15
  IJL_ERR_DNL = -16
  IJL_ERR_NO_HUF = -17
  IJL_ERR_NO_QUAN = -18
  IJL_ERR_NO_FRAME = -19
  IJL_ERR_MULT_FRAME = -20
  IJL_ERR_DATA = -21
  IJL_ERR_NO_IMAGE = -22
  IJL_FILE_ERROR = -23
  IJL_INTERNAL_ERROR = -24
  IJL_BAD_RST_MARKER = -25
  IJL_THUMBNAIL_DIB_TOO_SMALL = -26
  IJL_THUMBNAIL_DIB_WRONG_COLOR = -27
  IJL_RESERVED = -99
End Enum

Private Enum IJLIOTYPE
  IJL_SETUP = -1&
  ''// Read JPEG parameters (i.e., height, width, channels,
  ''// sampling, etc.) from a JPEG bit stream.
  IJL_JFILE_READPARAMS = 0&
  IJL_JBUFF_READPARAMS = 1&
  ''// Read a JPEG Interchange Format image.
  IJL_JFILE_READWHOLEIMAGE = 2&
  IJL_JBUFF_READWHOLEIMAGE = 3&
  ''// Read JPEG tables from a JPEG Abbreviated Format bit stream.
  IJL_JFILE_READHEADER = 4&
  IJL_JBUFF_READHEADER = 5&
  ''// Read image info from a JPEG Abbreviated Format bit stream.
  IJL_JFILE_READENTROPY = 6&
  IJL_JBUFF_READENTROPY = 7&
  ''// Write an entire JFIF bit stream.
  IJL_Jfile_WRITEWHOLEIMAGE = 8&
  IJL_JBUFF_WRITEWHOLEIMAGE = 9&
  ''// Write a JPEG Abbreviated Format bit stream.
  IJL_JFILE_WRITEHEADER = 10&
  IJL_JBUFF_WRITEHEADER = 11&
  ''// Write image info to a JPEG Abbreviated Format bit stream.
  IJL_JFILE_WRITEENTROPY = 12&
  IJL_JBUFF_WRITEENTROPY = 13&
  ''// Scaled Decoding Options:
  ''// Reads a JPEG image scaled to 1/2 size.
  IJL_JFILE_READONEHALF = 14&
  IJL_JBUFF_READONEHALF = 15&
  ''// Reads a JPEG image scaled to 1/4 size.
  IJL_JFILE_READONEQUARTER = 16&
  IJL_JBUFF_READONEQUARTER = 17&
  ''// Reads a JPEG image scaled to 1/8 size.
  IJL_JFILE_READONEEIGHTH = 18&
  IJL_JBUFF_READONEEIGHTH = 19&
  ''// Reads an embedded thumbnail from a JFIF bit stream.
  IJL_JFILE_READTHUMBNAIL = 20&
  IJL_JBUFF_READTHUMBNAIL = 21&

End Enum

Private Type JPEG_CORE_PROPERTIES_VB
  UseJPEGPROPERTIES As Long                      '// default = 0

  '// DIB specific I/O data specifiers.
  DIBBytes As Long ';                  '// default = NULL 4
  DIBWidth As Long ';                  '// default = 0 8
  DIBHeight As Long ';                 '// default = 0 12
  DIBPadBytes As Long ';               '// default = 0 16
  DIBChannels As Long ';               '// default = 3 20
  DIBColor As Long ';                  '// default = IJL_BGR 24
  DIBSubsampling As Long  ';            '// default = IJL_NONE 28

  '// JPEG specific I/O data specifiers.
  JPGFile As Long 'LPTSTR              JPGFile;                32   '// default = NULL
  JPGBytes As Long ';                  '// default = NULL 36
  JPGSizeBytes As Long ';              '// default = 0 40
  JPGWidth As Long ';                  '// default = 0 44
  JPGHeight As Long ';                 '// default = 0 48
  JPGChannels As Long ';               '// default = 3
  JPGColor As Long           ';                  '// default = IJL_YCBCR
  JPGSubsampling As Long  ';            '// default = IJL_411
  JPGThumbWidth As Long ' ;             '// default = 0
  JPGThumbHeight As Long ';            '// default = 0

  '// JPEG conversion properties.
  cconversion_reqd As Long ';          '// default = TRUE
  upsampling_reqd As Long ';           '// default = TRUE
  jquality As Long ';                  '// default = 75.  100 is my preferred quality setting.

  jprops(0 To 19999) As Byte
End Type

Private Declare Function ijlInit Lib "ijl11" (jcprops As Any) As Long
Private Declare Function ijlFree Lib "ijl11" (jcprops As Any) As Long
Private Declare Function ijlRead Lib "ijl11" (jcprops As Any, ByVal iotype As Long) As Long
Private Declare Function ijlWrite Lib "ijl11" (jcprops As Any, ByVal iotype As Long) As Long
Private Declare Function ijlGetLibVersion Lib "ijl11" () As Long
Private Declare Function ijlGetErrorString Lib "ijl11" (ByVal code As Long) As Long

Private tJRead As JPEG_CORE_PROPERTIES_VB

Public Function SaveDIB24ToJPGBuf(ByVal Width&, ByVal Height&, DIB24Ptr&, ByVal JPGBufSize&, JpgBufPtr&, _
        Optional ByVal Quality As Long = 90, Optional ByVal BGROrder As Boolean = True) As Long
Static tJ As JPEG_CORE_PROPERTIES_VB
  If tJ.DIBBytes = 0 Then ijlInit tJ
  
  'Set up the DIB information:
  tJ.DIBBytes = DIB24Ptr
  tJ.DIBWidth = Width
  tJ.DIBHeight = Height
  tJ.DIBChannels = 3
  tJ.DIBColor = IIf(BGROrder, IJL_BGR, IJL_RGB)
  tJ.DIBPadBytes = (4 - (Width * 3 Mod 4)) Mod 4  '32 bit-padding per DIB-scanline

  ' Set up the JPEG information:
  tJ.JPGBytes = JpgBufPtr
  tJ.JPGSizeBytes = JPGBufSize
  tJ.JPGWidth = Width
  tJ.JPGHeight = Height
  tJ.jquality = Quality
  
  ' Write the imagebuf:
  If ijlWrite(tJ, IJL_JBUFF_WRITEWHOLEIMAGE) = IJL_OK Then
     SaveDIB24ToJPGBuf = tJ.JPGSizeBytes 'return with the JPGSize if successful
  End If
End Function

Public Function JPGBuf2RGB32DIB(ByVal JPGBufSize&, JpgBufPtr&, DIB32Ptr&) As Long
  If tJRead.JPGBytes = 0 Then ijlInit tJRead
  
  tJRead.JPGBytes = JpgBufPtr
  tJRead.JPGSizeBytes = JPGBufSize
  GetJPGDimensions JPGBufSize, JpgBufPtr, tJRead.DIBWidth, tJRead.DIBHeight
  If tJRead.DIBWidth > 0 And tJRead.DIBHeight > 0 Then
    'now set up the DIB information:
    tJRead.DIBBytes = DIB32Ptr
    tJRead.DIBChannels = 4
    tJRead.DIBColor = IJL_RGBA_FPX
    tJRead.DIBPadBytes = 0 'no padding needed for a 32Bit-DIB
    
    'and try to read the Jpg-Buffer into the DIB
    If ijlRead(tJRead, IJL_JBUFF_READWHOLEIMAGE) = IJL_OK Then
      JPGBuf2RGB32DIB = tJRead.JPGSizeBytes 'return with the JPGSize if successful
    End If
  End If
End Function

Public Function JPGBuf2RGB24DIB(ByVal JPGBufSize&, JpgBufPtr&, DIB24Ptr&, Optional ByVal dx&, Optional ByVal dy&, Optional ByVal BGROrder As Boolean = True) As Long
  If tJRead.JPGBytes = 0 Then ijlInit tJRead
  
  tJRead.JPGSizeBytes = JPGBufSize
  tJRead.JPGBytes = JpgBufPtr
  
  If dx <= 0 Or dy <= 0 Then 'Opt-Params were not supplied (saves some msec)
    GetJPGDimensions JPGBufSize, JpgBufPtr, tJRead.DIBWidth, tJRead.DIBHeight
  Else
    tJRead.DIBWidth = dx
    tJRead.DIBHeight = dy
  End If
  If tJRead.DIBWidth > 0 And tJRead.DIBHeight > 0 Then
    'now set up the DIB information:
    tJRead.DIBBytes = DIB24Ptr
    tJRead.DIBChannels = 3
    tJRead.DIBColor = IIf(BGROrder, IJL_BGR, IJL_RGB)
    tJRead.DIBPadBytes = (4 - (tJRead.DIBWidth * 3 Mod 4)) Mod 4
  
    'and try to read the Jpg-Buffer into the DIB
    If ijlRead(tJRead, IJL_JBUFF_READWHOLEIMAGE) = IJL_OK Then
       JPGBuf2RGB24DIB = tJRead.JPGSizeBytes 'return with the JPGSize if successful
    End If
  End If
End Function

Public Sub GetJPGDimensions(ByVal JPGBufSize&, JpgBufPtr&, dx As Long, dy As Long)
  If tJRead.JPGBytes = 0 Then ijlInit tJRead
  
  tJRead.JPGBytes = JpgBufPtr
  tJRead.JPGSizeBytes = JPGBufSize
  If ijlRead(tJRead, IJL_JBUFF_READPARAMS) = IJL_OK Then
    dx = tJRead.JPGWidth
    dy = tJRead.JPGHeight
  Else
    dx = 0
    dy = 0
  End If
End Sub





