VERSION 5.00
Begin VB.Form fWebServer 
   Caption         =   "Streaming-Desk WebServer"
   ClientHeight    =   3060
   ClientLeft      =   60
   ClientTop       =   405
   ClientWidth     =   5250
   LinkTopic       =   "Form1"
   ScaleHeight     =   3060
   ScaleWidth      =   5250
   StartUpPosition =   3  'Windows-Standard
   Begin VB.TextBox tUrlCopy 
      Height          =   315
      Left            =   2220
      Locked          =   -1  'True
      TabIndex        =   3
      Top             =   690
      Width           =   2895
   End
   Begin VB.HScrollBar hscrGrabInterval 
      Height          =   300
      LargeChange     =   10
      Left            =   2340
      Max             =   1000
      Min             =   10
      TabIndex        =   1
      Top             =   180
      Value           =   10
      Width           =   1515
   End
   Begin VB.Timer TFPSMeasure 
      Interval        =   1000
      Left            =   4290
      Top             =   150
   End
   Begin VB.Timer TGrab 
      Interval        =   150
      Left            =   3870
      Top             =   150
   End
   Begin VB.Label lblUrl 
      Caption         =   "Paste this into your Browser:"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   750
      Width           =   2145
   End
   Begin VB.Label lblComment 
      BorderStyle     =   1  'Fest Einfach
      Caption         =   $"fWebServer.frx":0000
      Height          =   1575
      Left            =   120
      TabIndex        =   4
      Top             =   1260
      Width           =   4995
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label2 
      Caption         =   "Grab-Interval"
      Height          =   255
      Left            =   1350
      TabIndex        =   2
      Top             =   240
      Width           =   1005
   End
   Begin VB.Label Label1 
      BorderStyle     =   1  'Fest Einfach
      Height          =   315
      Left            =   135
      TabIndex        =   0
      Top             =   180
      Width           =   1095
   End
End
Attribute VB_Name = "fWebServer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Type BITMAPINFOHEADER
  biSize As Long
  biWidth As Long
  biHeight As Long
  biPlanes As Integer
  biBitCount As Integer
  biCompression As Long
  biSizeImage As Long
  biXPelsPerMeter As Long
  biYPelsPerMeter As Long
  biClrUsed As Long
  biClrImportant As Long
End Type

Private Declare Function CreateCompatibleDC& Lib "gdi32" (ByVal hDC&)
Private Declare Function CreateDIBSection& Lib "gdi32" (ByVal hDC&, pBitmapInfo As Any, ByVal un&, ppBits&, ByVal Hdl&, ByVal dw&)
Private Declare Function SetStretchBltMode& Lib "gdi32" (ByVal hDC&, ByVal nStretchMode&)
Private Declare Function GetDC& Lib "user32" (ByVal hWnd&)
Private Declare Function ReleaseDC& Lib "user32" (ByVal hWnd&, ByVal gDC&)
Private Declare Function StretchBlt& Lib "gdi32" (ByVal hDC&, ByVal x&, ByVal y&, ByVal nWidth&, ByVal nHeight&, ByVal hSrcDC&, ByVal xSrc&, ByVal ySrc&, ByVal nSrcWidth&, ByVal nSrcHeight&, ByVal dwRop&)
Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function SelectObject& Lib "gdi32" (ByVal DC&, ByVal hObj&)
Private Declare Function DeleteObject& Lib "gdi32" (ByVal hObject&)
Private Declare Function DeleteDC& Lib "gdi32" (ByVal hDC&)
Private Declare Function SetPixel Lib "gdi32" (ByVal hDC As Long, ByVal x As Long, ByVal y As Long, ByVal crColor As Long) As Long

Private Declare Function GetCursorPos Lib "user32" (lpPoint As Any) As Long
Private Declare Sub RtlMoveMemory Lib "kernel32" (Dst As Any, Src As Any, ByVal cBytes&)

Private WithEvents Server As cTCPServer, Clients As Collection 'TCP-Vars
Attribute Server.VB_VarHelpID = -1
Private Host As String, Port As Long
Private SendBuf() As Byte, pSendBuf&, FPS& 'Send-Vars for sending the Headers

Const JPGBufSize& = 1000000
Private JPGHeader As String, JPGData() As Byte, pJPGData&

Private hDIB&, pDIB&, ScreenDC&, DIBDC&, OldhBMP& 'GDI-Vars
Private dx As cDXBlt, ScreenDX&, ScreenDY&, DXHalf&, DYHalf& 'DX-Vars for Screen-Grab+Stretching


Private Sub Form_Load()
  hscrGrabInterval.Value = 150
  
  InitDesk 'init all GDI-Objects we need
  
  Set Clients = New Collection 'this Collection takes all connected Clients (of Type cClient)
  
  'regfree-COM-Instancing
  Set Server = New_c.TCPServer
  
  'listens on localhost on this machine, change the port at will
  'to see it working, open your browser with http://localhost:8080
  'Server.Listen "localhost", 8080
  
  'if you want to access this Webserver-based Desktop-Scanner from
  'other machines, you will have to give an explicite IP for the host,
  'or simply use an empty string as shown here:
  Host = Server.GetIP("") 'get the default-IP of this machine
  Port = 8080
  Server.Listen Host, Port
  'this would listen on the default-IP of this Host and in your
  'Browser you would then have to enter the fully qualified
  'name or IP of this host, e.g. http://192.168.0.123:8080 or something like that
    
  tUrlCopy.Text = "http://" & Host & ":" & Port 'just something to copy the Url from

  
  'now we ensure two preallocated Buffers, to avoid unnecessary ReDims...
  'this keeps the CPU-Load low
  ReDim SendBuf(JPGBufSize) 'define a SendBuffer (and allocate) it once
  pSendBuf = VarPtr(SendBuf(0))
  
  ReDim JPGData(JPGBufSize) '...same thing here for the DIB-To-JPG-Conversion
  pJPGData = VarPtr(JPGData(0))
End Sub

Private Sub Form_Unload(Cancel As Integer)
Dim Client As cClient
  TGrab.Enabled = False
  TFPSMeasure.Enabled = False
  
  For Each Client In Clients
    Server.Disconnect Client.hSocket
  Next Client
  
  Set Server = Nothing
  CleanupGDIObjects
End Sub

Private Sub hscrGrabInterval_Change()
  TGrab.Interval = hscrGrabInterval.Value
End Sub

Private Sub hscrGrabInterval_Scroll()
  hscrGrabInterval_Change
End Sub

Private Sub Server_TCPAccepted(ByVal hSocket As Long)
Dim NewClient As cClient
  On Error Resume Next
    Clients.Remove CStr(hSocket) 'just to be sure, we have no old client with this hsocket in the list
  Err.Clear
  
  Set NewClient = New cClient
  NewClient.hSocket = hSocket
  NewClient.PeerHostIPAndPort = Server.GetPeerHostIPAndPort(hSocket)
  
  Clients.Add NewClient, CStr(hSocket) 'add the Client-Instance to our HashList
End Sub

Private Sub Server_DataArrival(ByVal hSocket As Long, ByVal BytesTotal As Long, ByVal FirstBufferAfterOverflow As Boolean)
Dim HttpResponse As String, RecvBuf(8192) As Byte, S$
  'we have only interest in the first part of the Browser-Header
  Server.GetData hSocket, VarPtr(RecvBuf(0)), 8192
  S = StrConv(RecvBuf, vbUnicode) 'convert RecvBuf to a String, which we can check for 'nph-streaming'
  
  HttpResponse = "HTTP/1.1 200 OK" & vbCrLf & _
      "Server: dhJPEGStream/1.0" & vbCrLf & _
      "Connection: close" & vbCrLf
  
  If InStr(S, "nph-streaming") = 0 Then 'initial-site-request (we deliver an <img src, which provoces the second request below)
    HttpResponse = HttpResponse & "Content-Type: text/html" & vbCrLf & vbCrLf & _
      "<HTML><HEAD><TITLE>Desktop-Streaming</TITLE></HEAD>" & vbCrLf & _
      "<BODY>Watching Desktop of host: " & Server.GetIP("") & _
      "<br><br><IMG SRC='nph-streaming'></IMG></BODY></HTML>"
  Else 'stream-request from the <img>-tag, which we answer with a multipart/x-mixed-replace (doesn't work with IE)
    HttpResponse = HttpResponse & "Expires: 0" & vbCrLf & _
      "Cache-Control: max-age=0, no-store, no-cache, must-revalidate" & vbCrLf & _
      "Content-Type: multipart/x-mixed-replace; boundary=NextJPEGPart" & vbCrLf & vbCrLf
      
      Clients(CStr(hSocket)).AllowStreaming = True 'allow streaming in our TGrab-Timer-Event
  End If
  
  RtlMoveMemory ByVal pSendBuf, ByVal HttpResponse, Len(HttpResponse)
  Server.SendData hSocket, pSendBuf, Len(HttpResponse)
End Sub

Private Sub Server_TCPDisConnect(ByVal hSocket As Long)
  On Error Resume Next
    Clients.Remove CStr(hSocket)
  Err.Clear
End Sub

Private Sub Server_SockError(ByVal hSocket As Long, ErrString As String)
  Server.Disconnect hSocket
  On Error Resume Next
    Clients.Remove CStr(hSocket)
  Err.Clear
End Sub

Private Sub TGrab_Timer()
Dim LenJPGData&, Client As cClient
  FPS = FPS + 1
  TGrab.Enabled = False
  
  LenJPGData = GetJPG() 'create a new snapshot and store it in JPGData()
  
  If LenJPGData Then
    JPGHeader = "--NextJPEGPart" & vbCrLf & _
                "Content-type: image/jpeg" & vbCrLf & _
                "Content-Length: " & LenJPGData & vbCrLf & vbCrLf
    
    RtlMoveMemory ByVal pSendBuf, ByVal JPGHeader, Len(JPGHeader) 'Convert to Bytes
    
    'now we send this new captured JPEG to all connected Clients
    For Each Client In Clients
      'The --NextJPEGPart Header first...
      If Client.AllowStreaming Then
        Server.SendData Client.hSocket, pSendBuf, Len(JPGHeader)
        
        '...and then the Bytes from the JPGBuffer directly...
        Server.SendData Client.hSocket, pJPGData, LenJPGData
      End If
    Next Client
  End If
  
  TGrab.Enabled = True 're-enable the timer if we are done
End Sub

Private Function GetJPG() As Long
  'This is the fastest 'Grab-DownScale' (which also gives the best stretch-quality)
  'Using DirectX we can achieve very low CPU-Load during this FullScreen-Grabbing
  dx.DxBlt DIBDC
    
'  'alternative Blt (if DX is not working), to stretch to our DIB-based "Quarter-Screen"
'  SetStretchBltMode DIBDC, 4 '3 (DeleteScans) is fastest, 4 (Halftone-Stretch) would be best quality
'  StretchBlt DIBDC, 0, 0, DXHalf, DYHalf, ScreenDC, 0, 0, ScreenDX, ScreenDY, vbSrcCopy
  
  'the Mouse is not captured, so we draw something in Red, to visualize the MousePos
  Dim MPos&(1), x&, y&, i&
  GetCursorPos MPos(0)
  x = MPos(0) / 2: y = MPos(1) / 2
  For i = 0 To 6: SetPixel DIBDC, x, y + i, vbRed: Next i
  For i = 1 To 4: SetPixel DIBDC, x + i, y + i, vbRed: Next i

  'now we encode the DIB to JPG using the very fast Intel-JPG-Lib
  GetJPG = SaveDIB24ToJPGBuf(DXHalf, DYHalf, pDIB, JPGBufSize, pJPGData, 80)
End Function

Private Sub InitDesk()
Dim BI As BITMAPINFOHEADER
  ScreenDX = Screen.Width / Screen.TwipsPerPixelX
  ScreenDY = Screen.Height / Screen.TwipsPerPixelY
  DXHalf = ScreenDX \ 2: DYHalf = ScreenDY \ 2
  
  Set dx = New cDXBlt
  
  BI.biSize = 40: BI.biBitCount = 24: BI.biPlanes = 1
  BI.biWidth = DXHalf: BI.biHeight = -DYHalf

  hDIB = CreateDIBSection(0, BI, 0, pDIB, 0, 0)
  DIBDC = CreateCompatibleDC(0)
  OldhBMP = SelectObject(DIBDC, hDIB)
  
  ScreenDC = GetDC(0)
End Sub

Private Sub CleanupGDIObjects()
  DeleteObject SelectObject(DIBDC, OldhBMP)
  DeleteDC DIBDC
  ReleaseDC 0, ScreenDC
  Set dx = Nothing
End Sub

Private Sub TFPSMeasure_Timer()
  Label1.Caption = "FPS: " & FPS
  FPS = 0
End Sub

