VERSION 5.00
Begin VB.Form fViewer 
   Caption         =   "Simple DeskViewer-Client"
   ClientHeight    =   8715
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   12780
   LinkTopic       =   "Form1"
   ScaleHeight     =   8715
   ScaleWidth      =   12780
   StartUpPosition =   3  'Windows-Standard
   Begin VB.TextBox txtPort 
      Height          =   330
      Left            =   3090
      TabIndex        =   4
      Text            =   "8080"
      Top             =   90
      Width           =   585
   End
   Begin VB.TextBox txtHost 
      Height          =   330
      Left            =   1590
      TabIndex        =   3
      Top             =   90
      Width           =   1425
   End
   Begin VB.CommandButton cmdConnect 
      BackColor       =   &H000000FF&
      Caption         =   "Connect"
      Height          =   345
      Left            =   120
      Style           =   1  'Grafisch
      TabIndex        =   2
      Top             =   90
      Width           =   1395
   End
   Begin VB.PictureBox Picture1 
      Height          =   8025
      Left            =   120
      ScaleHeight     =   7965
      ScaleWidth      =   12435
      TabIndex        =   1
      Top             =   540
      Width           =   12495
   End
   Begin VB.Timer TFPSMeasure 
      Interval        =   1000
      Left            =   5370
      Top             =   90
   End
   Begin VB.Label Label1 
      BorderStyle     =   1  'Fest Einfach
      Height          =   315
      Left            =   3840
      TabIndex        =   0
      Top             =   90
      Width           =   1095
   End
End
Attribute VB_Name = "fViewer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Type BITMAPINFOHEADER
  biSize As Long
  biWidth As Long
  biHeight As Long
  biPlanes As Integer
  biBitCount As Integer
  biCompression As Long
  biSizeImage As Long
  biXPelsPerMeter As Long
  biYPelsPerMeter As Long
  biClrUsed As Long
  biClrImportant As Long
End Type

Private Declare Function StretchDIBits& Lib "gdi32" (ByVal hdc&, ByVal x&, ByVal y&, ByVal dx&, ByVal dy&, ByVal SrcX&, ByVal SrcY&, ByVal Srcdx&, ByVal Srcdy&, Bits As Any, BI As Any, ByVal U&, ByVal R&)

Private Declare Sub RtlMoveMemory Lib "kernel32" (Dst As Any, Src As Any, ByVal cBytes&)

Private WithEvents Client As cTCPClient, hsClient&  'TCP-Vars
Attribute Client.VB_VarHelpID = -1

Const RecvBufSize& = 2048000
Private RecvBuf() As Byte, pRecvBuf&, RecvBufCount&, FPS& 'Send-Vars for sending the Headers

Const DIBBufSize& = 4096000
Private DIBData() As Byte, pDIBData&

Private JustConnected As Boolean

Private Sub Form_Load()
  Me.ScaleMode = vbPixels
  
  Set Client = New_c.TCPClient
  
  txtHost.Text = Client.GetIP("") 'try to resolve the local IP (only for local tests)

  'now we ensure two preallocated Buffers, to avoid unnecessary ReDims...
  'this keeps the CPU-Load low
  ReDim RecvBuf(RecvBufSize) 'define a RecvBuffer (and allocate) it once
  pRecvBuf = VarPtr(RecvBuf(0))
  
  ReDim DIBData(DIBBufSize) '...same thing here for the DIB-To-JPG-Conversion
  pDIBData = VarPtr(DIBData(0))
End Sub

Private Sub cmdConnect_Click()
  If cmdConnect.BackColor = vbRed Then
    hsClient = Client.Connect(txtHost.Text, txtPort.Text, 2, RecvBufSize)
  Else
    If hsClient Then Client.Disconnect hsClient
  End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
  TFPSMeasure.Enabled = False
  
  Set Client = Nothing
End Sub

Private Sub Client_DataArrival(ByVal hSocket As Long, ByVal BytesTotal As Long, ByVal FirstBufferAfterOverflow As Boolean)
Dim B() As Byte, S$, Pos&, JPGStart&, JPGLen&
  If JustConnected Then 'send the Init-Streaming-command to the server
    B = StrConv("nph-streaming", vbFromUnicode)
    Client.SendData hSocket, VarPtr(B(0)), UBound(B) + 1
    JustConnected = False
  End If
  Client.GetData hSocket, pRecvBuf + RecvBufCount, BytesTotal
  RecvBufCount = RecvBufCount + BytesTotal
  If RecvBufCount > RecvBufSize \ 2 Then RecvBufCount = 0: Exit Sub 'reset in case of too much buffered content
  
  'we need a string-representation for our Header-analysis
  S = Space(RecvBufCount)
  RtlMoveMemory ByVal S, ByVal pRecvBuf, RecvBufCount
  
  'now check the Header-String, to find the JPG-Content
  Pos = InStr(S, "Content-Length: ")
  If Pos Then
    JPGLen = Val(Mid$(S, Pos + 16, 7))
    If JPGLen = 0 Or JPGLen > 1000000 Then RecvBufCount = 0: Exit Sub 'reset due to a not plausible JPGSize
    
    JPGStart = Pos + Len(CStr(JPGLen)) + 4 + 15
    If RecvBufCount - JPGStart >= JPGLen Then
      DrawJPGBuf JPGLen, pRecvBuf + JPGStart
      'now shift the InBuffer-Content
      RecvBufCount = RecvBufCount - (JPGStart + JPGLen)
      RtlMoveMemory ByVal pRecvBuf, ByVal pRecvBuf + JPGStart + JPGLen, RecvBufCount
      FPS = FPS + 1
      
      ''just in case you want to save the received JPG to a file:
  '      ReDim B(JPGLen - 1)
  '      RtlMoveMemory B(0), ByVal pRecvBuf + JPGStart, JPGLen
  '      Open "c:\theimg.jpg" For Binary As 1
  '      Put 1, , B
  '      Close 1
    End If
  End If
End Sub

Private Sub DrawJPGBuf(ByVal JPGSize&, ByVal pJPGBuf&)
Dim W&, H&, BI As BITMAPINFOHEADER
  GetJPGDimensions JPGSize, pJPGBuf, W, H
  If JPGBuf2RGB24DIB(JPGSize, pJPGBuf, pDIBData, W, H) = 0 Then Exit Sub
  
  BI.biSize = 40
  BI.biBitCount = 24
  BI.biHeight = -H
  BI.biWidth = W
  BI.biPlanes = 1
  With Picture1
    If .Width <> W + 4 Or .Height <> H + 4 Then
      .Move .Left, .Top, W + 4, H + 4
    End If
    StretchDIBits .hdc, 0, 0, W, H, 0, 0, W, H, ByVal pDIBData, BI, 0, vbSrcCopy
  End With
End Sub

Private Sub Client_TCPConnect(ByVal hSocket As Long)
  cmdConnect.BackColor = vbGreen: cmdConnect.Caption = "Disconnect"
  JustConnected = True
  Client.SendData hSocket, StrPtr("init"), 4 'send first "WebPage"-request, to init streaming
End Sub

Private Sub Client_TCPDisConnect(ByVal hSocket As Long)
  hsClient = 0
  cmdConnect.BackColor = vbRed: cmdConnect.Caption = "Connect"
End Sub

Private Sub Client_SockError(ByVal hSocket As Long, ErrString As String)
  Client.Disconnect hSocket
  hsClient = 0
  cmdConnect.BackColor = vbRed: cmdConnect.Caption = "Connect"
End Sub

Private Sub TFPSMeasure_Timer()
  Label1.Caption = "FPS: " & FPS
  FPS = 0
End Sub



