VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cSheet"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Declare Sub RtlMoveMemory Lib "kernel32" (Dst As Any, Src As Any, ByVal Bytes As Long)


Private Const RowShift& = 8192 'that means, we can have a max of 262143 Rows and 8191 columns in our Dictionary
'nonetheless the rest of the implementation here (and in the whole Demo) currently expects ColString-
'identifiers only for SingleChars A-Z ... so please adjust that with appropriate Col-Char-Mappings,
'if you want to use more than 26 Columns

Event RecalcFinished()

Private WithEvents CB As cCircleBreaker
Attribute CB.VB_VarHelpID = -1
Private mD As cSortedDictionary, mEvaluator As cFormula

Private Sub Class_Initialize()
  Set CB = New cCircleBreaker
  
  Set mD = New_c.SortedDictionary
  Set mEvaluator = New_c.Formula
End Sub

Public Property Get CellCount() As Long
  CellCount = mD.Count
End Property

Public Sub Clear()
  mD.RemoveAll
End Sub

Public Property Get CurrentLastRow() As Long 'since we have a sorted Dictionary, this is a nice and fast method (but only for the Rows)
Dim MostRightCellInLastRow As cCell 'dont let the name confuse you - there can be higher Col-Numbers in Rows "above"
  If mD.Count = 0 Then Exit Property
  Set MostRightCellInLastRow = mD.ItemByIndex(mD.Count - 1)
  CurrentLastRow = MostRightCellInLastRow.RowIdx
End Property

Public Sub CellRemove(Addr As String)
Dim AddrLong As Long, UAddr As String
  UAddr = UCase$(Addr)
  AddrLong = RowShift * CLng(Mid$(UAddr, 2)) + CLng(AscW(UAddr) - 64)
  If mD.Exists(AddrLong) Then mD.Remove AddrLong Else Stop
End Sub

Public Property Get Evaluator() As cFormula
  Set Evaluator = mEvaluator
End Property

Public Sub ReCalc()
Dim Cell As cCell
  For Each Cell In mD
    Cell.SetRecalcFlag
  Next Cell
  mEvaluator.ClearVars
  RaiseEvent RecalcFinished
End Sub

Public Property Get Cell(Addr As String) As cCell
Dim AddrLong As Long, UAddr As String
  UAddr = UCase$(Addr)
  AddrLong = RowShift * CLng(Mid$(UAddr, 2)) + CLng(AscW(UAddr) - 64)
  If mD.Exists(AddrLong) Then
    Set Cell = mD.Item(AddrLong)
  Else
    Set Cell = New cCell
    Cell.SetCBAndAddr CB, UAddr
    mD.Add AddrLong, Cell
  End If
End Property

'ensure Proc-Attr to -4, to allow For Each
Public Function Enumerator()
Attribute Enumerator.VB_UserMemId = -4
  Set Enumerator = mD.Enumerator
End Function

Public Sub SaveToDB(Cnn As cConnection, SheetName As String)
Dim Cell As cCell, V, B() As Byte
  Cnn.Execute "Drop Table If Exists [" & SheetName & "]"
  Cnn.Execute "Create Table [" & SheetName & "](Addr Text, FormatString Text, Formula Text, VarType Integer, VarValue Blob)"
  Cnn.DataBases(1).ReScanSchemaInfo 'update the Schema-objectmodel for a later Tbl-listing in the Main-App
  
On Error GoTo RollBack
  Cnn.BeginTrans
    With Cnn.CreateCommand("Insert Into [" & SheetName & "] Values(?,?,?,?,?)")
      For Each Cell In mD
        .SetAllParamsNull
        .SetText 1, Cell.Addr
        .SetText 2, Cell.FormatString
        If Len(Cell.Formula) Then
         .SetText 3, Cell.Formula
         .Execute 'we only .Execute the Command, if either a Formula or a Value are in the Cell
        ElseIf Not IsEmpty(Cell.Value) Then
          V = Cell.Value
          .SetInt32 4, VarType(V)
          If VarType(V) = vbString Then
            B = V 'convert the string-content to a ByteArray
            .SetBlob 5, B
          Else
            .SetBlobPtr 5, VarPtr(V), 16
          End If
          .Execute
        End If
      Next Cell
    End With
  Cnn.CommitTrans
Exit Sub
RollBack:
  Cnn.RollbackTrans
End Sub

Public Sub LoadFromDb(Cnn As cConnection, SheetName As String)
Dim i As Long, Rs As cRecordset, VType As Long, B() As Byte, S$, V
  mD.RemoveAll
  Set Rs = Cnn.OpenRecordset("Select * From [" & SheetName & "]")
  
  For i = 0 To Rs.RecordCount - 1
    With Cell(Rs.ValueMatrix(i, 0))
      .FormatString = Rs.ValueMatrix(i, 1)
      If Len(Rs.ValueMatrix(i, 2)) Then 'we have a Formula
        .Formula = Rs.ValueMatrix(i, 2)
      Else
        VType = Rs.ValueMatrix(i, 3)
        If VType = vbString Then 'handle the Blob-Field appropriately
          S = Rs.ValueMatrix(i, 4) 'convert from a ByteArray to a String directly
          .Value = S
        Else
          B = Rs.ValueMatrix(i, 4)
          If UBound(B) = 15 Then RtlMoveMemory ByVal VarPtr(V), B(0), 16
          .Value = V
        End If
      End If
    End With
  Next i
End Sub

'this is not handled in the Evaluator, instead we do it "by hand" in this class
Friend Function CalcSum(SumDef As String) As Double
Dim Args() As String, i As Long, j As Long, AddrLong As Long, Cell As cCell
Dim ColLeft As Long, ColRight As Long, RowTop As Long, RowBottom As Long
  Args = Split(SumDef, "_")
  If UBound(Args) < 2 Then Exit Function
  
  ColLeft = Asc(Args(1)) - 64
  ColRight = Asc(Args(2)) - 64
  RowTop = Mid$(Args(1), 2)
  RowBottom = Mid$(Args(2), 2)
  
  For i = ColLeft To ColRight
    For j = RowTop To RowBottom
      AddrLong = RowShift * j + i
      If mD.Exists(AddrLong) Then
        Set Cell = mD.Item(AddrLong)
        CalcSum = CalcSum + Cell.Value
      End If
    Next j
  Next i
End Function

'the CircleBreaker-Event (to allow ParentSheet-access for our Cells)
Private Sub CB_GetSheet(Sheet As cSheet)
  Set Sheet = Me
End Sub
