VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Begin VB.Form fUndoTest 
   Caption         =   "Undo Demo"
   ClientHeight    =   6465
   ClientLeft      =   60
   ClientTop       =   405
   ClientWidth     =   11760
   LinkTopic       =   "Form1"
   ScaleHeight     =   431
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   784
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton cmdUndo 
      Caption         =   "< Undo"
      Enabled         =   0   'False
      Height          =   315
      Left            =   60
      TabIndex        =   4
      TabStop         =   0   'False
      Top             =   90
      Width           =   735
   End
   Begin VB.CommandButton cmdRedo 
      Caption         =   "Redo >"
      Enabled         =   0   'False
      Height          =   315
      Left            =   840
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   90
      Width           =   735
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "Save To DB"
      Height          =   315
      Left            =   1650
      TabIndex        =   1
      Top             =   90
      Width           =   1455
   End
   Begin MSDataGridLib.DataGrid DG 
      Height          =   2955
      Left            =   180
      TabIndex        =   0
      Top             =   1050
      Width           =   9585
      _ExtentX        =   16907
      _ExtentY        =   5212
      _Version        =   393216
      BorderStyle     =   0
      HeadLines       =   1
      RowHeight       =   15
      TabAction       =   1
      AllowAddNew     =   -1  'True
      AllowDelete     =   -1  'True
      BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ColumnCount     =   2
      BeginProperty Column00 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1031
            SubFormatType   =   0
         EndProperty
      EndProperty
      BeginProperty Column01 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1031
            SubFormatType   =   0
         EndProperty
      EndProperty
      SplitCount      =   1
      BeginProperty Split0 
         BeginProperty Column00 
         EndProperty
         BeginProperty Column01 
         EndProperty
      EndProperty
   End
   Begin VB.Label lblTiming 
      BorderStyle     =   1  'Fest Einfach
      Height          =   285
      Left            =   0
      TabIndex        =   2
      Top             =   510
      Width           =   10725
   End
End
Attribute VB_Name = "fUndoTest"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const InitialRecordCount& = 5000, UndoDepth& = 10

Private DBName$, Cnn As cConnection, WithEvents CurRs As cRecordset
Attribute CurRs.VB_VarHelpID = -1
Private HistoryList As cHistoryList, TopRow As Long, LeftCol As Long
Private UnComprSize As Long, ComprSize As Long

Private Sub Form_Load()
  Me.Show
  Set HistoryList = New cHistoryList
  HistoryList.UndoDepth = UndoDepth
  
  Set Cnn = New_c.Connection
  DBName = App.Path & "\Test.db3"
  If FileExists(DBName) Then
    Cnn.OpenDB DBName
  Else
    Timing Start
    Cnn.CreateNewDB DBName
    CreateTestTable
    InsertDemoData
    Caption = Caption & Timing & " for DB+Table-Creation + " & InitialRecordCount & "Recordsx49Fields Demo-Inserts"
  End If
  
  UpdateViewFromDB
End Sub

Private Sub CreateTestTable()
Dim i&, TableDef As String
  TableDef = "Create Table Test(ID Integer Primary Key," 'starting with an AutoID-Field
  For i = 1 To 16 'and now we add 48 "mixed" Fields (Integer, Text and Date)
    TableDef = TableDef & "Int" & i & " Integer Default " & i & ","
    TableDef = TableDef & "Txt" & i & " Text Default 'Default_" & i & "',"
    TableDef = TableDef & "Dat" & i & " Date" & IIf(i = 16, ")", ",")
  Next i
  Cnn.Execute TableDef
End Sub

Private Sub InsertDemoData()
Dim i&, j&, FldArr(1 To 49) As String
Dim Cmd As cCommand, DblDate As Double, RowTxtPart As String

  'Create a CommandObject from an Insert-Statement for faster Inserts
  For j = 1 To UBound(FldArr): FldArr(j) = "?": Next j
  Set Cmd = Cnn.CreateCommand("Insert Into Test Values(" & Join(FldArr, ",") & ")")
  
  'now the inserts (to stress the State-CompressionFeature a bit, we ensure
  'that each of the inserted FieldValues is unique in this initial TableContent
  DblDate = Now
  Cnn.BeginTrans
    Cmd.SetNull 1 'for our AutoID-Field
    For i = 1 To InitialRecordCount 'create a bunch of records
      RowTxtPart = ", Row-Index " & i
      For j = 1 To 16
        Cmd.SetInt32 3 * j - 1, j * 100000 + i
        Cmd.SetText 3 * j, "Text " & j & RowTxtPart
        Cmd.SetDate 3 * j + 1, DblDate + j - 1 + (i / 86400)
      Next j
      Cmd.Execute
    Next i
  Cnn.CommitTrans
End Sub

'Get a fresh Recordset from the DB and reset our HistoryList,
'followed by our first initial State-Saving (respecting the last Scrollposition)
Private Sub UpdateViewFromDB()
  Set CurRs = Cnn.OpenRecordset("Select * From Test")
  Set DG.DataSource = CurRs.DataSource
  DG.Columns(0).Visible = False
  DG.Scroll LeftCol, TopRow 'restore the last Scroll-Position
  HistoryList.Clear
  StoreState TopRow, StateReason.DBRead
End Sub

'Implementation of the Change-Reactions (coming from the Recordset-Events)
Private Sub CurRs_FieldChange(ByVal RowIdxZeroBased As Long, ByVal ColIdxZeroBased As Long)
  StoreState RowIdxZeroBased, StateReason.Update
End Sub
Private Sub CurRs_AddNew(ByVal NewRowIdxZeroBased As Long)
  StoreState NewRowIdxZeroBased, StateReason.AddNew
End Sub
Private Sub CurRs_Delete(ByVal NewRowIdxZeroBased As Long)
  StoreState NewRowIdxZeroBased, StateReason.Delete
End Sub

'Implementation of the State-Handling (save/restore from HistoryList)
Private Sub StoreState(ByVal CurRow As Long, Reason As StateReason)
Dim NewState As cState, B() As Byte
  Timing Start
  
    LeftCol = DG.LeftCol - 1 'reflect the HScroll-Value of the DataGrid
    If DG.Row < 0 Then
      TopRow = CurRow
    Else 'somewhat "weird construction", since the DataGrid has no real VScroll-Reflection
      TopRow = CurRow - CLng((DG.RowTop(DG.Row) - 13.984) / (DG.RowHeight + 1))
    End If
    
    Set NewState = New cState
    B = CurRs.Content
    UnComprSize = UBound(B) + 1
    ComprSize = NewState.SaveContent(B, TopRow, LeftCol, Reason)
    HistoryList.SaveState NewState
    UpdateUndoRedoButtons
  
  'only a Timing-output
  Select Case Reason
    Case StateReason.DBRead: lblTiming = Timing & " Initial-State set after DBRead"
    Case StateReason.Update: lblTiming = Timing & " State saved after Fld-Update"
    Case StateReason.AddNew: lblTiming = Timing & " State saved after AddNew"
    Case StateReason.Delete: lblTiming = Timing & " State saved after Delete"
  End Select
  lblTiming = lblTiming & " (compressed Size=" & CLng(ComprSize / 1024) & "kB, uncompressed=" & CLng(UnComprSize / 1024) & "kB)"
End Sub
Private Function ReStoreState(State As cState)
Dim B() As Byte, Reason As StateReason
  Timing Start
  
    State.GetContent B, TopRow, LeftCol, Reason
    Set DG.DataSource = Nothing
    Set CurRs = New_c.Recordset
    CurRs.Content = B
    Set CurRs.ActiveConnection = Cnn
    Set DG.DataSource = CurRs.DataSource
    DG.Columns(0).Visible = False
    DG.Scroll LeftCol, TopRow 'restore the last Scroll-Position
    UpdateUndoRedoButtons
    
  'only a Timing-output
  Select Case Reason
    Case StateReason.DBRead: lblTiming = Timing & " Initial-State restored (DBRead)"
    Case StateReason.Update: lblTiming = Timing & " State restored (Fld-Update)"
    Case StateReason.AddNew: lblTiming = Timing & " State restored (AddNew)"
    Case StateReason.Delete: lblTiming = Timing & " State restored (Delete)"
  End Select
End Function

'Implementation of the Undo/Redo-Button-Events
Private Sub cmdRedo_Click()
Dim NextState As cState
  Set NextState = HistoryList.NextState
  If Not NextState Is Nothing Then ReStoreState NextState
End Sub
Private Sub cmdUndo_Click()
Dim PreviousState As cState
  Set PreviousState = HistoryList.PreviousState
  If Not PreviousState Is Nothing Then ReStoreState PreviousState
End Sub
Private Sub UpdateUndoRedoButtons()
  cmdRedo.Enabled = HistoryList.RedoEnabled
  cmdUndo.Enabled = HistoryList.UndoEnabled
  cmdSave.Enabled = cmdUndo.Enabled 'if no Undo possible, then we don't need to save to the DB
End Sub

'and the appropriate DB-Save-Button
Private Sub cmdSave_Click()
  CurRs.UpdateBatch
  UpdateViewFromDB
End Sub

Private Sub Form_Resize()
  On Error Resume Next
    lblTiming.Width = ScaleWidth
    DG.Move 0, lblTiming.Top + lblTiming.Height, ScaleWidth, ScaleHeight - lblTiming.Top - lblTiming.Height
  If Err Then Err.Clear
End Sub
