VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Begin VB.Form fTestNWinddhSQLite 
   Caption         =   "dhSQLite: Query-Performance"
   ClientHeight    =   7245
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   8955
   LinkTopic       =   "Form1"
   ScaleHeight     =   7245
   ScaleWidth      =   8955
   StartUpPosition =   3  'Windows-Standard
   Begin VB.Frame fDG 
      Caption         =   "DataGrid"
      Height          =   4875
      Left            =   120
      TabIndex        =   6
      Top             =   2160
      Width           =   8655
      Begin MSDataGridLib.DataGrid DG 
         Height          =   3435
         Left            =   450
         TabIndex        =   7
         Top             =   300
         Width           =   5895
         _ExtentX        =   10398
         _ExtentY        =   6059
         _Version        =   393216
         HeadLines       =   1
         RowHeight       =   15
         BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ColumnCount     =   2
         BeginProperty Column00 
            DataField       =   ""
            Caption         =   ""
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1031
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column01 
            DataField       =   ""
            Caption         =   ""
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1031
               SubFormatType   =   0
            EndProperty
         EndProperty
         SplitCount      =   1
         BeginProperty Split0 
            BeginProperty Column00 
            EndProperty
            BeginProperty Column01 
            EndProperty
         EndProperty
      End
   End
   Begin VB.CheckBox chkSimulateAppServerRequests 
      Caption         =   "Force querying, to work as in Client/AppServer-Scenarios using disconnected Recordsets"
      Height          =   645
      Left            =   6120
      TabIndex        =   5
      Top             =   135
      Width           =   2580
   End
   Begin VB.ListBox lstViews 
      Height          =   1425
      Left            =   3600
      Sorted          =   -1  'True
      TabIndex        =   1
      Top             =   135
      Width           =   2220
   End
   Begin VB.ListBox lstTables 
      Height          =   1425
      Left            =   630
      Sorted          =   -1  'True
      TabIndex        =   0
      Top             =   135
      Width           =   2175
   End
   Begin VB.Label lViews 
      Caption         =   "Views"
      Height          =   240
      Left            =   3105
      TabIndex        =   4
      Top             =   165
      Width           =   555
   End
   Begin VB.Label lTables 
      Caption         =   "Tables"
      Height          =   240
      Left            =   90
      TabIndex        =   3
      Top             =   165
      Width           =   645
   End
   Begin VB.Label lTiming 
      BorderStyle     =   1  'Fest Einfach
      ForeColor       =   &H00FF0000&
      Height          =   330
      Left            =   90
      TabIndex        =   2
      Top             =   1710
      Width           =   8655
   End
End
Attribute VB_Name = "fTestNWinddhSQLite"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'No larger comments here - a simple Demo, which demonstrates
'(dh)SQLites exceptional performance and the ability of the
'dhSQLite-Wrapper, to be bound to ADO-DataSource-Consumers
'(in our case VBs Standard-Datagrid, which has a very good
'"visualizing-performance", since it renders (only) the viewable
'rows as soon as they become available).

'Performancewise - look/compare especially the Timings in
'disconnected Mode (including serialization/deserialization)
'e.g. the Invoices-View, which in "normal" Mode is ca. 3times
'as fast as in the ADO/JET-DemoForm (fTestNWindADO) - running
'in a disconnected scenario, the performance-advantage raises
'to a factor of ca. 6 now.
Option Explicit

'Private DGExt As VBControlExtender, DG As Object 'DataGrid-Variables
Private Cnn As cConnection, Rs As cRecordset, DBName$

Private Sub Form_Load()
Dim Table As cTable, View As cView
  DBName = App.Path & "\NWind.db"
  
  'add the Datagrid dynamically (without using the registry)
'  fMain.AddDataGrid Me, DGExt, DG, fDG
  
  Set Cnn = New_c.Connection
  
  Timing Start
    
    Cnn.OpenDB DBName ', "asdf"
    'Cnn.CompactDataBase
    'Cnn.ReKey '"asdf"
    
    For Each Table In Cnn.DataBases(1).Tables
      If Left$(Table.Name, 7) <> "sqlite_" Then lstTables.AddItem Table.Name
    Next Table
    For Each View In Cnn.DataBases(1).Views
      lstViews.AddItem View.Name
    Next View

  lTiming.Caption = Timing & " to open the DB and to " & _
                    "populate all Lists with the Table- and View-Names"
End Sub

Private Sub lstTables_Click()
  If lstTables.ListIndex = -1 Then Exit Sub Else lstViews.ListIndex = -1
  Screen.MousePointer = 13
    QueryAndVisualize lstTables.Text
  Screen.MousePointer = 0
End Sub

Private Sub lstViews_Click()
  If lstViews.ListIndex = -1 Then Exit Sub Else lstTables.ListIndex = -1
  Screen.MousePointer = 13
    QueryAndVisualize lstViews.Text
  Screen.MousePointer = 0
End Sub

Private Sub QueryAndVisualize(TableOrViewName As String)
Static SW As Boolean: SW = Not SW
  If chkSimulateAppServerRequests.Value = 1 Then 'simulate an Appserver-Scenario using disconnected Rs
    
    Timing Start 'timing starts at the serverside - until the client can do work with the data
    
      'at the serverside:
      Dim ServerCnn As cConnection, ServerRs As cRecordset, BytesToSend() As Byte
      Set ServerCnn = New_c.Connection
      ServerCnn.OpenDB DBName
      
      Set ServerRs = ServerCnn.OpenRecordset("Select * from [" & TableOrViewName & "]")

      BytesToSend = ServerRs.Content 'serialize into Bytes, to send them "over the wire"
      Set ServerRs = Nothing
      Set ServerCnn = Nothing
      'we have done our cleanup at the serverside and are ready to transfer the Bytes

      'simulation of transferring bytes over e.g. TCP/IP ...
      Dim BytesReceived() As Byte
      BytesReceived = BytesToSend

      'Now that our Bytes arrived at the clientside,...
      Set Rs = New_c.Recordset
      Rs.Content = BytesReceived '...we can deserialize them...

    lTiming.Caption = Timing & " for " & Rs.RecordCount & " Records (" & Rs.Fields.Count & " Columns)"
  
  Else '"normal", clientside DB-Requests on an already established Connection
    
    Timing Start
    
      Set Rs = Cnn.OpenRecordset("Select * from [" & TableOrViewName & "]")

    lTiming.Caption = Timing & " for " & Rs.RecordCount & " Records (" & Rs.Fields.Count & " Columns)"
  
  End If
  
  Set DG.DataSource = Rs.DataSource
End Sub

Private Sub Form_Resize()
On Error Resume Next
  fDG.Move 45, (lTiming.Top + lTiming.Height), ScaleWidth - 90, ScaleHeight - (lTiming.Top + lTiming.Height) - 45
  DG.Move 15, 240, fDG.Width - 45, fDG.Height - 255

  lTiming.Move -3, lTiming.Top, ScaleWidth + 6
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Set DG.DataSource = Nothing
  Set Rs = Nothing
  Set Cnn = Nothing
  
 'remove our dynamically added DataGrid
'  Set DG = Nothing
'  Set DGExt = Nothing
'  Controls.Remove "DG"
End Sub

