VERSION 5.00
Begin VB.Form fMain 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "dhSQLite-Demo"
   ClientHeight    =   7365
   ClientLeft      =   1050
   ClientTop       =   420
   ClientWidth     =   2715
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7365
   ScaleWidth      =   2715
   Begin VB.CommandButton bInMemoryStarSchemaShow 
      Caption         =   "InMemory-DB StarSchema-OLAP"
      Height          =   315
      Left            =   90
      TabIndex        =   16
      Top             =   5430
      Width           =   2535
   End
   Begin VB.CommandButton bInMemoryDBFromADORsShow 
      Caption         =   "InMemory-DB from ADO-Rs'"
      Height          =   315
      Left            =   90
      TabIndex        =   15
      Top             =   5070
      Width           =   2535
   End
   Begin VB.CommandButton bInMemoryDBShow 
      Caption         =   "InMemory-DB from serialized Rs'"
      Height          =   315
      Left            =   90
      TabIndex        =   14
      Top             =   4710
      Width           =   2535
   End
   Begin VB.CommandButton bInsertADO 
      Caption         =   "Insert-Performance            ADO"
      Height          =   330
      Left            =   90
      TabIndex        =   13
      Top             =   2100
      Width           =   2535
   End
   Begin VB.CommandButton bInsertSQLite 
      Caption         =   "Insert-Performance    dhSQLite"
      Height          =   330
      Left            =   90
      TabIndex        =   12
      Top             =   1740
      Width           =   2535
   End
   Begin VB.CommandButton bFormulas 
      Caption         =   "Formula-Parser (builtin Functions)"
      Height          =   330
      Left            =   90
      TabIndex        =   11
      Top             =   3810
      Width           =   2535
   End
   Begin VB.CommandButton bFTS2Show 
      Caption         =   "Fulltext-Search-Demo (FTS3)"
      Height          =   330
      Left            =   90
      TabIndex        =   10
      Top             =   4260
      Width           =   2535
   End
   Begin VB.CommandButton bShowUDF 
      Caption         =   "Userdef. Functions/Collations"
      Height          =   330
      Left            =   90
      TabIndex        =   9
      Top             =   3450
      Width           =   2535
   End
   Begin VB.CommandButton bShowMasterDetail 
      Caption         =   "Master-Detail-Demo dhSQLite"
      Height          =   330
      Left            =   90
      TabIndex        =   8
      Top             =   3000
      Width           =   2535
   End
   Begin VB.CommandButton bSort 
      Caption         =   "Local Rs.Sort-Performance"
      Height          =   330
      Left            =   90
      TabIndex        =   6
      Top             =   6930
      Width           =   2535
   End
   Begin VB.CommandButton bConvert 
      Caption         =   "Convert NWind.mdb to NWind.db"
      Height          =   330
      Left            =   90
      TabIndex        =   4
      Top             =   5940
      Width           =   2535
   End
   Begin VB.CommandButton bViewEdit 
      Caption         =   "Simple View-Editor    NWind.db"
      Height          =   330
      Left            =   90
      TabIndex        =   3
      Top             =   2550
      Width           =   2535
   End
   Begin VB.CommandButton bSHowNWinddhSQLite 
      Caption         =   "NWind.db dhSQLite-Performance"
      Height          =   330
      Left            =   90
      TabIndex        =   0
      Top             =   480
      Width           =   2535
   End
   Begin VB.CommandButton bShowNWindADO 
      Caption         =   "NWind.mdb     ADO-Performance"
      Height          =   330
      Left            =   90
      TabIndex        =   1
      Top             =   840
      Width           =   2535
   End
   Begin VB.CommandButton bShowdhSQLiteDC 
      Caption         =   "NWind.db      dhSQLiteDC-Demo"
      Height          =   330
      Left            =   90
      TabIndex        =   2
      Top             =   1290
      Width           =   2535
   End
   Begin VB.Label lVersion 
      Height          =   255
      Left            =   90
      TabIndex        =   7
      Top             =   120
      Width           =   2505
   End
   Begin VB.Label lProgress 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fest Einfach
      Height          =   615
      Left            =   90
      TabIndex        =   5
      Top             =   6270
      Width           =   2520
      WordWrap        =   -1  'True
   End
End
Attribute VB_Name = "fMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'dhSQLite-Demo (Author: Olaf Schmmidt (os@datenhaus.de)
'first published in October 2007 (updated and enhanced
'over time)
'Now all the SQLite-Classes are hosted within dhRichClient3.dll.

'You can use this code (and the three binaries, dhRichClient3.dll,
'sqlite36_engine.dll and DirectCOM.dll) without any restrictions
'in your own apps.

'Credits to the developer(s) of the sqlite-engine
'and to Robert Simpson for the crypt.c-module from his ADO.NET-
'Provider, wich (after some smaller adjustments) compiled very
'well inside a StdCall-adapted VC-Dll-Project (without any .NET-
'dependencies; so don't panic, VBers <g>).

'The split into two parts, the ADO-like COM-Wrapper (dhRichClient)
'and the engine-binary (sqlite36-Standard-Dll) allows me, to
'either recompile a new engine from updated SQLite3-Source or
'update the COM-Wrapper from my own Sources separately.

'The sqlite36_engine.dll is based on UpToDate SQLite3-Source (3.6.12)
'The wrapper has its own Heap-Management for faster
'Mem-Allocs, is at the same speed-level as the fastest COM-wrapper
'I've tested so far (terrainformatica) and is (of course) entirely
'written in VB6. ;-)
'It uses (ObjModel-wise) a mixture of ADO- and DAO- behaviour,
'so you should have no problems, if you are already familiar with
'one of those DB-access-methods. That said, you should get over
'the fact, that the documentation is not ready yet. ;-)
'Meanwhile VBs Object-Explorer (and not at least this demo-app)
'should be your friend.

'For deployment, you have to place only the three toolset-binaries
'beside your Exe-File (but read the comments in modFactory.bas and
'also the comments in the Toolset-Readmes).
'Normally no other dependencies are involved, no ADO and
'neither OLEDB nor JET - as long as you don't use dhSQLites builtin
'ADO-DataBinding-capabilities - then you would need the (normally
'preinstalled) ADO-Runtime and also msbind.dll and dbadapt.dll.

'But this Demo comes with an example of
'an ADO-free Binding-approach (just look at fTestdhSQLiteDC).
'One of the binaries (dhRichClient3.dll) has to be registered, before
'you can use it. For those, who want to instantiate this ActiveX-
'Dll without prior registering - you can use my free DirectCOM.dll
'for this purpose and its GetInstance(FileName, ClassName)-Call
'(just google for it in google-groups or look at the regfree
'factory-instancing from modFactory.bas here in this Demo-Project).
'If you want to use the engine in a real Client/Server-Scenario,
'you can use the superfast serializing-mechanisms of dhSQLite
'together with my free, multithreaded COM-RPCServer (wich has
'builtin encryption+compression). My tests have shown, that a
'complete Roundtrip (SQL-Request over TCP/IP using serialization/
'deserialization of disconnected Recordsets) needs only 2ms for
'smaller Rs (10 Columns, 100 Rows) and ca. 12ms for larger R.Sets
'(ca. 20 Cols on 500 Rows) with both, encryption and compression
'enabled on the RPC-protocol.
'My stress-tests from 4 different LAN-Clients against the RPC-
'Server, hosted on a dual Athlon (2GHz), was showing 320 Req./sec
'(ca. 80 Req./sec on each Client) whilst serving the complete
'[Orders]-Table (830 Rows on 14 Columns) from an SQLite-Version
'of NWind.db (encrypted and compressed, CPU-Load ca. 90%, equal
'on both CPUs). The same test against an NWind.mdb (using ADO/JET)
'was only reaching 40 Req./sec (ca. 10 Req./sec on each Client).
'This means, using SQLite in combination with our COM-RPC-Server,
'you can serve 8 times more users on the same hardware as with
'ADO/JET in a true Client/Server MultiUser-scenario. Mostly due
'to the much faster serialization-performance on the dhSQLite-
'Recordsets, but also because of the faster performing SQLite-
'engine, wich in combination  generates much less processor-load
'than the ADO-based solution.

'Think I should finish now, since a VB-Code-Module can hold only
'65kBytes of Text IIRC ;-) ..., anyway - have fun with SQLite!

'If you have questions or suggestions, feel free to email me,
'or if you think your problem is of public interest, use the
'appropriate VB-Database-newsgroups.

'Now, here we go with the Code of the Main-Form of this Demo,
'wich is mainly only a starter for all the other forms...
'(additional comments inside the appropriate Code-Modules)
Option Explicit

Private WithEvents C As cConverter, FNr&
Attribute C.VB_VarHelpID = -1

Private Sub Form_Load()

  lVersion = "SQLite-Version: " & New_c.Connection.Version
  
  Me.Show
  If Not FileExists(App.Path & "\NWind.db") Then
    ConvertNWind App.Path & "\NWind.mdb", App.Path & "\NWind.db"
  End If
End Sub

Private Sub ConvertNWind(NWindMDBFileName$, SQLiteFileName$)
Dim i&, aCnn As ADODB.Connection, sCnn As cConnection
  On Error Resume Next
  
  Set aCnn = New ADODB.Connection
  aCnn.CursorLocation = adUseClient
  aCnn.Open "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & NWindMDBFileName
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub
  
  Kill SQLiteFileName 'ensure, that we kill the older File first
  Err.Clear
  
  Set sCnn = New_c.Connection
  sCnn.CreateNewDB SQLiteFileName
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub
  
  Set C = New cConverter
  C.ConvertDatabase aCnn, sCnn
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub
  lProgress.Caption = "Table-Schemas created, Table-Data transferred!"
  
  C.ConvertIndexes aCnn, sCnn
  If Err Then MsgBox Err.Description
  lProgress.Caption = "Index-Import finished!"
  
  'Now we add the (prior) manually created SQLite-Views from their Def-Files
  For i = 1 To 10
    Err.Clear
    sCnn.Execute GetTextFromFile(App.Path & "\NWind.db View-Defs\" & i & ".txt")
    If Err Then MsgBox Err.Description
  Next i
  lProgress.Caption = "Manually defined View-Pendants created!"

  'finally we create a backup-table from 'employees' inside the new
  'created SQLite-Database (used inside the DC/DataBinding-Demos)
  Err.Clear
  sCnn.BeginTrans
    sCnn.Execute "Create Table EmployeesBackup As Select * from Employees"
  sCnn.CommitTrans
  If Err Then MsgBox Err.Description: Err.Clear

  Set C = Nothing
End Sub

Private Sub C_IndexProgress(ByVal TableName As String, ByVal IndexName As String, ByVal IndexesCount As Long, ByVal IndexesCreated As Long)
  lProgress.Caption = TableName & " " & IndexesCreated & " / " & IndexesCount
  lProgress.Refresh
End Sub

Private Sub C_InsertProgress(ByVal TableName As String, ByVal RecordCount As Long, ByVal RecordsInserted As Long)
  lProgress.Caption = TableName & " " & RecordsInserted & " / " & RecordCount
  lProgress.Refresh
End Sub

Private Sub bShowNWindADO_Click()
  fTestNWindADO.Show , Me
End Sub
Private Sub bSHowNWinddhSQLite_Click()
  fTestNWinddhSQLite.Show , Me
End Sub

Private Sub bShowdhSQLiteDC_Click()
  fTestdhSQLiteDC.Show , Me
End Sub

Private Sub bViewEdit_Click()
  fViewEdit.Show , Me
End Sub

Private Sub bFormulas_Click()
  fBuiltinFunctions.Show , Me
End Sub

Private Sub bFTS2Show_Click()
  fFTS3.Show , Me
End Sub

Private Sub bInsertADO_Click()
  fInsertsADO.Show , Me
End Sub

Private Sub bInsertSQLite_Click()
  fInsertsdhSQLite.Show , Me
End Sub

Private Sub bShowMasterDetail_Click()
  fMasterDetail.Show , Me
End Sub

Private Sub bShowUDF_Click()
  fUserdefinedFunctions.Show , Me
End Sub

Private Sub bInMemoryDBShow_Click()
  fInMemoryDB.Show , Me
End Sub

Private Sub bInMemoryDBFromADORsShow_Click()
  fInMemoryDBFromADO.Show , Me
End Sub

Private Sub bInMemoryStarSchemaShow_Click()
  fStarSchema.Show , Me
End Sub

Private Sub bSort_Click()
Dim aCnn As Connection, aRs As Recordset
Dim sCnn As cConnection, sRs As cRecordset

  Set aCnn = New ADODB.Connection
  aCnn.CursorLocation = adUseClient
  aCnn.Open "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & App.Path & "\NWind.mdb"
  Set aRs = New Recordset
  aRs.Open "Select * from [Order Details]", aCnn, adOpenStatic, adLockBatchOptimistic
  
  Timing Start
    aRs.Sort = "OrderID DESC, ProductID ASC"
  lProgress.Caption = "ADO-Rs-Sort: " & Timing
  
  'now the same for sqlite
  Set sCnn = New_c.Connection
  sCnn.OpenDB App.Path & "\NWind.db"
  Set sRs = sCnn.OpenRecordset("Select * from [Order Details]")
  
  Timing Start
    sRs.Sort = "OrderID DESC, ProductID ASC"
  lProgress.Caption = lProgress.Caption & vbCrLf & "SQLite-Rs-Sort: " & Timing
  
  'now let's do a small check, if the sort-results are identical
  Do Until aRs.EOF
    If aRs("OrderID") <> sRs("OrderID") Or aRs("ProductID") <> sRs("ProductID") Then MsgBox "Failure: Sort-Results differ"
    aRs.MoveNext: sRs.MoveNext
  Loop
End Sub

Private Sub bConvert_Click()
  ConvertNWind App.Path & "\NWind.mdb", App.Path & "\NWind.db"
End Sub

Private Function GetTextFromFile(FileName$) As String
Dim FNr&: FNr = FreeFile
  Open FileName For Binary Access Read As FNr
  GetTextFromFile = Space(LOF(FNr))
  Get FNr, , GetTextFromFile: Close FNr
End Function

