VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Begin VB.Form fInMemoryDB 
   Caption         =   "InMemory-DB (build from serialized Rs)"
   ClientHeight    =   6330
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   10335
   LinkTopic       =   "Form1"
   ScaleHeight     =   6330
   ScaleWidth      =   10335
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton cmdDump 
      Caption         =   "Dump from NWind.db into InMemory-Tables -->"
      Height          =   315
      Left            =   90
      TabIndex        =   2
      Top             =   120
      Width           =   3705
   End
   Begin VB.ComboBox cmbTables 
      Height          =   315
      Left            =   3900
      Style           =   2  'Dropdown-Liste
      TabIndex        =   1
      Top             =   120
      Width           =   1515
   End
   Begin VB.Frame fDG 
      Caption         =   "DataGrid"
      Height          =   5175
      Left            =   90
      TabIndex        =   0
      Top             =   1020
      Width           =   10125
      Begin MSDataGridLib.DataGrid DG 
         Height          =   4395
         Left            =   270
         TabIndex        =   4
         Top             =   390
         Width           =   8235
         _ExtentX        =   14526
         _ExtentY        =   7752
         _Version        =   393216
         HeadLines       =   1
         RowHeight       =   15
         BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ColumnCount     =   2
         BeginProperty Column00 
            DataField       =   ""
            Caption         =   ""
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1031
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column01 
            DataField       =   ""
            Caption         =   ""
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1031
               SubFormatType   =   0
            EndProperty
         EndProperty
         SplitCount      =   1
         BeginProperty Split0 
            BeginProperty Column00 
            EndProperty
            BeginProperty Column01 
            EndProperty
         EndProperty
      End
   End
   Begin VB.Label lTiming 
      BorderStyle     =   1  'Fest Einfach
      Height          =   330
      Left            =   90
      TabIndex        =   3
      Top             =   540
      Width           =   10125
   End
End
Attribute VB_Name = "fInMemoryDB"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This examples wants to demonstrate, how to use SQLite
'as an InMemory-DBEngine. Working InMemory is in no
'way different than working with a filebased Connection
'(beside the lacking "Disk-Persistence").
'To allow easy dumping from a filebased SQLite-DB to
'an InMemory-one there's now a new builting Method (3/2008)
'in our Cnn-Object, which allows, to create a Table
'directly from selected Rs-Content.
'With this feature you can e.g. select (and transfer)
'disconnected Rs-Content over a dhRPC-Server into your
'Client and directly "move" this serialized Rs-Content
'into memory, resulting in a SQLite-Table with the same
'name you selected it from. Now imagine this for a group
'of related "Selects" - all Rs-Contents transferred within
'only one single and fast RoundTrip (e.g. omitting an
'expensive serverside Join), instead all the related
'Rs-Contents are transferred into the Inmemory-DB and
'joined there - at the clientside.

'This concrete example here demonstrates only a simple
'"Dumping" of all tables inside NWind.db into memory
'using the just described feature with very few lines of code.
Option Explicit

'Private DGExt As VBControlExtender, DG As Object 'DataGrid-Variables
Private DBName As String, Cnn As cConnection, Rs As cRecordset

Private Sub cmdDump_Click()
Dim Tbl As cTable, B() As Byte, CnnSrc As cConnection, RsSrc As cRecordset, T!
  'open a filebased Src-Database (the one we want to dump into memory)
  DBName = App.Path & "\NWind.db"
  Set CnnSrc = New_c.Connection
  CnnSrc.OpenDB DBName
  
  'now the destination-Database (an InMemory-DB)
  Set Cnn = New_c.Connection
  Cnn.CreateNewDB 'without Params the new DB is created inside memory
  
  Timing Start
  cmbTables.Clear
  
  For Each Tbl In CnnSrc.DataBases(1).Tables
    cmbTables.AddItem Tbl.Name
    
    'select the Src-Rs from our Filebased-DB-Connection
    Set RsSrc = CnnSrc.OpenRecordset("Select * from " & Tbl.NameInBrackets)
    
    B = RsSrc.Content 'serialize the SrcRs into a ByteArray
    
    '...
    'B could also be stored in a simple File or as a resource in your Exe
    '...
    
    'here we create a new "memory-table" from our serialzed Rs-Content
    'over the appropriate InMemoryDB-CnnObject. The serialized
    'Rs-Content contains all the information we need for this task.
    'eventually already existing tables with the same name are
    'automatically dropped, before we insert the new table-content
    Cnn.CreateTableFromRsContent B
  Next Tbl
  
  If cmbTables.ListCount Then cmbTables.Tag = "ex": cmbTables.ListIndex = 0

  lTiming.Caption = Timing & " for copying " & CnnSrc.DataBases(1).Tables.Count & _
                    " complete Tables into the InMemory-DB"
End Sub

Private Sub cmbTables_Click()
  If cmbTables.Tag = "ex" Then cmbTables.Tag = "": Exit Sub 'only a Fill-Event-Blocking
  
  'now let's work with the InMemory-DB and -Data from our tables
  Timing Start
    Set Rs = Cnn.OpenRecordset("Select * from [" & cmbTables.Text & "]")
    Set DG.DataSource = Rs.DataSource
  lTiming.Caption = Timing & " for " & Rs.RecordCount & " Records (" & Rs.Fields.Count & " Columns)"
End Sub

Private Sub Form_Resize()
On Error Resume Next
  fDG.Move 45, (lTiming.Top + lTiming.Height), ScaleWidth - 90, ScaleHeight - (lTiming.Top + lTiming.Height) - 45
  DG.Move 15, 240, fDG.Width - 45, fDG.Height - 255
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Set DG.DataSource = Nothing
  Set Rs = Nothing
  Set Cnn = Nothing
End Sub

