VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Begin VB.Form fCube 
   Caption         =   """Cube-like"" Analysis (just focus one of the Combos and use the Scroll-Wheel)"
   ClientHeight    =   9465
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   14850
   LinkTopic       =   "Form1"
   ScaleHeight     =   9465
   ScaleWidth      =   14850
   StartUpPosition =   3  'Windows-Standard
   Begin VB.ComboBox cmb_z 
      Height          =   315
      Left            =   3510
      Style           =   2  'Dropdown-Liste
      TabIndex        =   0
      Top             =   900
      Width           =   3195
   End
   Begin VB.ComboBox cmb_x 
      Height          =   315
      Left            =   3240
      Style           =   2  'Dropdown-Liste
      TabIndex        =   3
      Top             =   8460
      Width           =   2055
   End
   Begin VB.ComboBox cmb_y 
      Height          =   315
      Left            =   150
      Style           =   2  'Dropdown-Liste
      TabIndex        =   1
      Top             =   2130
      Width           =   1635
   End
   Begin MSDataGridLib.DataGrid DG 
      Height          =   6615
      Left            =   1980
      TabIndex        =   2
      TabStop         =   0   'False
      Top             =   1740
      Width           =   11775
      _ExtentX        =   20770
      _ExtentY        =   11668
      _Version        =   393216
      AllowUpdate     =   0   'False
      HeadLines       =   1
      RowHeight       =   15
      BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ColumnCount     =   2
      BeginProperty Column00 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1031
            SubFormatType   =   0
         EndProperty
      EndProperty
      BeginProperty Column01 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1031
            SubFormatType   =   0
         EndProperty
      EndProperty
      SplitCount      =   1
      BeginProperty Split0 
         BeginProperty Column00 
         EndProperty
         BeginProperty Column01 
         EndProperty
      EndProperty
   End
   Begin VB.Line Line1 
      Index           =   5
      X1              =   13710
      X2              =   14910
      Y1              =   1770
      Y2              =   570
   End
   Begin VB.Label lblResult 
      Caption         =   "Result-Rs "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2790
      TabIndex        =   7
      Top             =   1440
      Width           =   9915
   End
   Begin VB.Label Label3 
      Caption         =   "z-Dimension (here only as a time-based Filter)"
      Height          =   345
      Left            =   3960
      TabIndex        =   6
      Top             =   630
      Width           =   3375
   End
   Begin VB.Label Label2 
      Caption         =   "x-Dimension"
      Height          =   255
      Left            =   2070
      TabIndex        =   5
      Top             =   8520
      Width           =   1155
   End
   Begin VB.Label Label1 
      Caption         =   "y-Dimension"
      Height          =   285
      Left            =   180
      TabIndex        =   4
      Top             =   1890
      Width           =   1455
   End
   Begin VB.Line Line1 
      Index           =   4
      X1              =   1980
      X2              =   3180
      Y1              =   1740
      Y2              =   540
   End
   Begin VB.Line Line1 
      Index           =   3
      X1              =   120
      X2              =   1980
      Y1              =   8340
      Y2              =   8340
   End
   Begin VB.Line Line1 
      Index           =   2
      X1              =   120
      X2              =   1980
      Y1              =   1740
      Y2              =   1740
   End
   Begin VB.Line Line1 
      Index           =   1
      X1              =   13740
      X2              =   13740
      Y1              =   8280
      Y2              =   8790
   End
   Begin VB.Line Line1 
      Index           =   0
      X1              =   1980
      X2              =   1980
      Y1              =   8310
      Y2              =   8820
   End
End
Attribute VB_Name = "fCube"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Dimensions As cSortedDictionary
Private StarCnn As cConnection, Rs As cRecordset

Private Sub Form_Load()
  Set StarCnn = fStarSchema.StarCnn 'retrieve the StarCnn from our Parent-Table
  
  Set Dimensions = New_c.SortedDictionary 'instantiate our Dimensions-"ContainerObject"
  
  'create and fill our Dimension-Objects and add them to a Dimensions-Dictionary
  Dim Tbl As cTable, NewDimension As cDimension
  For Each Tbl In StarCnn.DataBases(1).Tables
    If LCase$(Tbl.Name) <> "facts" Then
      Set NewDimension = New cDimension
      NewDimension.Init StarCnn, Tbl
      Dimensions.Add Tbl.Name, NewDimension
    End If
  Next Tbl
  
  'and fill up the x,y Lists
  Dim i As Long
  For i = 0 To Dimensions.Count - 1
    cmb_x.AddItem Dimensions.KeyByIndex(i)
    cmb_y.AddItem Dimensions.KeyByIndex(i)
  Next i
  cmb_x.ListIndex = 0
  cmb_y.ListIndex = 1
  
  'finally construct the z-List (based on the Time-Dimension-Columns)
  FillZList
  cmb_z.ListIndex = 0
End Sub

Private Sub FillZList()
Dim Rs As cRecordset
  'first add an "over all years"-block to the list (with sub-grouping for quarters and months)
  AddZListYearGroup "All Years"
  
  'and now the same grouping-blocks for the concrete years in our Facts-Table
  Set Rs = StarCnn.OpenRecordset("Select Year From Facts Group By Year")
  Do Until Rs.EOF
    AddZListYearGroup "Year " & Rs!Year.Value
    Rs.MoveNext
  Loop
  
  'finally we add the days explicitely add the end of the z-Combo-List
  '(only the days, for which entries exist in the facts-table)
  Set Rs = StarCnn.OpenRecordset("Select Day From Facts Group By Day")
  Do Until Rs.EOF
    cmb_z.AddItem "Day " & StarCnn.GetShortDateString(Rs!Day.Value)
    Rs.MoveNext
  Loop
End Sub

Private Sub AddZListYearGroup(ByVal YearFilter As String)
Dim i As Long
  cmb_z.AddItem YearFilter
  For i = 1 To 4
    cmb_z.AddItem YearFilter & ", Quarter " & i
  Next i
  For i = 1 To 12
    cmb_z.AddItem YearFilter & ", Month " & i
  Next i
End Sub

Private Sub cmb_x_Click()
  PerformQueryOn cmb_x.ListIndex, cmb_y.ListIndex, cmb_z.Text
End Sub

Private Sub cmb_y_Click()
  PerformQueryOn cmb_x.ListIndex, cmb_y.ListIndex, cmb_z.Text
End Sub

Private Sub cmb_z_Click()
  PerformQueryOn cmb_x.ListIndex, cmb_y.ListIndex, cmb_z.Text
End Sub

'and here we perform the "magic" ;-)
Private Sub PerformQueryOn(ByVal ID_x As Long, ByVal ID_y As Long, zText As String)
Dim DimensionX As cDimension, DimensionY As cDimension, TimeFilterZ As String
Dim x As Long, ColumnArr() As String, Cmd As cCommand
  Timing Start
  
    Set DG.DataSource = Nothing
  
    If ID_x < 0 Or ID_y < 0 Or Len(zText) = 0 Then Exit Sub
    
    Set DimensionX = Dimensions.ItemByIndex(ID_x)
    Set DimensionY = Dimensions.ItemByIndex(ID_y)
    
    'first let's create a new (empty) result-table - the columns
    'based on DimensionX, with a leading ColumnHeader for DimensionY -
    'and another additional trailing Column for the Total amount
    ReDim ColumnArr(DimensionX.Entries.Count + 1)
    For x = 0 To DimensionX.Entries.Count - 1
      ColumnArr(x + 1) = "[" & DimensionX.Entries.ItemByIndex(x) & "] Double"
    Next x
    ColumnArr(0) = DimensionY.DimensionTableName & " Text"
    ColumnArr(DimensionX.Entries.Count + 1) = "[Grand Total] Double"
    StarCnn.Execute "Drop Table If Exists Results"
    StarCnn.Execute "Create Table Results (" & Join$(ColumnArr, ",") & ")"
    
    'now create an insert-Command for that table
    For x = 0 To UBound(ColumnArr)
      ColumnArr(x) = "?"
    Next x
    Set Cmd = StarCnn.CreateCommand("Insert Into Results Values(" & Join$(ColumnArr, ",") & ")")
    
    'and here we perform the final population of the "transformed Result-Table"
    
    Set Rs = CreateResultRs(DimensionX, DimensionY, Cmd, GetTimeFilterZ(zText))
    
  lblResult.Caption = "Result-Rs (" & Rs.Fields.Count & " Columns x " & _
                      Rs.RecordCount & " Rows) in " & Timing
  
  PopulateDataGrid 'finally let's bind the Grid to the Rs
End Sub

Private Function GetTimeFilterZ(ByVal z_Text As String)
  z_Text = LCase$(z_Text)
  Select Case Left$(z_Text, 4)
    Case "all "
      If Len(z_Text) > 10 Then
        z_Text = Replace$(z_Text, "all years, ", "", , , vbTextCompare)
        z_Text = Replace$(z_Text, " ", "=", , , vbTextCompare)
        z_Text = z_Text & " AND "
      Else
        z_Text = ""
      End If
    Case "year"
      If Len(z_Text) > 10 Then
        z_Text = Replace$(z_Text, "year ", "year=", , , vbTextCompare)
        z_Text = Replace$(z_Text, " ", "=", , , vbTextCompare)
        z_Text = Replace$(z_Text, ",=", " AND ", , , vbTextCompare)
      Else
        z_Text = Replace$(z_Text, "year ", "year=", , , vbTextCompare)
      End If
      z_Text = z_Text & " AND "
    Case "day "
      z_Text = Replace$(z_Text, " ", "='", , , vbTextCompare)
      z_Text = z_Text & " 00:00:00' AND "
  End Select
  GetTimeFilterZ = z_Text
End Function

Private Function CreateResultRs(DimensionX As cDimension, DimensionY As cDimension, Cmd As cCommand, TimeFilter As String) As cRecordset
Dim x As Long, y As Long, SQL As String, Rs As cRecordset
Dim Idx As Long, Value As Double, Total As Double

  'here we loop over the y-Dimension, to fill in the Rows
  For y = 0 To DimensionY.Entries.Count - 1
    Cmd.SetAllParamsNull 'cleanup first from the previous round
    Cmd.SetText 1, DimensionY.Entries.ItemByIndex(y) 'set the DimensionY-Text on the first Column
    
    'now a Group By Query for the Value-Columns
    If DimensionY.IDFieldIsStringType Then 'enclose the current DimensionY-Entry in apostrophes
        SQL = "Select " & DimensionX.FactsDimensionIDColumn & ", Sum(ExtendedPrice) From Facts Where " & _
                TimeFilter & _
                DimensionY.FactsDimensionIDColumn & " = '" & DimensionY.Entries.KeyByIndex(y) & _
                "' Group By  " & DimensionX.FactsDimensionIDColumn
    Else '
        SQL = "Select " & DimensionX.FactsDimensionIDColumn & ", Sum(ExtendedPrice) From Facts Where " & _
                TimeFilter & _
                DimensionY.FactsDimensionIDColumn & " = " & DimensionY.Entries.KeyByIndex(y) & _
                " Group By  " & DimensionX.FactsDimensionIDColumn
    End If
    Set Rs = StarCnn.OpenRecordset(SQL)
    
    'and the loop, which populates the Row-Values inside our Cmd-Object
    Total = 0
    Do Until Rs.EOF
      If DimensionX.IDFieldIsStringType Then
        Idx = DimensionX.Entries.IndexByKey(CStr(Rs.Fields(0).Value)) + 2
      Else
        Idx = DimensionX.Entries.IndexByKey(CDbl(Rs.Fields(0).Value)) + 2
      End If
      Value = Round(Rs.Fields(1).Value, 2)
      Cmd.SetDouble Idx, Value
      Total = Total + Value
      Rs.MoveNext
    Loop
    
    'finally the last Column-Value (the "Row-Total")...
    Cmd.SetDouble DimensionX.Entries.Count + 2, Round(Total, 2)
    Cmd.Execute '...followed by the Execute against the result-table
  Next y
  
  Set Rs = StarCnn.OpenRecordset("Select * from Results")
  Rs.AddNew 'add the "Grand-Total Row at the end
  Rs.Fields(0).Value = "Grand Total"
  For x = 1 To Rs.Fields.Count - 1
    Total = 0
    For y = 0 To Rs.RecordCount - 2
      Total = Total + Rs.ValueMatrix(y, x)
    Next y
    Rs.Fields(x).Value = Round(Total, 2)
  Next x
  Set CreateResultRs = Rs
End Function

Private Sub PopulateDataGrid()
Dim x As Long

  'set some default-props on the VB6-Datagrid (and remove the former splits)
  If DG.Splits.Count > 1 Then
    DG.Splits.Remove 0
    DG.Splits.Remove 1
  End If
  DG.RecordSelectors = False
  DG.AllowUpdate = False
  
  'set the Rs-Datasource...
  Set DG.DataSource = Rs.DataSource
  For x = 0 To DG.Columns.Count - 1
    DG.Columns(x).Visible = False '...and hide all columns for the moment
  Next x

  With DG.Splits.Add(0) 'add the first "fixed-split" for Column 0
    .RecordSelectors = True
    .Columns(0).Visible = True
    .LeftCol = 0
    .SizeMode = dbgExact
    .Size = .Columns(0).Width
  End With
  With DG.Splits.Add(2) 'add the last "fixed-split" for Column "Grand Total"
    .Columns(.Columns.Count - 1).Visible = True
    .LeftCol = .Columns.Count - 1
    .SizeMode = dbgExact
    .Size = .Columns(0).Width
  End With
  With DG.Splits(1) 'and finally define the rest of the Columns in the middle split
    For x = 1 To .Columns.Count - 2
      .Columns(x).Visible = True
    Next x
  End With
  
  'just some explicite Scrollbar-Settings (the VB6-DG is somewhat picky, if not done this way)
  DG.ScrollBars = dbgBoth
  DG.Splits(0).ScrollBars = dbgHorizontal
  DG.Splits(1).ScrollBars = dbgHorizontal
End Sub
