VERSION 5.00
Begin VB.Form fBuiltinFunctions 
   Caption         =   "Builtin dhSQLite-Functions"
   ClientHeight    =   9075
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   10365
   LinkTopic       =   "Form1"
   ScaleHeight     =   9075
   ScaleWidth      =   10365
   StartUpPosition =   3  'Windows-Standard
   Begin VB.TextBox tY2 
      Alignment       =   2  'Zentriert
      Height          =   255
      Left            =   810
      TabIndex        =   22
      Text            =   "1"
      Top             =   4260
      Width           =   495
   End
   Begin VB.TextBox tY1 
      Alignment       =   2  'Zentriert
      Height          =   285
      Left            =   810
      TabIndex        =   21
      Text            =   "-1"
      Top             =   4620
      Width           =   495
   End
   Begin VB.TextBox tX2 
      Alignment       =   2  'Zentriert
      Height          =   285
      Left            =   1380
      TabIndex        =   19
      Text            =   "10"
      Top             =   4440
      Width           =   495
   End
   Begin VB.TextBox tX1 
      Alignment       =   2  'Zentriert
      Height          =   285
      Left            =   240
      TabIndex        =   18
      Text            =   "-10"
      Top             =   4440
      Width           =   495
   End
   Begin VB.TextBox tPlotFormula 
      Height          =   315
      Left            =   2190
      TabIndex        =   17
      Text            =   "Sin(x)"
      Top             =   4425
      Width           =   3435
   End
   Begin VB.CommandButton bPlot 
      Caption         =   "Plot"
      Height          =   315
      Left            =   5670
      TabIndex        =   16
      Top             =   4440
      Width           =   735
   End
   Begin VB.PictureBox pPlot 
      BackColor       =   &H00FFFFFF&
      ForeColor       =   &H00FF0000&
      Height          =   3960
      Left            =   150
      ScaleHeight     =   3900
      ScaleWidth      =   9975
      TabIndex        =   15
      Top             =   4980
      Width           =   10035
   End
   Begin VB.Frame frame 
      Caption         =   "Date- and Conversion-Functions"
      Height          =   1215
      Index           =   2
      Left            =   120
      TabIndex        =   10
      Top             =   2790
      Width           =   10000
      Begin VB.CommandButton bEvaluate 
         Caption         =   "Evaluate -->"
         Height          =   345
         Index           =   2
         Left            =   6510
         TabIndex        =   12
         Top             =   330
         Width           =   1245
      End
      Begin VB.TextBox tFormula 
         Height          =   345
         Index           =   2
         Left            =   150
         TabIndex        =   11
         Text            =   "DateDiff('h', CDbl('2007-06-21'), '2007-06-22')"
         Top             =   330
         Width           =   6255
      End
      Begin VB.Label lFunctions 
         Caption         =   "supported are: DatePart, DateDiff and the builtin Conversion-Functions are: CDbl, CLng, CCur, CDate, CShortDate, Ctime"
         Height          =   315
         Index           =   2
         Left            =   180
         TabIndex        =   14
         Top             =   840
         Width           =   9555
      End
      Begin VB.Label lResult 
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "Result: "
         Height          =   345
         Index           =   2
         Left            =   7800
         TabIndex        =   13
         Top             =   330
         Width           =   2115
      End
   End
   Begin VB.Frame frame 
      Caption         =   "String-Functions"
      Height          =   1215
      Index           =   1
      Left            =   120
      TabIndex        =   5
      Top             =   1470
      Width           =   10000
      Begin VB.TextBox tFormula 
         Height          =   345
         Index           =   1
         Left            =   150
         TabIndex        =   7
         Text            =   "UCase$(Mid$('abc' || 'xyz', Instr('abcxyz', 'cx')))"
         Top             =   330
         Width           =   6255
      End
      Begin VB.CommandButton bEvaluate 
         Caption         =   "Evaluate -->"
         Height          =   345
         Index           =   1
         Left            =   6480
         TabIndex        =   6
         Top             =   330
         Width           =   1245
      End
      Begin VB.Label lResult 
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "Result: "
         Height          =   345
         Index           =   1
         Left            =   7770
         TabIndex        =   9
         Top             =   330
         Width           =   2115
      End
      Begin VB.Label lFunctions 
         Caption         =   "supported are: InStr, Format$, Left$, Mid$, Right$, UCase$ or Upper, LCase$ or Lower"
         Height          =   255
         Index           =   1
         Left            =   180
         TabIndex        =   8
         Top             =   840
         Width           =   6855
      End
   End
   Begin VB.Frame frame 
      Caption         =   "Math-Functions"
      Height          =   1215
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   150
      Width           =   10000
      Begin VB.CommandButton bEvaluate 
         Caption         =   "Evaluate -->"
         Height          =   345
         Index           =   0
         Left            =   6480
         TabIndex        =   2
         Top             =   300
         Width           =   1245
      End
      Begin VB.TextBox tFormula 
         Height          =   345
         Index           =   0
         Left            =   150
         TabIndex        =   1
         Text            =   "ACos(Cos(Atn(1))) - Atn(1)"
         Top             =   330
         Width           =   6255
      End
      Begin VB.Label lFunctions 
         Caption         =   "supported are: Round, Pow, Exp, Log, Log10, Sin, SinH, ASin, Cos, CosH, ACos, Tan, TanH, ATan, Atn, Sgn, Sqr, Sqrt, Fix"
         Height          =   255
         Index           =   0
         Left            =   180
         TabIndex        =   4
         Top             =   810
         Width           =   9705
      End
      Begin VB.Label lResult 
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "Result: "
         Height          =   345
         Index           =   0
         Left            =   7770
         TabIndex        =   3
         Top             =   300
         Width           =   2115
      End
   End
   Begin VB.Label lTiming 
      Height          =   285
      Left            =   6510
      TabIndex        =   20
      Top             =   4485
      Width           =   3555
   End
End
Attribute VB_Name = "fBuiltinFunctions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'dhSQLite supports a set of builtin VB(A)-Functions, which are:

'common -functions
'  IIf
'  IsNull
'
'Date -functions
'  DatePart
'  DateDiff
'
'Conversion -functions
'  CDbl
'  CLng
'  CCur
'  CDate
'  CShortDate
'  CTime
'
'Math -functions
'  Round
'  Pow
'  Exp
'  Log
'  Log10
'  Sin , SinH, ASin
'  Cos , CosH, ACos
'  Tan , TanH, ATan, Atn
'  Sgn
'  Sqr , Sqrt
'  Fix
'
'string-functions
'  InStr
'  Format$
'  Left$ , Mid$, Right$
'  UCase$ , Upper
'  LCase$ , Lower
'  Like (Function- and Operator-override)

Private Cnn As cConnection

Private Sub Form_Load()
  Set Cnn = New_c.Connection
  Cnn.CreateNewDB 'create an InMemory-Database
End Sub

Private Sub bEvaluate_Click(Index As Integer)
Dim Rs As cRecordset
  Set Rs = Cnn.OpenRecordset("Select " & tFormula(Index).Text)
  lResult(Index).Caption = Rs(0)
End Sub

Private Sub bPlot_Click()
Dim x#, xMin#, xMax#, Cmd As cCommand, Rs As cRecordset
  xMin = tX1.Text: xMax = tX2.Text
  
  Cnn.Execute "Drop Table If Exists TPlot"
  Cnn.Execute "Create Table TPlot(x Double)"
  Set Cmd = Cnn.CreateCommand("Insert Into TPlot Values(?)")
  For x = xMin To xMax Step (xMax - xMin) / 999#
    Cmd.SetDouble 1, x
    Cmd.Execute
  Next x
  
  On Error Resume Next
  Timing Start
    Set Rs = Cnn.OpenRecordset("Select x," & tPlotFormula.Text & " From TPlot")
  
    If Err Then
      If InStr(1, Err.Description, "cannot compile", vbTextCompare) Then
        MsgBox "Error in formula"
      Else
        MsgBox Err.Description
      End If
      Err.Clear
      Exit Sub
    End If
  lTiming.Caption = Timing & " to evaluate " & Rs.RecordCount & " values"
  
  PlotRecordsetContent Rs, tY1.Text, tY2.Text
End Sub

Private Sub PlotRecordsetContent(Rs As cRecordset, ByVal yMin#, ByVal yMax#)
Dim i&, xMin#, xMax#, x#, y#, xLast#, yLast#
  pPlot.Cls
  'set coords-range
  xMin = Rs.ValueMatrix(0, 0): xMax = Rs.ValueMatrix(Rs.RecordCount - 1, 0)
  
  pPlot.Scale (xMin, yMax * 1.01)-(xMax, yMin * 1.01)
  pPlot.Line (xMin, 0)-(xMax, 0), vbBlack
  pPlot.Line (0, yMin)-(0, yMax), vbBlack
  
  'now draw the graph
  xLast = xMin: yLast = Rs.ValueMatrix(0, 1)
  For i = 1 To Rs.RecordCount - 1
    x = Rs.ValueMatrix(i, 0): y = Rs.ValueMatrix(i, 1)
    pPlot.Line (xLast, yLast)-(x, y)
    xLast = x: yLast = y
  Next i
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Set Cnn = Nothing
End Sub


