VERSION 5.00
Begin VB.UserControl ucPagePreview 
   AutoRedraw      =   -1  'True
   BackColor       =   &H00808080&
   BorderStyle     =   1  'Fest Einfach
   ClientHeight    =   5295
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   8370
   ScaleHeight     =   353
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   558
   Begin VB.PictureBox picTopFrame 
      Align           =   1  'Oben ausrichten
      BorderStyle     =   0  'Kein
      Height          =   375
      Left            =   0
      ScaleHeight     =   25
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   558
      TabIndex        =   1
      Top             =   0
      Width           =   8370
      Begin VB.CheckBox chkScaleToFit 
         Caption         =   "force fit to Printable Area (normally not needed)"
         Height          =   225
         Left            =   7530
         TabIndex        =   7
         Top             =   90
         Width           =   4095
      End
      Begin VB.ComboBox cmbPages 
         Height          =   315
         Left            =   660
         Style           =   2  'Dropdown-Liste
         TabIndex        =   5
         Top             =   30
         Width           =   1815
      End
      Begin VB.CommandButton cmdPrintCurrent 
         Caption         =   "Print current Page"
         Height          =   315
         Left            =   3870
         TabIndex        =   4
         Top             =   30
         Width           =   1515
      End
      Begin VB.CommandButton cmdPrint 
         Caption         =   "Print all Pages"
         Height          =   315
         Left            =   2670
         TabIndex        =   3
         Top             =   30
         Width           =   1155
      End
      Begin VB.ComboBox cmbPrinters 
         Height          =   315
         Left            =   5430
         Style           =   2  'Dropdown-Liste
         TabIndex        =   2
         Top             =   30
         Width           =   2025
      End
      Begin VB.Label lPages 
         Alignment       =   1  'Rechts
         Caption         =   "Pages:"
         Height          =   255
         Left            =   0
         TabIndex        =   6
         Top             =   90
         Width           =   645
      End
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   50
      Left            =   180
      Top             =   660
   End
   Begin VB.PictureBox picPage 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'Kein
      Height          =   4425
      Left            =   750
      ScaleHeight     =   295
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   423
      TabIndex        =   0
      Top             =   600
      Width           =   6345
   End
End
Attribute VB_Name = "ucPagePreview"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Event PrintDocument(SelectedPrinterObject As Object, ByVal ScaleToFit As Boolean)
Event PrintPage(SelectedPrinterObject As Object, ByVal PgNumber As Long, ByVal ScaleToFit As Boolean)
Event PageChanged(ByVal PgNumber As Long)

Private Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Private Const SWP_NOMOVE = &H2, SWP_NOZORDER = &H4

Private mCurPage As cReportPage

Private Sub cmdPrint_Click()
  If cmbPrinters.ListIndex = -1 Then Exit Sub
  If cmbPages.ListIndex = -1 Then Exit Sub
  
  RaiseEvent PrintDocument(Printers(cmbPrinters.ListIndex), chkScaleToFit.Value = 1)
End Sub

Private Sub cmdPrintCurrent_Click()
Dim PgNumber As Long
  If cmbPrinters.ListIndex = -1 Then Exit Sub
  If cmbPages.ListIndex = -1 Then Exit Sub

  PgNumber = cmbPages.ListIndex + 1
  
  RaiseEvent PrintPage(Printers(cmbPrinters.ListIndex), PgNumber, chkScaleToFit.Value = 1)
End Sub

Private Sub cmbPages_Click()
  If cmbPages.ListIndex < 0 Then Exit Sub
  RaiseEvent PageChanged(cmbPages.ListIndex + 1)
End Sub

Public Sub RefreshPreview(Doc As cReportDocument)
Dim i&
  Cleanup
  cmbPages.Clear
  For i = 1 To Doc.PageCount
    With Doc.GetPage(i)
      cmbPages.AddItem "Page " & i & " (" & Round(.PageWidth, 2) & "x" & Round(.PageHeight, 2) & ")"
    End With
  Next i
  If cmbPages.ListCount Then cmbPages.ListIndex = 0
End Sub

Public Sub RenderPage(Page As cReportPage)
  Set mCurPage = New_c.ReportPage 'create our own local instance from the factory
  mCurPage.EMFContent = Page.EMFContent 'copy the emf-content over from "outside"
  RefreshPage
End Sub

Public Sub Cleanup()
  Set mCurPage = New_c.ReportPage
  picPage.Cls
End Sub

Private Sub Timer1_Timer()
  Timer1.Enabled = False
  RefreshPage
End Sub

Private Sub RefreshPage()
Dim QDIB As cDIB, BBuf As cDIB, BDC As cDC
Dim dx&, dy&, OverScan&
  
  SetSize
  dx = picPage.ScaleWidth: dy = picPage.ScaleHeight
  If dx < 2 Or dy < 2 Then Exit Sub

  Set BBuf = New_c.DIB
  Set BDC = New_c.DC

  OverScan = 1
  If dx < 2560 And dy < 2560 Then OverScan = 2
  If dx < 1280 And dy < 1280 Then OverScan = 4
  
  BBuf.Resize dx * OverScan, dy * OverScan
  BBuf.Fill vbWhite
  BDC.SelectDIB BBuf.hDIB
    mCurPage.RenderTo BDC.hDC, 0, 0, BBuf.dx - 1, BBuf.dy - 1
  BDC.DeSelectDIB
  
  If OverScan = 1 Then Set QDIB = BBuf
  If OverScan > 1 Then Set QDIB = BBuf.GetQuarterDIB
  If OverScan = 4 Then Set QDIB = QDIB.GetQuarterDIB
  
  If OverScan > 1 Then QDIB.Sharpen
  QDIB.DrawTo picPage.hDC
  
  picPage.Refresh
End Sub

Private Sub UserControl_Initialize()
Dim i&, P As Printer
  ScaleMode = vbPixels
  Set mCurPage = New_c.ReportPage
  picPage.AutoRedraw = True
  
  For Each P In Printers
    cmbPrinters.AddItem P.DeviceName
    If Printer.DeviceName = P.DeviceName Then cmbPrinters.ListIndex = i
    i = i + 1
  Next P
End Sub

Private Sub UserControl_Resize()
  DPIDependent_UserControl_ResizeBugCorrection

  picPage.Cls
  SetSize
  Timer1.Enabled = False: Timer1.Enabled = True
End Sub

Private Sub SetSize()
Dim dx&, dy&, TopOffs&, AR#
Const InnerOffs& = 2
  On Error Resume Next
  
  TopOffs = picTopFrame.Height + 1
  dx = (ScaleWidth - 2 * InnerOffs - 1)
  dy = (ScaleHeight - 2 * InnerOffs - 1 - TopOffs)
  AR = mCurPage.AspectRatio
  
  If mCurPage.Landscape Then
    If dy * AR < dx Then
      picPage.Move (dx - dy * AR) / 2 + InnerOffs, InnerOffs + TopOffs, dy * AR, dy
    Else
      picPage.Move InnerOffs, (dy - dx / AR) / 2 + InnerOffs + TopOffs, dx, dx / AR
    End If
  Else
    If dx * AR < dy Then
      picPage.Move InnerOffs, (dy - dx * AR) / 2 + InnerOffs + TopOffs, dx, dx * AR
    Else
      picPage.Move (dx - dy / AR) / 2 + InnerOffs, InnerOffs + TopOffs, dy / AR, dy
    End If
  End If
  
  If Err Then Err.Clear
End Sub

Private Sub DPIDependent_UserControl_ResizeBugCorrection()
Dim Sclmd As Long
On Error Resume Next
  Sclmd = vbTwips
  Sclmd = Extender.Container.ScaleMode
  SetWindowPos hwnd, 0, 0, 0, _
      ScaleX(Extender.Width, Sclmd, vbPixels), _
      ScaleY(Extender.Height, Sclmd, vbPixels), _
      SWP_NOMOVE Or SWP_NOZORDER
If Err Then Err.Clear
End Sub

