VERSION 5.00
Begin VB.Form fPageView 
   Caption         =   "Report-Documents"
   ClientHeight    =   10020
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   15210
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   668
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   1014
   StartUpPosition =   3  'Windows-Standard
   Begin VB.PictureBox picLeftFrame 
      Align           =   3  'Links ausrichten
      Height          =   10020
      Left            =   0
      ScaleHeight     =   664
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   217
      TabIndex        =   1
      Top             =   0
      Width           =   3315
      Begin VB.ComboBox cmbRepType 
         Height          =   315
         ItemData        =   "fPageView.frx":0000
         Left            =   2190
         List            =   "fPageView.frx":000A
         Style           =   2  'Dropdown-Liste
         TabIndex        =   15
         Top             =   3930
         Width           =   1035
      End
      Begin VB.CommandButton cmdCreateNew 
         Caption         =   "Create new Report as -->"
         Height          =   315
         Left            =   120
         TabIndex        =   14
         Top             =   3930
         Width           =   2055
      End
      Begin ReportDemo.ucProperty DocProps 
         Height          =   285
         Index           =   0
         Left            =   90
         TabIndex        =   4
         Top             =   690
         Width           =   3105
         _ExtentX        =   4154
         _ExtentY        =   503
      End
      Begin VB.ComboBox cmbDocs 
         Height          =   315
         Left            =   90
         Style           =   2  'Dropdown-Liste
         TabIndex        =   2
         Top             =   30
         Width           =   3135
      End
      Begin ReportDemo.ucProperty DocProps 
         Height          =   285
         Index           =   1
         Left            =   90
         TabIndex        =   5
         Top             =   990
         Width           =   3105
         _ExtentX        =   4101
         _ExtentY        =   503
      End
      Begin ReportDemo.ucProperty DocProps 
         Height          =   285
         Index           =   2
         Left            =   90
         TabIndex        =   6
         Top             =   1290
         Width           =   3105
         _ExtentX        =   4101
         _ExtentY        =   503
      End
      Begin ReportDemo.ucProperty DocProps 
         Height          =   285
         Index           =   3
         Left            =   90
         TabIndex        =   7
         Top             =   1590
         Width           =   3105
         _ExtentX        =   4101
         _ExtentY        =   503
      End
      Begin ReportDemo.ucProperty DocProps 
         Height          =   285
         Index           =   4
         Left            =   90
         TabIndex        =   8
         Top             =   1890
         Width           =   3105
         _ExtentX        =   4101
         _ExtentY        =   503
      End
      Begin ReportDemo.ucProperty DocProps 
         Height          =   285
         Index           =   5
         Left            =   90
         TabIndex        =   9
         Top             =   2190
         Width           =   3105
         _ExtentX        =   4101
         _ExtentY        =   503
      End
      Begin ReportDemo.ucProperty DocProps 
         Height          =   285
         Index           =   6
         Left            =   90
         TabIndex        =   10
         Top             =   2490
         Width           =   3105
         _ExtentX        =   4101
         _ExtentY        =   503
      End
      Begin ReportDemo.ucProperty DocProps 
         Height          =   285
         Index           =   7
         Left            =   90
         TabIndex        =   11
         Top             =   2790
         Width           =   3105
         _ExtentX        =   4101
         _ExtentY        =   503
      End
      Begin ReportDemo.ucProperty DocProps 
         Height          =   285
         Index           =   8
         Left            =   90
         TabIndex        =   12
         Top             =   3090
         Width           =   3105
         _ExtentX        =   4101
         _ExtentY        =   503
      End
      Begin ReportDemo.ucProperty DocProps 
         Height          =   285
         Index           =   9
         Left            =   90
         TabIndex        =   13
         Top             =   3390
         Width           =   3105
         _ExtentX        =   4101
         _ExtentY        =   503
      End
      Begin VB.Label lTiming 
         Height          =   1005
         Left            =   120
         TabIndex        =   16
         Top             =   4440
         Width           =   3045
      End
      Begin VB.Label Label1 
         Caption         =   "Reportdocument-Properties"
         Height          =   315
         Left            =   120
         TabIndex        =   3
         Top             =   450
         Width           =   2235
      End
   End
   Begin ReportDemo.ucPagePreview ucPagePreview1 
      Height          =   6765
      Left            =   5160
      TabIndex        =   0
      Top             =   870
      Width           =   7620
      _ExtentX        =   13441
      _ExtentY        =   11933
   End
End
Attribute VB_Name = "fPageView"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Cnn As cConnection, DBName$
Private oReport As cMyReport

Private Sub Form_Load()
  DBName = App.Path & "\Data.db"

  Set Cnn = New_c.Connection
  Cnn.OpenDB DBName

'comment the following two lines in, to remove the
'ReportDocuments-Table from the DB and compact the DB
'  Cnn.Execute "Drop Table ReportDocuments"
'  Cnn.CompactDataBase

  Cnn.Execute "Create Table If Not Exists ReportDocuments(" & _
                                          "ID Integer Primary Key," & _
                                          "Content Blob," & _
                                          "ReportType Text," & _
                                          "ReportDate Date," & _
                                          "Company Text," & _
                                          "Section Text," & _
                                          "LaunchTo Text," & _
                                          "Size Text," & _
                                          "RunType Text," & _
                                          "RunDate Date," & _
                                          "JobNumber Text," & _
                                          "FooterLeft Text)"

  'some inits, if there's nothing yet in the DB
  Set oReport = New cMyReport
  DocProps(0).Init "ReportType", "Weld", False
  DocProps(1).Init "ReportDate", CStr(Now), False
  DocProps(2).Init "Company", "Some Company"
  DocProps(3).Init "Section", "Some Section"
  DocProps(4).Init "LaunchTo", "Some Trap"
  DocProps(5).Init "Size", "Some Size"
  DocProps(6).Init "RunType", "Some Type"
  DocProps(7).Init "RunDate", CStr(Now)
  DocProps(8).Init "JobNumber", "Some Number"
  DocProps(9).Init "FooterLeft", "Pipeline Deformation List"
  
  cmbRepType.ListIndex = 0

  RefreshDocList
End Sub

Private Sub Form_Resize()
  On Error Resume Next
    ucPagePreview1.Move picLeftFrame.Width + 1, 0, ScaleWidth - picLeftFrame.Width - 1, ScaleHeight
  If Err Then Err.Clear
End Sub

Private Sub cmbDocs_Click()
Dim B() As Byte, RsDoc As cRecordset, i&
  If cmbDocs.ListIndex < 0 Then Exit Sub
  
  Set RsDoc = Cnn.OpenRecordset("Select * From ReportDocuments Where ID = " & cmbDocs.ItemData(cmbDocs.ListIndex))
  B = RsDoc.Fields("Content").Value
  oReport.Doc.Content = B
  For i = 2 To RsDoc.Fields.Count - 1
    DocProps(i - 2).Init RsDoc.Fields(i).Name, RsDoc.Fields(i).Value
  Next i
  ucPagePreview1.RefreshPreview oReport.Doc
End Sub

Private Sub cmbRepType_Click()
  DocProps(0).Text = cmbRepType.Text
End Sub

Private Sub cmdCreateNew_Click()
  Screen.MousePointer = 13
    oReport.Doc.Cleanup
    ucPagePreview1.RefreshPreview oReport.Doc

    Timing Start
      DocProps(0).Text = cmbRepType.Text 'refresh the Report-Type from our combo again
      DocProps(1).Text = Now 'set the Report-Creation-Date to the actual one
      If cmbRepType.Text = "Weld" Then
        oReport.GenerateContent Cnn, False 'less Columns, so we create non-landscape
      Else
        oReport.GenerateContent Cnn, True
      End If
      ucPagePreview1.RefreshPreview oReport.Doc
    lTiming.Caption = Timing & " for Creation"
    
    Timing Start
      SaveCurrentReport
    lTiming.Caption = lTiming.Caption & vbCrLf & Timing & " for DB-Saving"
    
    Timing Start
      RefreshDocList
    lTiming.Caption = lTiming.Caption & vbCrLf & Timing & " for Refresh"
  Screen.MousePointer = 0
End Sub

'reflect the current TextBox-Changes in oReport
'that's possible in that easy way for all Property-Textboxes
'because the Caption matches exactly the propertyname
Private Sub DocProps_Change(Index As Integer)
  CallByName oReport, DocProps(Index).Caption, VbLet, DocProps(Index).Text
End Sub

Private Sub SaveCurrentReport()
Dim RsDocs As cRecordset, Cmd As cCommand, B() As Byte, i&, NewID&

  B = oReport.Doc.Content
  If UBound(B) > 0 Then
    Set RsDocs = Cnn.OpenRecordset("Select * From ReportDocuments Where 0")
    RsDocs.AddNew
    RsDocs.Fields("Content").Value = B
    For i = 2 To RsDocs.Fields.Count - 1
      RsDocs.Fields(i).Value = CallByName(oReport, RsDocs.Fields(i).Name, VbGet)
    Next i
    RsDocs.UpdateBatch
    
  Else
    MsgBox "Nothing to save"
  End If
End Sub

Private Sub ucPagePreview1_PageChanged(ByVal PgNumber As Long)
  ucPagePreview1.RenderPage oReport.Doc.GetPage(PgNumber)
End Sub

Private Sub ucPagePreview1_PrintDocument(SelectedPrinterObject As Object, ByVal ScaleToFit As Boolean)
  oReport.Doc.PrintPages "Envirocal-Document (all Pages)", , SelectedPrinterObject, ScaleToFit
End Sub

Private Sub ucPagePreview1_PrintPage(SelectedPrinterObject As Object, ByVal PgNumber As Long, ByVal ScaleToFit As Boolean)
  oReport.Doc.PrintPages "Envirocal-Document (Page " & PgNumber & ")", PgNumber, SelectedPrinterObject, ScaleToFit
End Sub

Private Sub RefreshDocList()
Dim RsDoc As cRecordset
  cmbDocs.Clear
  Set RsDoc = Cnn.OpenRecordset("Select ID,ReportDate,ReportType From ReportDocuments Order by ReportDate Desc")

  Do Until RsDoc.EOF
    cmbDocs.AddItem RsDoc.Fields("ReportType").Value & " (" & RsDoc.Fields("ReportDate").Value & ")"
    cmbDocs.ItemData(cmbDocs.NewIndex) = RsDoc.Fields("ID").Value
    RsDoc.MoveNext
  Loop
  If cmbDocs.ListCount > 0 Then cmbDocs.ListIndex = 0
End Sub
