VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cMyReport"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'This class acts as an example for a typical Report-Document-Type
'including Headers/Footers, a nice "Logo" + the usual Recordset-Content

Option Explicit

'some constants, wich define the keys for some reusable (during the lifetime of the Doc)
'GDI-Drawing-objects, wich we add in Class_Initialize here
Private Const DefaultFont$ = "DefaultFont"
Private Const BoldFont$ = "BoldFont"
Private Const SmallFont$ = "SmallFont"
Private Const BlackPen_Thin$ = "BlackPen_Thin"
Private Const BlackPen_Mid$ = "BlackPen_Mid"
Private Const HollowBrush$ = "HollowBrush"

'Public Properties, for common Data inside the Report-Document
Public Doc As cReportDocument
Public ReportDate As String
Public ReportType As String
Public Company As String
Public Section As String
Public LaunchTo As String
Public Size As String
Public RunType As String
Public JobNumber As String
Public RunDate As String
Public FooterLeft As String

Private Sub Class_Initialize()
  Set Doc = New_c.ReportDocument
  Doc.SetScaleAndPageDimensions 25.4, 8.5, 11 'set scale to inches and US-Letter-Format

  'generate all the FontObjects we need on Point-Basis
  Doc.AddFont DefaultFont, "Arial", 8.5
  Doc.AddFont BoldFont, "Arial", 9.5, True
  Doc.AddFont SmallFont, "Arial", 7
  
  'generate all the DrawingObjects we need on mm-Basis (wich is the Default-Scale)
  Doc.AddPen BlackPen_Thin, 0.005, vbBlack   '0.005in PenWidth
  Doc.AddPen BlackPen_Mid, 0.015, vbBlack  '0.02in PenWidth
  Doc.AddBrush HollowBrush
  'All those GDI-Objects are automatically cleaned up, if the Document-Object dies
End Sub

Public Sub GenerateContent(Cnn As cConnection, Optional ByVal Landscape As Boolean = True)
Dim FirstPage As cReportPage, Rs As cRecordset
  Set Rs = Cnn.OpenRecordset("Select * From Report_" & ReportType)

  Set FirstPage = Doc.AddPage 'add our "opener-page" to the document

  'now we initialize the page and draw some "MasterPage"-Content
  InitPage FirstPage, Landscape

  'and here we go with our Drawing-Routines, wich begin with the first page,
  'but then there are automatically new pages added if the length of the
  'content makes this necessary
  DrawRsContent FirstPage, Rs, Landscape
  DrawPageNumbers
End Sub

'this routine initializes to either Landscape or normal Page-Orientation
'and it also acts like a Masterpage - here occurs the rendering of the
'default Objects (Logo + some Header/Footer-Content)
Private Sub InitPage(Page As cReportPage, Optional ByVal bLandScape As Boolean = True)  'here we init and draw our Defaults
  With Page
    .InitDrawMode bLandScape

    'draw our "Logo"
    .SelectHandle BlackPen_Thin
    .DrawRectangle 0.25 - 0.015, 0.25, 2 + 0.03, 0.5, 0.12, 0.12
    .DrawImage LoadPicture(App.Path & "\Logo.gif"), 0.25, 0.25, 2, 0.5, True
    
    'draw some Header-Text at "Mid-Top"
    .SelectHandle BoldFont
    .TextOut .PageWidth / 2, 0.28, "Company: " & Company, vbCenter
     .SelectHandle DefaultFont
    .TextOut .PageWidth / 2, 0.45, "Section: " & Section & "  Launch To: " & LaunchTo, vbCenter
    .TextOut .PageWidth / 2, 0.6, "Size: " & Size & "  RunType: " & RunType & "  JobNumber: " & JobNumber, vbCenter

    'draw some Header-Text at the right
    .SelectHandle DefaultFont
    .TextOut .PageWidth - 1.8, 0.45, "Run Date: " & RunDate
    .TextOut .PageWidth - 1.8, 0.6, "Report Date: " & Format$(ReportDate, "yyyy\/mm\/dd")
    
    'and draw some Footer-Text
    .TextOutBaseLine 0.3, .PageHeight - 0.25, FooterLeft
    
    'some horizontal lines - just for "great design" ;-)
    .SelectHandle BlackPen_Mid
    .DrawLine 0.1, 1, .PageWidth - 0.1, 1
    
    .SelectHandle BlackPen_Thin
    .DrawLine 0.1, .PageHeight - 0.5, .PageWidth - 0.1, .PageHeight - 0.5
  End With
End Sub

Private Sub DrawRsContent(Page As cReportPage, Rs As cRecordset, Optional ByVal bLandScape As Boolean = True)
Dim YStart#, XStart#, RowHeight#, RenderedRecords&
  If Rs Is Nothing Then Exit Sub
  
  'Draw the RsContent
  XStart = 0.5 'Left Border-Offset
  YStart = 1.2 'Top-Offset on the first Page (if we have other content below the headers)
  Rs.MoveFirst

  RenderRsHeader Page, Rs, XStart, YStart
  Do
    RenderRsRecords Page, Rs, XStart, YStart, RenderedRecords
    If Rs.EOF Then Exit Do

    'if not yet at the last record, then create a new page and repeat
    Set Page = Doc.AddPage
    InitPage Page, bLandScape  'init and set the "Master-Page-Defaults"
    XStart = 0.5 'Left Border-Offset
    YStart = 1.2 'Top-Offset on our just created new page
    RenderRsHeader Page, Rs, XStart, YStart
  Loop
End Sub

Private Sub RenderRsHeader(Page As cReportPage, Rs As cRecordset, XStart#, YStart#)
Dim i&, RowHeight#, BottomLimit#
  RowHeight = 0.16
  BottomLimit = Page.PageHeight - (XStart + RowHeight + 0.16)
  If (YStart + RowHeight > BottomLimit) Then Exit Sub
  
  Page.SelectHandle DefaultFont, vbBlack
  YStart = YStart + 0.1 'spare some space for a comment-line above the header
  
  'Draw the Header
  Page.SelectHandle BlackPen_Thin
  Page.SelectHandle HollowBrush
  
  For i = 0 To Rs.Fields.Count - 1
    Page.DrawGradient &HE8E8E8, &HC8C8C8, XStart + i * 1, YStart, 1, RowHeight, , , True
    Page.DrawCell XStart + i * 1, YStart, 1, RowHeight, Rs.Fields(i).Name, True, vbCenter, 0.02
  Next i
  YStart = YStart + RowHeight
End Sub

Private Sub RenderRsRecords(Page As cReportPage, Rs As cRecordset, XStart#, YStart#, RenderedRecords&)
Dim RowHeight#, BottomLimit#, RecordStart&, CommentY#, i&, Alignment As AlignmentConstants
  RowHeight = 0.127
  BottomLimit = Page.PageHeight - (XStart + RowHeight)
  Page.SelectHandle BlackPen_Thin
  Page.SelectHandle SmallFont, vbBlack
  
  RecordStart = RenderedRecords
  CommentY = YStart - 0.31 'the Offset, where the Table-Description-Row will be added
  Do Until Rs.EOF Or (YStart + RowHeight > BottomLimit)
    'render the current record as an appropriate table-row
    If Rs.BOF Then Rs.MoveFirst
    For i = 0 To Rs.Fields.Count - 1
      If i = 0 Then Alignment = vbCenter Else Alignment = vbRightJustify 'if first Col then center, else right-aligned
      Page.DrawCell XStart + i * 1, YStart, 1, RowHeight, Rs(i).Value, True, Alignment, 0.015
    Next i
    YStart = YStart + RowHeight
    RenderedRecords = RenderedRecords + 1
    Rs.MoveNext
  Loop
  If RenderedRecords > RecordStart Then
    Page.SelectHandle DefaultFont, vbBlack
    Page.TextOut XStart, CommentY, FooterLeft & " (Records " & RecordStart + 1 & "-" & RenderedRecords & _
                                   " of " & Rs.RecordCount & " total Records)"
  End If
End Sub

Private Sub DrawPageNumbers()
Dim i&
  For i = 1 To Doc.PageCount
    With Doc.GetPage(i)
      .SelectHandle DefaultFont
      .TextOutBaseLine .PageWidth - 0.3, .PageHeight - 0.25, "Page " & i & "/" & Doc.PageCount, vbRightJustify
    End With
  Next i
End Sub
