VERSION 5.00
Begin VB.Form fServerInfo 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "RPC-Server"
   ClientHeight    =   6735
   ClientLeft      =   45
   ClientTop       =   420
   ClientWidth     =   6150
   Icon            =   "fServerInfo.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6735
   ScaleWidth      =   6150
   StartUpPosition =   3  'Windows-Standard
   Begin VB.Timer tmrCheck 
      Enabled         =   0   'False
      Interval        =   400
      Left            =   5490
      Top             =   240
   End
   Begin VB.Frame frStatus 
      Caption         =   "Status-Informations"
      Height          =   6495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   5910
      Begin VB.CheckBox chkBroadCast 
         Caption         =   "BroadCast ServerIP"
         Height          =   285
         Left            =   3870
         TabIndex        =   18
         Top             =   570
         Value           =   1  'Aktiviert
         Width           =   1845
      End
      Begin VB.TextBox tClientConnects 
         Height          =   3840
         Left            =   150
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertikal
         TabIndex        =   1
         TabStop         =   0   'False
         Top             =   2475
         Width           =   5580
      End
      Begin VB.VScrollBar scrThreads 
         Enabled         =   0   'False
         Height          =   270
         Left            =   5130
         Max             =   64
         Min             =   1
         TabIndex        =   2
         TabStop         =   0   'False
         Top             =   1290
         Value           =   60
         Width           =   315
      End
      Begin VB.Label Label2 
         Caption         =   "Server listens on:"
         Height          =   240
         Left            =   135
         TabIndex        =   16
         Top             =   585
         Width           =   1320
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   2
         Left            =   780
         TabIndex        =   15
         Top             =   810
         Width           =   5040
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   1
         Left            =   1485
         TabIndex        =   14
         Top             =   585
         Width           =   4380
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   5
         Left            =   1440
         TabIndex        =   13
         Top             =   1755
         Width           =   570
      End
      Begin VB.Label Label10 
         Caption         =   "Responses/Sec:"
         Height          =   240
         Left            =   135
         TabIndex        =   12
         Top             =   1755
         Width           =   1275
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   0
         Left            =   135
         TabIndex        =   11
         Top             =   360
         Width           =   5730
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   4
         Left            =   1890
         TabIndex        =   10
         Top             =   1530
         Width           =   435
      End
      Begin VB.Label Label7 
         Caption         =   "Current JobQueue-Size:"
         Height          =   240
         Left            =   135
         TabIndex        =   9
         Top             =   1530
         Width           =   1755
      End
      Begin VB.Label Label6 
         Caption         =   "---->    Change ThreadPoolSize to:"
         Height          =   240
         Left            =   2250
         TabIndex        =   8
         Top             =   1305
         Width           =   2505
      End
      Begin VB.Label lblPoolSize 
         Alignment       =   1  'Rechts
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fest Einfach
         Height          =   255
         Left            =   4725
         TabIndex        =   7
         Top             =   1290
         Width           =   375
      End
      Begin VB.Label Label4 
         Caption         =   "Current ThreadPool-Size:"
         Height          =   240
         Left            =   135
         TabIndex        =   6
         Top             =   1305
         Width           =   1815
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   6
         Left            =   1530
         TabIndex        =   5
         Top             =   2250
         Width           =   555
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   3
         Left            =   1935
         TabIndex        =   4
         Top             =   1305
         Width           =   330
      End
      Begin VB.Label Label1 
         Caption         =   "Connected Clients:"
         Height          =   240
         Left            =   135
         TabIndex        =   3
         Top             =   2250
         Width           =   1395
      End
      Begin VB.Label Label3 
         Caption         =   "UpTime:"
         Height          =   240
         Left            =   135
         TabIndex        =   17
         Top             =   810
         Width           =   690
      End
   End
End
Attribute VB_Name = "fServerInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'A HostString of "" ensures, that the local default-IP of
'this machine is used. But if your Host-PC has more than
'one Net-Adapter or more than one IP defined, simply change
'to the appropriate IP
Private Const Host$ = ""

'22222 is the dhRPC-Default-Port, but if your Host-PC has no
'WebServer running, then you can also use Port 80.
'This way you would avoid eventual blocking of Clientside
'FireWalls, because (unlike Port 22222) the http-Port 80 is
'usually allowed for outgoing requests (Web-Browsing)
Private Const Port& = 22222

Private ThreadPoolSize As Long
Private RPCListener As cRPCListener, WithEvents Cnn As cRPCConnection
Attribute Cnn.VB_VarHelpID = -1
Private UDP As cUDP, BrIPBytes(3) As Byte

Private Sub Form_Load()
  On Error Resume Next
  
  'first we instantiate the real server here in this Process
  Set RPCListener = New_c.RPCListener
  
  'and here we instantiate an internal ClientConnection-Object
  'which is there, to retrieve Status-infos from our running
  'Server-Instance from above (over the RPC-mechanism itself)
  Set Cnn = New_c.RPCConnection
  
  If RPCListener Is Nothing Or Cnn Is Nothing Then
    MsgBox "Couldn't instantiate RPC-Objects"
    Unload Me: Exit Sub
  End If
  
  If RPCListener.StartServer(Host, Port) Then 'this actually starts the server
    Caption = Caption & " (running)"
  End If
  
  'and here we define the needed clientside Connection-
  'Properties, to be able to "self-connect" and to poll
  'our Status-infos
  'If you don't need these Status-infos, then you can
  'simply omit this clientside RPCConnection-Object
  'and use only the RPC-Listener as shown above...
  'So, to serve "normal clients" you will only need
  'a few lines of code, to setup an RPC-Server (over
  'the Listener-Object)
  Cnn.Host = Host
  Cnn.Port = Port
  Cnn.KeepAlive = True
  Cnn.ServerAuthentication = True
  Cnn.UserName = "RPCServerAdmin"
  Cnn.PassWord = "default"
  Cnn.Connect 0.5
  tmrCheck.Enabled = True
  
  chkBroadCast_Click 'just to set the BroadCasting-feature, according to the current Value
End Sub

Private Sub chkBroadCast_Click()
Dim i&, IP As String, IPParts() As String
  If chkBroadCast.Value = 1 Then
    
    'now we ensure an instance of our "Server-IP-Broadcasting-Class"
    Set UDP = New_c.UDP
    IP = UDP.GetIP(Host)

    'now ensure, where we send to the correct "broadcast-end"
    IPParts = Split(IP, ".")
    For i = 0 To UBound(IPParts)
      BrIPBytes(i) = IPParts(i)
    Next i
    IPParts(3) = 255 'overwrite last part for broadcast
    UDP.RemoteIP = Join(IPParts, ".")
    UDP.RemotePort = Port
    
  Else 'just "switch off" the UDP-Object
    Set UDP = Nothing
  End If
End Sub

Private Sub scrThreads_Change()
  ThreadPoolSize = scrThreads.Max - scrThreads.Value + scrThreads.Min
  lblPoolSize.Caption = ThreadPoolSize
End Sub

Private Sub tmrCheck_Timer()
Dim sCaption$
  tmrCheck.Enabled = False
  On Error Resume Next
  
  'BroadCast the ServerIP (in case we have an UDP-Instance)
  If Not UDP Is Nothing Then UDP.SendData VarPtr(BrIPBytes(0)), 4
  
  If Cnn.IsConnected Then
    UpdateStatus Cnn.GetServerStatus(True, ThreadPoolSize)
    scrThreads.Enabled = True
  Else
    lblState(6).Caption = ""
    Cnn.Connect 0.5
    ClearStatusInfos
    scrThreads.Enabled = False
  End If
  
  tmrCheck.Enabled = True
End Sub

Private Sub UpdateStatus(Status As cRPCStatusInfo)
Dim i&, CInfo As cRPCClientInfo, SArr$()
  If lblPoolSize.Caption = "" Then scrThreads.Value = scrThreads.Max - Status.CurrentThreadPoolSize + scrThreads.Min
  lblState(0).Caption = "Host-Process running with " & Status.ServerAccount & "-Privileges"
  lblState(1).Caption = Status.ServerIPAndPort
  lblState(2).Caption = Status.UpTime
  lblState(3).Caption = Status.CurrentThreadPoolSize
  lblState(4).Caption = Status.JobCount
  lblState(5).Caption = Status.ResponsesPerSecond
  lblState(6).Caption = Status.ClientInfoCount

  If Status.ClientInfoCount = 0 Then tClientConnects.Text = "": Exit Sub

  ReDim SArr(Status.ClientInfoCount - 1)
  For Each CInfo In Status.ClientInfos
    SArr(i) = CInfo.IPAndPort & " " & CInfo.Status
    i = i + 1
  Next CInfo
  tClientConnects.Text = Join(SArr, vbCrLf)
End Sub

Private Sub ClearStatusInfos()
Dim i&
  lblState(0).Caption = "'dhRPCListener' is not running!"
  For i = 1 To 6
    lblState(i).Caption = ""
  Next i
  tClientConnects.Text = ""
End Sub

