Attribute VB_Name = "NTServiceControl"
'This is a code-module from Sergey Merzlikins great
'NTService-examples, which I only somewhat "ripped off"
'because I don't needed all the functionality
Option Explicit

Private Const SERVICE_CONFIG_DESCRIPTION = 1&
Private Const ERROR_SERVICE_DOES_NOT_EXIST = 1060&
Private Const SERVICE_WIN32_OWN_PROCESS = &H10&
Private Const SC_MANAGER_CONNECT = &H1&
Private Const SC_MANAGER_CREATE_SERVICE = &H2&
Private Const STANDARD_RIGHTS_REQUIRED = &HF0000
Private Const SERVICE_QUERY_CONFIG = &H1&
Private Const SERVICE_CHANGE_CONFIG = &H2&
Private Const SERVICE_QUERY_STATUS = &H4&
Private Const SERVICE_ENUMERATE_DEPENDENTS = &H8&
Private Const SERVICE_START = &H10&
Private Const SERVICE_STOP = &H20&
Private Const SERVICE_PAUSE_CONTINUE = &H40&
Private Const SERVICE_INTERROGATE = &H80&
Private Const SERVICE_USER_DEFINED_CONTROL = &H100&
Private Const SERVICE_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED Or _
                                       SERVICE_QUERY_CONFIG Or _
                                       SERVICE_CHANGE_CONFIG Or _
                                       SERVICE_QUERY_STATUS Or _
                                       SERVICE_ENUMERATE_DEPENDENTS Or _
                                       SERVICE_START Or _
                                       SERVICE_STOP Or _
                                       SERVICE_PAUSE_CONTINUE Or _
                                       SERVICE_INTERROGATE Or _
                                       SERVICE_USER_DEFINED_CONTROL)
Private Const SERVICE_AUTO_START As Long = 2
Private Const SERVICE_DEMAND_START As Long = 3
Private Const SERVICE_ERROR_NORMAL As Long = 1
Private Const ERROR_INSUFFICIENT_BUFFER = 122&

Private Enum SERVICE_CONTROL
  SERVICE_CONTROL_STOP = 1&
  SERVICE_CONTROL_PAUSE = 2&
  SERVICE_CONTROL_CONTINUE = 3&
  SERVICE_CONTROL_INTERROGATE = 4&
  SERVICE_CONTROL_SHUTDOWN = 5&
End Enum

Public Enum SERVICE_STATE
  SERVICE_STOPPED = &H1
  SERVICE_START_PENDING = &H2
  SERVICE_STOP_PENDING = &H3
  SERVICE_RUNNING = &H4
  SERVICE_CONTINUE_PENDING = &H5
  SERVICE_PAUSE_PENDING = &H6
  SERVICE_PAUSED = &H7
End Enum

Private Type SERVICE_STATUS
  dwServiceType As Long
  dwCurrentState As Long
  dwControlsAccepted As Long
  dwWin32ExitCode As Long
  dwServiceSpecificExitCode As Long
  dwCheckPoint As Long
  dwWaitHint As Long
End Type

Private Type QUERY_SERVICE_CONFIG
  dwServiceType As Long
  dwStartType As Long
  dwErrorControl As Long
  lpBinaryPathName As Long
  lpLoadOrderGroup As Long
  dwTagId As Long
  lpDependencies As Long
  lpServiceStartName As Long
  lpDisplayName As Long
End Type

Private Type OSVERSIONINFO
  dwOSVersionInfoSize As Long
  dwMajorVersion As Long
  dwMinorVersion As Long
  dwBuildNumber As Long
  dwPlatformId As Long
  szCSDVersion(1 To 128) As Byte
End Type

Private Const VER_PLATFORM_WIN32_NT = 2&

Private Declare Function OpenSCManager Lib "advapi32" Alias "OpenSCManagerW" (ByVal lpMachineName As Long, ByVal lpDatabaseName As Long, ByVal dwDesiredAccess As Long) As Long
Private Declare Function CreateService Lib "advapi32" Alias "CreateServiceW" (ByVal hSCManager As Long, ByVal lpServiceName As Long, ByVal lpDisplayName As Long, ByVal dwDesiredAccess As Long, ByVal dwServiceType As Long, ByVal dwStartType As Long, ByVal dwErrorControl As Long, ByVal lpBinaryPathName As Long, ByVal lpLoadOrderGroup As Long, ByVal lpdwTagId As Long, ByVal lpDependencies As Long, ByVal lpServiceStartName As Long, ByVal lpPassword As Long) As Long
Private Declare Function DeleteService Lib "advapi32" (ByVal hService As Long) As Long
Private Declare Function CloseServiceHandle Lib "advapi32" (ByVal hSCObject As Long) As Long
Private Declare Function OpenService Lib "advapi32" Alias "OpenServiceW" (ByVal hSCManager As Long, ByVal lpServiceName As Long, ByVal dwDesiredAccess As Long) As Long   '** Change Service_Name as needed
Private Declare Function QueryServiceConfig Lib "advapi32" Alias "QueryServiceConfigW" (ByVal hService As Long, lpServiceConfig As QUERY_SERVICE_CONFIG, ByVal cbBufSize As Long, pcbBytesNeeded As Long) As Long
Private Declare Function QueryServiceStatus Lib "advapi32" (ByVal hService As Long, lpServiceStatus As SERVICE_STATUS) As Long
Private Declare Function ControlService Lib "advapi32" (ByVal hService As Long, ByVal dwControl As SERVICE_CONTROL, lpServiceStatus As SERVICE_STATUS) As Long
Private Declare Function StartService Lib "advapi32" Alias "StartServiceW" (ByVal hService As Long, ByVal dwNumServiceArgs As Long, ByVal lpServiceArgVectors As Long) As Long
Private Declare Function ChangeServiceConfig2 Lib "advapi32" Alias "ChangeServiceConfig2W" (ByVal hService As Long, ByVal dwInfoLevel As Long, lpInfo As Any) As Long

Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" (lpVersionInformation As OSVERSIONINFO) As Long

Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)
Private Declare Function lstrcpyW Lib "kernel32" (ByVal lpString1 As Any, ByVal lpString2 As Any) As Long
Private Declare Function lstrlenW Lib "kernel32" (ByVal lpString As Long) As Long

Private Const Service_Name As String = "dhRPCService"
Private Const Service_Display_Name As String = "dhRPC-Service"
Public Const Service_File_Name As String = "dhRPCService.exe"
Private Const Service_Description As String = "Allows server-side COM-Requests against unregistered ActiveX-Dlls"

Public Path As String, fRPCServer As fRPCServer

Private Sub Main()
  If App.PrevInstance Then Exit Sub
  Path = App.Path: If Right$(Path, 1) <> "\" Then Path = Path & "\"

  Set fRPCServer = New fRPCServer
  On Error Resume Next
    fRPCServer.Show
  If Err Then MsgBox Err.Description
End Sub

Private Function CheckIsNT() As Boolean
Dim OSVer As OSVERSIONINFO
  OSVer.dwOSVersionInfoSize = LenB(OSVer)
  GetVersionEx OSVer
  CheckIsNT = (OSVer.dwPlatformId = VER_PLATFORM_WIN32_NT)
End Function

' This function returns current service status
' or 0 on error
Public Function GetServiceStatus() As SERVICE_STATE
Dim hSCManager As Long, hService As Long, Status As SERVICE_STATUS
  hSCManager = OpenSCManager(0&, 0&, SC_MANAGER_CONNECT)
  If hSCManager Then
    hService = OpenService(hSCManager, StrPtr(Service_Name), SERVICE_QUERY_STATUS)
    If hService Then
      If QueryServiceStatus(hService, Status) Then
        GetServiceStatus = Status.dwCurrentState
      End If
      CloseServiceHandle hService
    End If
    CloseServiceHandle hSCManager
  End If
End Function

Public Function GetServiceConfig() As Long
Dim hSCManager As Long, hService As Long
  hSCManager = OpenSCManager(0&, 0&, SC_MANAGER_CONNECT)
  If hSCManager Then
    hService = OpenService(hSCManager, StrPtr(Service_Name), SERVICE_QUERY_CONFIG)
    If hService Then
      CloseServiceHandle hService
    Else
      GetServiceConfig = Err.LastDllError
    End If
    CloseServiceHandle hSCManager
  Else
    GetServiceConfig = Err.LastDllError
  End If
End Function

' This function installs service on local computer
' It returns nonzero value on error
Public Function SetNTService() As Long
Dim hSCManager As Long, hService As Long, DomainName As String
  If fRPCServer Is Nothing Then Exit Function

  hSCManager = OpenSCManager(0&, 0&, SC_MANAGER_CREATE_SERVICE)
  If hSCManager Then
    'Installs the service for autostart. To set the service to manual start,
    'replace SERVICE_AUTO_START with SERVICE_DEMAND_START
    hService = CreateService(hSCManager, StrPtr(Service_Name), _
                       StrPtr(Service_Display_Name), SERVICE_ALL_ACCESS, _
                       SERVICE_WIN32_OWN_PROCESS, _
                       SERVICE_AUTO_START, SERVICE_ERROR_NORMAL, _
                       StrPtr(Path & Service_File_Name), 0&, _
                       0&, 0&, StrPtr("LocalSystem"), 0)
    If hService Then
      ' Add service description. This will fail on Windows NT, it is reason for On Error.
      On Error Resume Next
      ChangeServiceConfig2 hService, SERVICE_CONFIG_DESCRIPTION, StrPtr(Service_Description)
      On Error GoTo 0
      CloseServiceHandle hService
    Else
      SetNTService = Err.LastDllError
    End If
    CloseServiceHandle hSCManager
  Else
    SetNTService = Err.LastDllError
  End If
End Function

' This function uninstalls the service
' It returns nonzero value on error
Public Function DeleteNTService() As Long
Dim hSCManager As Long, hService As Long, Status As SERVICE_STATUS
  hSCManager = OpenSCManager(0&, 0&, SC_MANAGER_CONNECT)
  If hSCManager Then
    hService = OpenService(hSCManager, StrPtr(Service_Name), SERVICE_ALL_ACCESS)
    If hService Then
      ' Stop service if it is running
      ControlService hService, SERVICE_CONTROL_STOP, Status
      If DeleteService(hService) = 0 Then DeleteNTService = Err.LastDllError
      CloseServiceHandle hService
    Else
      DeleteNTService = Err.LastDllError
    End If
    CloseServiceHandle hSCManager
  Else
    DeleteNTService = Err.LastDllError
  End If
End Function

Public Function StartNTService() As Long
Dim hSCManager As Long, hService As Long
  hSCManager = OpenSCManager(0&, 0&, SC_MANAGER_CONNECT)
  If hSCManager Then
    hService = OpenService(hSCManager, StrPtr(Service_Name), SERVICE_START)
    If hService Then
      If StartService(hService, 0, 0) = 0 Then StartNTService = Err.LastDllError
      CloseServiceHandle hService
    Else
      StartNTService = Err.LastDllError
    End If
    CloseServiceHandle hSCManager
  Else
    StartNTService = Err.LastDllError
  End If
End Function

Public Function StopNTService() As Long
Dim hSCManager As Long, hService As Long, Status As SERVICE_STATUS
  hSCManager = OpenSCManager(0&, 0&, SC_MANAGER_CONNECT)
  If hSCManager Then
    hService = OpenService(hSCManager, StrPtr(Service_Name), SERVICE_STOP)
    If hService Then
      If ControlService(hService, SERVICE_CONTROL_STOP, Status) = 0 Then
        StopNTService = Err.LastDllError
      End If
      CloseServiceHandle hService
    Else
      StopNTService = Err.LastDllError
    End If
    CloseServiceHandle hSCManager
  Else
    StopNTService = Err.LastDllError
  End If
End Function

