VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cWrapcTestMethods"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'Wrapper for the Class 'cTestMethods' in our simple COM-Dll
'(ServerTest.Dll) - which is used in our RPC-Demo:

'There's no need to write this wrapper using the
'Implements-Keyword of VB - but of course one could do it
'this way; especially, if the implemented Interface stays
'constant (Third-Party-Dlls or Binary-Compatibility on
'homegrown Server-Dlls)

'Anyway, we do it "By Hand" (without VBs Implements-Statement)
'here - with some advantages:
'1. You don't need to know about the usage of VBs 'Implements' ;-)
'2. You don't need to implement all Methods of the Interface
'3. You don't have to take care of Binary-Compatibility in
'   your Server-Dlls, as long as the implemented Method-
'   Signatures (ParamTypes, ParamOrder, Result) stay the same.

'------------------------------------------------------------
Option Explicit

'Define our Server-Dlls FileName and the ClassName of the interface,
'that we wrap here:
'The DllName must match the DllName at the Serverside. The Server
'is searching a DllName without Prefix under 'ServerAppPath\RPCDlls\'
'You can define SubDirectories inside 'ServerAppPath\RPCDlls\'
'and place Dlls there - but the DllName needs a Path-Prefix then:
'e.g. - if you place your Dlls in 'ServerAppPath\RPCDlls\Version1.1\',
'then the DllName has to be: "Version1.1\Your.Dll" (BTW - "Reverse-
'Paths" like '..\..\Windows\System32\Some.Dll' are blocked, so the
'Server can only instantiate, what's below 'ServerAppPath\RPCDlls\').
'Of course the Prefix-Part can be handled dynamically (either per
'Module-Global-Variable or per Public-Member inside the WrapperClass).
'The Server doesn't need the registry to instantiate a Dll.
'This feature allows "Side-By-Side-Processing" of Dlls with the same
'ClassName (typically new Versions) - so you don't have to take care
'for Binary-Compatibility. Only the Method-Signatures inside the
'Wrapper-Classes must match.
'If you have new Versions of your Server-Dlls, simply create a new
'Folder e.g. as 'ServerAppPath\RPCDlls\Version1.2\' and copy your
'Binaries over (either "By Hand" during a Server-Session, or using
'a selfwritten RPC-Dll, sitting for example in the ServerRoot under
'ServerAppPath\RPCDlls\MyService.Dll' - running the appropriate
'RPC-MkDir and -Upload-Methods, which are executed at the ClientSide).
'You don't have to shutdown the Server to execute Methods on
'the fresh uploaded Dlls - you simply have to change the PathPrefix
'to 'Version1.2\', which also makes an automatic recognizing inside
'the Client-Application possible (simply check every two seconds with
'a RPC-Call against MyService.Dll, if new "Version-Directories"
'become availabale and switch the PathPrefix, if so).
Public DllName As String, ClassName As String

'One Comment about the usage of the RPC-Connection-Object (Cnn):
'The Cnn-Object is defined outside this Wrapper (instantiated
'and destroyed by our Main-Form) - so we can share it between
'all Private Wrapper-Classes inside our App (and reuse one single
'Server-Connection, which is recommended, to reduce the Count
'of Client-Connections the RPC-Server holds, if Cnn.KeepAlive
'is True (this RPC-Server is currently limited to 1024 parallel and
'permanent Client-Connections).
'Of course you could also instantiate a separate Cnn-Object
'inside of each Wrapper-Class, but that's not necessary (because
'every RPC-Call runs synchronous + a normal VB-App is singlethreaded)
'- so that would be a waste of Client- and Server-Resources.
Private Cnn As cRPCConnection
Private ThreadCollectionParam As Variant

Public Sub SetRPCConnection(ExternalInstantiatedCnn As cRPCConnection)
  Set Cnn = ExternalInstantiatedCnn
End Sub

Private Sub Class_Terminate()
  If Not Cnn Is Nothing Then Set Cnn = Nothing
End Sub

'better set them here (defined Public and not as Const), so we have more
'options regarding Debugging or dynamic Binary-Updates + Versioning
Private Sub Class_Initialize()
  DllName = "ServerTest.dll": ClassName = "cTestMethods"
  ThreadCollectionParam = "dh_ThreadCollection"
End Sub


'************* Method-Implementation starts here **************
'Methods are implemented as seen below:
'Simply Copy'nPaste the exact Method-Signature (Public Function...,
'Public Sub...) from your Server-Dll.
'That's always followed by an 'On Error Resume Next-Statement'
'(Comments to that topic follow - see below)
'Last line finally is the Cnn.RPC()-Call:
'The first two Parameters (DllName and ClassName) are defined
'inside each Wrapper-Class as String-Members.
'They are followed by the MethodName as String-Literal (please, check
'this twice - often the Method-Name of the last copied Cnn.RPC-Call
'stays there "untouched" (at least in my own Strg+C/Strg+V-Sessions ;-)
'Next comes the TimeOut-Parameter:
'Don't use too large TimeOuts (look, the typical RoundTrip-Time for a
'small RPC-Request (KeepAlive=True) is only around 2msec in a LAN,
'15-50msec for DSL-Connections and 80-130msec for Modem-Connections,
'a "normal" ADO-Request (disconnected and serialized RecordSet)
'needs only additional 10-100msec). Even our heaviest SQL-Queries
'never took longer than 2-4 seconds - so if you give the TimeOut more
'than 4-6 seconds, you should have good reasons. The Background is:
'Despite the fact, that the Server execute RPCs in parallel (inside a
'ThreadPool) - a "hanging" Thread is generating massive Processor-Load,
'the other Threads/Clients stay responsive, but their "Responsiveness"
'goes down (resulting in somewhat larger RoundTrip-Times). Sometimes a
'Method-Call is entering an Endless-Loop ("not in my Dlls" you may
'say - but believe me - it happens ;-). So our Server is capable,
'to kick hanging Threads out of the pool (hardly per TerminateThread).
'The ServerTimeOut is our RPC-Client-Timeout + additional 0.5 seconds.
'The Client-App has an example, that demonstrates this "ServerCleanup"
'(BlockingLoop). Of course all other threads inside the Pool are not
'affected by this operation, and no other waiting Job in our JobQueue
'gets lost. The TimeOuts don't need to be increased, if the Application
'has to work over connections with smaller bandwidth, because a
'packedbased retriggering mechanism is implemented. So you can always
'think about TimeOuts as "the time, the serverside COM-Method needs,
'to do its Job".
'But back to the other Parameters: After the Timeout follow all Params
'of the Method-Signature in exact order (passed to a ParamArray).
'Param-Support(10 max): ByRef and ByVal possible - see examples below.
'allowed Types: all SimpleTypes (Long, Boolean, Date, String, Double,
'Currency, etc.) and their arrays (Variant-Arrays can be nested).
'The RPC-Serializer supports Arrays with max. 5 Dimensions (userdefined
'LBounds and UBounds are also transported correctly).
'Strings: -> no ANSI-Conversion is performed - the full, "untouched"
'Unicode-Strings are sent. That gives larger Packets (as long as you
'switched Compression off), but so we avoid problems, if Client and
'Server are runnning under different locales.
'Objects: Our Serializer allows Objects, but only, if they support
'PropertyBag-Serialization (IPersistStream or IPersistStreamInit).
'That is given e.g. for VBs StdPicture-Object or for RecordsetObjects.
'If you want serialized transport of your own userdefined VB-Objects,
'you have to prepare them appropriately (MultiUse = 5 and Persistable = 1
'the Class has to be defined in a separate AX-Dll-Project to allow this).
'For an Example see the Class 'cSerializableTestObj', defined in the
'ServerTest-Dll-Project (not inside our Private WrapperClass).
'I never use selfdefined serializable Objects in my own RPC-Scenarios,
'because they need proper registering of their interfaces on both sides
'(client and server) and that's, where the Dll-Hell (which is avoidable
'with our "RPC-FrameWork") would begin again. So I stick with the Objects
'that support IPersistStream "OutOfTheBox" *and* for which I can normally
'expect an already registered Interface on both sides (that is the case
'for ADO-Recordsets, which of course are heavily used, and for VBs
'StdPicture-Objects, which I don't use very often).
'Anyway, you can look at the cSerializableTestObj-Class, to see, what you
'have to type, to make your own serializable Objects - but I don't write
'an Example-Call here for this Class (because I want to keep the Client-
'Demo and -Calls clean in terms of "Registry-Dependendance" - but a
'Recordset- and a StdPicture-Example is of course inlcuded.
'--------------------------------------------------------------
'Finally some words about the Error-Handling:
'The 'On Error Resume Next'-Statement before each Cnn.RPC()-Call
'initializes a fresh Err.Object, so you don't have to declare an
'additional 'On Error Resume Next' outside (where the WrapperClass
'is used - look at the Form-Code, to see what I mean).
'Do not use Err.Clear after the Cnn.RPC()-Call, so that Errors, raised
'inside Cnn.RPC() can bubble up one level (into our Demo-Form).
'---------------------------------------------------------------
'Ok, here we go with the Method-Wrapping:
'(For comments to the wrapped Methods - see the original Class
''cTestMethods', defined in the 'ServerTest'-AX-Dll-Project) or
'look at the Demo-Form-Code-Button_Clicks, to get more insight.
'---------------------------------------------------------------
Public Function Reflect(S As String) As String
  On Error Resume Next
  Reflect = Cnn.RPC(DllName, ClassName, "Reflect", 4, S)
End Function

Public Sub BlockingLoop(ByVal DurationInSeconds As Long)
  On Error Resume Next
  Cnn.RPC DllName, ClassName, "BlockingLoop", 5, DurationInSeconds
End Sub

Public Sub ErrorCall1()
  On Error Resume Next
  Cnn.RPC DllName, ClassName, "ErrorCall1", 2
End Sub

Public Sub ErrorCall2()
  On Error Resume Next
  Cnn.RPC DllName, ClassName, "ErrorCall2", 2
End Sub

Public Sub ErrorCall3()
  On Error Resume Next
  Cnn.RPC DllName, ClassName, "ErrorCall3", 2
End Sub

Public Function ReturnByteArray(ByVal P1 As Byte, ByVal P2 As Byte) As Byte()
  On Error Resume Next
  ReturnByteArray = Cnn.RPC(DllName, ClassName, "ReturnByteArray", 3, P1, P2)
End Function

Public Sub ByRefSimpleTypes(C As Currency, D As Date, B As Boolean)
  On Error Resume Next
  Cnn.RPC DllName, ClassName, "ByRefSimpleTypes", 3, C, D, B
End Sub

Public Sub ByRefArrayTypes(B() As Byte, S() As String, V())
  On Error Resume Next
  Cnn.RPC DllName, ClassName, "ByRefArrayTypes", 3, B, S, V
End Sub

Public Sub AddOneHundredRecordsTo(Rs As Recordset)
  On Error Resume Next
  Cnn.RPC DllName, ClassName, "AddOneHundredRecordsTo", 3, Rs
End Sub

Public Function GetFirstBitmapIn(SomeServerFolder As String) As StdPicture
Dim ComprRestoreBuf As Boolean
  On Error Resume Next
  ComprRestoreBuf = Cnn.Compression
  Cnn.Compression = True 'let's force Compression here, independent of the actual state
  Set GetFirstBitmapIn = Cnn.RPC(DllName, ClassName, "GetFirstBitmapIn", 5, SomeServerFolder)
  Cnn.Compression = ComprRestoreBuf 'restore the former state of the Compression-Property
End Function

''and finally here comes the wrapping of our Singleton-Interface
'Public Function SingletonCall(ByVal SingletonThreadKey) As Long
'  On Error Resume Next
'  SingletonCall = Cnn.RPC(DllName, ClassName, "SingletonCall", 15, SingletonThreadKey)
'End Function
'
'Public Sub SingletonShowStatusForm(ByVal SingletonThreadKey)
'  On Error Resume Next
'  Cnn.RPC DllName, ClassName, "SingletonShowStatusForm", 5, SingletonThreadKey
'End Sub
'Public Sub SingletonCloseStatusForm(ByVal SingletonThreadKey)
'  On Error Resume Next
'  Cnn.RPC DllName, ClassName, "SingletonCloseStatusForm", 5, SingletonThreadKey
'End Sub

Public Sub SingletonAddEntry(ByVal Key As String, ByVal Entry As String)
On Error Resume Next
  Cnn.RPC DllName, ClassName, "SingletonAddEntry", 5, ThreadCollectionParam, Key, Entry
End Sub
Public Function SingletonGetEntry(ByVal Key As String) As String
On Error Resume Next
  SingletonGetEntry = Cnn.RPC(DllName, ClassName, "SingletonGetEntry", 15, ThreadCollectionParam, Key)
End Function
Public Function SingletonGetCollectionCount() As Long
On Error Resume Next
  SingletonGetCollectionCount = Cnn.RPC(DllName, ClassName, "SingletonGetCollectionCount", 15, ThreadCollectionParam)
End Function
'Ok, that should be enough for a small Demo.
'Excepting the 'GetFirstBitmapIn'-Function, there seems not much to write.
'It looks all the same... time to write a generator for this stuff ;-).
'No kidding, IIRC Eduardo Morcillo has Code for something like
'"COM-Reflection" on his site, which spits out a COM-Class's Method-
'Signatures into a RTF-Box or something like that.
'Hmm, I'll think about it...
