VERSION 5.00
Begin VB.Form fMasterDetail 
   Caption         =   "Master-Detail-Demo (SQLite)"
   ClientHeight    =   7215
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   9495
   Icon            =   "fMasterDetail.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7215
   ScaleWidth      =   9495
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CheckBox chkUseBuiltInServerClass 
      Caption         =   "Use BuiltIn Server-Class"
      Height          =   345
      Left            =   120
      TabIndex        =   6
      Top             =   90
      Value           =   1  'Aktiviert
      Width           =   2115
   End
   Begin VB.ListBox lstOrderDetails 
      Height          =   6300
      Left            =   6180
      TabIndex        =   2
      Top             =   750
      Width           =   3165
   End
   Begin VB.ListBox lstOrders 
      Height          =   6300
      Left            =   4140
      TabIndex        =   1
      Top             =   750
      Width           =   1695
   End
   Begin VB.ListBox lstCustomers 
      Height          =   6300
      Left            =   120
      TabIndex        =   0
      Top             =   750
      Width           =   3645
   End
   Begin VB.Label lOrderDetails 
      Caption         =   "Order Details"
      Height          =   225
      Left            =   6180
      TabIndex        =   5
      Top             =   510
      Width           =   1245
   End
   Begin VB.Label lOrders 
      Caption         =   "Orders (by OrderDate)"
      Height          =   225
      Left            =   4140
      TabIndex        =   4
      Top             =   510
      Width           =   1665
   End
   Begin VB.Label lCustomers 
      Caption         =   "Customers"
      Height          =   225
      Left            =   120
      TabIndex        =   3
      Top             =   510
      Width           =   1095
   End
End
Attribute VB_Name = "fMasterDetail"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const SQLiteDBName$ = "NWind.db"

Private RPCWrapper As cDBAccessWrapper
Private RsCustomers As cRecordset, RsOrders As cRecordset, RsOrderDetails As cRecordset

Private Sub Form_Load()
Dim i As Long, IDIdx As Long, NameIdx As Long
  Set RPCWrapper = New cDBAccessWrapper
  If Not RPCWrapper.Connect(fMain.tHost.Text, fMain.tPort.Text, 2) Then
    MsgBox "Couldn't establish an Appserver-Connection!"
    Exit Sub
  End If
  
  'here we fill our "Base-List" with the Customers
  Set RsCustomers = RPCWrapper.GetRsSQLite(SQLiteDBName, _
      "Select * from Customers Order By CompanyName")
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub
  With RsCustomers
    IDIdx = .Fields("CustomerID").IndexInFieldList
    NameIdx = .Fields("CompanyName").IndexInFieldList
    For i = 0 To .RecordCount - 1
      lstCustomers.AddItem .ValueMatrix(i, IDIdx) & " - " & .ValueMatrix(i, NameIdx)
    Next i
    If lstCustomers.ListCount Then lstCustomers.ListIndex = 0
  End With
End Sub

Private Sub chkUseBuiltInServerClass_Click()
  RPCWrapper.UseBuiltInServerClass = chkUseBuiltInServerClass.Value
End Sub

Private Sub lstCustomers_Click()
Dim CustomerID As String
Dim i As Long, IDIdx As Long, DateIdx As Long
  If RPCWrapper.RPCCnn.WaitingForRPCResult Then Exit Sub
  
  CustomerID = Split(lstCustomers.Text, " - ")(0)
  Set RsOrders = RPCWrapper.GetRsSQLite(SQLiteDBName, _
      "Select * from Orders Where CustomerID='" & CustomerID & "' Order By OrderDate")
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub

  With RsOrders
    lstOrders.Clear
    IDIdx = .Fields("OrderID").IndexInFieldList
    DateIdx = .Fields("OrderDate").IndexInFieldList
    For i = 0 To .RecordCount - 1
      lstOrders.AddItem .ValueMatrix(i, DateIdx)
      lstOrders.ItemData(lstOrders.NewIndex) = .ValueMatrix(i, IDIdx)
    Next i
    If lstOrders.ListCount Then lstOrders.ListIndex = 0 Else lstOrderDetails.Clear
  End With
End Sub

Private Sub lstOrders_Click()
Dim OrderID As String
Dim i As Long, QuantIdx As Long, NameIdx As Long
  If RPCWrapper.RPCCnn.WaitingForRPCResult Then Exit Sub

  OrderID = lstOrders.ItemData(lstOrders.ListIndex)
  Set RsOrderDetails = RPCWrapper.GetRsSQLite(SQLiteDBName, _
      "Select * from [Order Details Extended] Where OrderID=" & OrderID & " Order By ProductName")
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub

  With RsOrderDetails
    lstOrderDetails.Clear
    QuantIdx = .Fields("Quantity").IndexInFieldList
    NameIdx = .Fields("ProductName").IndexInFieldList
    For i = 0 To .RecordCount - 1
      lstOrderDetails.AddItem .ValueMatrix(i, QuantIdx) & " x " & .ValueMatrix(i, NameIdx)
    Next i
    If lstOrderDetails.ListCount Then lstOrderDetails.ListIndex = 0
  End With
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Set RsCustomers = Nothing
  Set RsOrders = Nothing
  Set RsOrderDetails = Nothing
  Set RPCWrapper = Nothing
End Sub
