VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cUDPWatcher"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'the only "consumer" of this class is fChatClient - and the Events below are received there
Event RefreshWhosOnlineListing()
Event RefreshGroupsListing()
Event RefreshMessageListing(ByVal NewData As Boolean)

Private WithEvents UDP As cUDP, WithEvents tPoll As cTimer
Attribute UDP.VB_VarHelpID = -1
Attribute tPoll.VB_VarHelpID = -1

Private Sub Class_Initialize()
  Set UDP = New_c.UDP
  UDP.Bind "", gPort 'bind, to listen on "any IP" and on our global Port-Constant
  
  Set tPoll = New_c.Timer(2000, True)
End Sub

'lets watch for the "New-Message-arrived-on-Server" - Broadcast
Private Sub UDP_NewDatagram(ByVal BytesTotal As Long, ByVal FirstBufferAfterOverflow As Boolean)
Dim B() As Byte, SLen As Long, S As String
  ReDim B(BytesTotal - 1)
  UDP.GetData VarPtr(B(0)), BytesTotal 'let's read in either case, to free the queue

  If BytesTotal <= 4 Then 'the only 4-Byte long ServerIP-Broadcast is ignored here (only used in fLogin)
    'so do nothing for the moment
    '...
  Else 'instead we assume and copy over the String-Message from the Datagram
    SLen = B(0) + 256& * B(1) 'the string-len of this small messages fits in the first two bytes
    If SLen = BytesTotal - 6 Then 'seems we have a valid string-datagram
      S = MidB$(B, 5, SLen)
      Select Case LCase$(S)
        Case LCase$("Event_NewMessageAvailable")
          GetNewMessages 'update the MessageListing
      End Select
    End If
  End If
End Sub

'and here we tell the server with a 2sec-Interval, that we are "yet online"
'(but we also check the online-status of "all other users" - all in the same roundtrip)
'additionally we use this low-frequent poll also as a secure fallback in case the
'UDP-triggered ServerMessage is never received in the above routine, so we ensure at least
'a slower refresh-rate of the MsgListing (though not that "snappy" as with a working "UDP-trigger")
Public Sub tPoll_Timer()
Static CC As Long
  On Error Resume Next
  gLastMsgID = GetLastMsgID_FromCurrentLocalGroup 'get the Max-MsgID from our current InMemory-GroupTable (no roundtrip here)
  
  'now we get the Recordset with the "Online-Users" from our server (also telling, we are yet there)...
  Set gWhosOnline = gCC.WhosOnline(gLastMsgID, gCurrentTopicGroup)
  'after the above call returned, we got also a signalization over the ByRef-Param gLastMsgID
  'if this Param returns with the same value, but negative - then we have no newer MessageID
  'available at the serverside (and on this GroupTable)

  If gLastMsgID >= 0 Then GetNewMessages 'only do this additional Msg-roundtrip, if there are any newer ones
  
  'Ok, back to the also returned gWhosOnline-Recordset...
  'let's perform the sort of the Rs at the clientside (to move a bit of the load from the server-side here)
  gWhosOnline.Sort = "LastActivity Desc"
  
  RaiseEvent RefreshWhosOnlineListing

  If CC = 0 Then CheckForNewGroups 'finally also a check/refresh for eventually new created groups is triggered here...
  CC = (CC + 1) Mod 5 '...but we ensure, to perform that not as often as with the WhosOnline-Roundtrip/ListRefresh
End Sub

Public Sub CheckForNewGroups()
  'since our topic-groups are normal DB-Tables, we perform just a generic Rs-Select against sqlites mastertable at the serverside
  Set gGroupList = gCC.GetRs("Select Name From sqlite_master Where Type = 'table' and Name<>'Users' And Not Name Like 'sqlite_%'")
  Do Until gGroupList.EOF
    EnsureLocalGroupTableDef gGroupList!Name.Value
    gGroupList.MoveNext
  Loop
  RaiseEvent RefreshGroupsListing
End Sub


Public Sub GetNewMessages()
Dim Rs As cRecordset

  'first the server-roundtrip, which gets only newer Message-Records than gLastMsgID
  Set Rs = gCC.GetNewMessages(gCurrentTopicGroup, gLastMsgID, gMessageDepth)
  If Rs Is Nothing Then RaiseEvent RefreshMessageListing(False): Exit Sub
  If Rs.RecordCount = 0 Then RaiseEvent RefreshMessageListing(False): Exit Sub
  
  'now the "copy-over" of what we got (into the local InMemory-Table of the current group)
  gCnnM.CreateTableFromRsContent Rs.Content, "Tmp", True 'just an intermediate step (tmp will be overwritten on the next run)
  gCnnM.Execute "Insert Or Replace Into [" & gCurrentTopicGroup & "] Select * From Tmp" 'and here we merge into the real InMemory-GroupTable

  'finally we retrieve the new Message-Listing from our InMemory-GroupTable in the right Order and with the correct Limit
  Set gCurrentMessages = gCnnM.OpenRecordset("Select * From [" & gCurrentTopicGroup & _
                                            "] Order By ID Desc Limit " & gMessageDepth)
  
  RaiseEvent RefreshMessageListing(True) 'signalize the GUI, that we have something new
End Sub

Private Function GetLastMsgID_FromCurrentLocalGroup() As Variant
  GetLastMsgID_FromCurrentLocalGroup = CDec(0) 'preinitialize with a DecimalType with value 0
  On Error Resume Next
    GetLastMsgID_FromCurrentLocalGroup = gCnnM.OpenRecordset("Select Max(ID) From [" & gCurrentTopicGroup & "]").Fields(0).Value
  If Err Then Err.Clear
End Function

Private Sub EnsureLocalGroupTableDef(TopicGroupName As String)
  gCnnM.Execute "Create Table If Not Exists [" & TopicGroupName & "]" & _
               "(ID Integer Primary Key, Name Text, Message Text, PostingDate DateTime)"
End Sub


