VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cChatClient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'this Class (cChatClient) is the clientside RPC-Wrapper for the serverside
'methods of cChatServer. The class cChatServer is hosted in a separate
'AX-Dll-Project (ChatServer.vbp inside the SubFolder \ServerLib)
'If you start the Debug-Group project (_DebugChatApp.vbg), then you
'cand debug and step through the complete roundtrip (client-project and serverDll-project)
Option Explicit

Private Const Dll$ = "ChatServer.dll", Class$ = "cChatServer" 'for regfree serverside instantiation

Private RPCcnn As cRPCConnection, TC 'the clientside RPC-Connection and the ThreadCollection-Key-PlaceHolder

Private Sub Class_Initialize()
  TC = "dh_ThreadCollection" 'the AppServer replaces this KeyWord into a VB-Collection (inside the serverside Worker-Thread)
    
  Set RPCcnn = New_c.RPCConnection 'instantiate and initialize the RPC-ConnectionObject
  RPCcnn.DebugMode = RunningInIde 'if that is true, a server is simulated inside the
  RPCcnn.KeepAlive = True
  RPCcnn.Port = gPort
  RPCcnn.Compression = 1
End Sub

Public Property Get ServerIP() As String
  ServerIP = RPCcnn.Host
End Property
Public Property Let ServerIP(ByVal NewValue As String) 'Setting a new ServerIP ensures our connect
  If Not RPCcnn.IsConnected Or (RPCcnn.IsConnected And RPCcnn.Host <> NewValue) Then
    RPCcnn.Disconnect
    RPCcnn.Host = NewValue
    RPCcnn.Connect
  End If
End Property

Public Property Get ServerBroadCastIP() As String
Dim IPParts() As String
  If InStr(ServerIP, ".") = 0 Then Exit Property 'just to make sure...
  
  IPParts = Split(ServerIP, ".")
  IPParts(3) = 255
  ServerBroadCastIP = Join(IPParts, ".")
End Property

Public Property Get IsConnected() As Boolean
  IsConnected = RPCcnn.IsConnected
End Property

'************ here we start with the "RPC-Wrapping" of the serverside methods *************
'------------------------------------------------------------------------------------------
Public Function CreateNewUser(ByVal UserName As String, ByVal PassWord As String) As Boolean
Const ProcN$ = "CreateNewUser", TOutSec# = 5 '<-don't forget to adapt these consts appropriately
Dim Rs As cRecordset, Pass() As Byte, PassWordSHA1 As String
  If Not (RPCcnn.IsConnected Or RPCcnn.DebugMode) Or Len(UserName) = 0 Or Len(PassWord) = 0 Then Exit Function
  
  Pass = PassWord 'cast to a byte-array
  PassWordSHA1 = gCrypt.SHA1(Pass, True)
  CreateNewUser = RPCcnn.RPC(Dll, Class, ProcN, TOutSec, TC, UserName, PassWordSHA1)
End Function

Public Function Login(ByVal UserName As String, ByVal PassWord As String)
Const ProcN$ = "Login", TOutSec# = 5 '<-don't forget to adapt these consts appropriately
Dim Rs As cRecordset, Pass() As Byte, PassWordSHA1 As String
  If Not (RPCcnn.IsConnected Or RPCcnn.DebugMode) Or Len(UserName) = 0 Then Exit Function
  
  Pass = PassWord 'cast to a byte-array
  PassWordSHA1 = gCrypt.SHA1(Pass, True)
  Login = RPCcnn.RPC(Dll, Class, ProcN, TOutSec, TC, UserName, PassWordSHA1)
End Function

Public Function WhosOnline(Optional LastMsgID, Optional ByVal TopicGroup As String) As cRecordset
Const ProcN$ = "WhosOnline", TOutSec# = 5 '<-don't forget to adapt these consts appropriately
  If Not (RPCcnn.IsConnected Or RPCcnn.DebugMode) Or gUserID = 0 Then Exit Function
  
  On Error Resume Next
    Set WhosOnline = RPCcnn.RPC(Dll, Class, ProcN, TOutSec, TC, gUserID, LastMsgID, TopicGroup)
  If Err Then Err.Clear 'this error is not critical, hence we suppress it
End Function

Public Function GetRs(ByVal SQL As String) As cRecordset
Const ProcN$ = "GetRs", TOutSec# = 10 '<-don't forget to adapt these consts appropriately
  If Not (RPCcnn.IsConnected Or RPCcnn.DebugMode) Or gUserID = 0 Then Exit Function

  Set GetRs = RPCcnn.RPC(Dll, Class, ProcN, TOutSec, TC, gUserID, SQL)
End Function

Public Function GetNewMessages(ByVal TopicGroup As String, ByVal LastMsgID, ByVal MsgLimit As Long) As cRecordset
Const ProcN$ = "GetNewMessages", TOutSec# = 10 '<-don't forget to adapt these consts appropriately
  If Not (RPCcnn.IsConnected Or RPCcnn.DebugMode) Or gUserID = 0 Then Exit Function
  
  If Len(TopicGroup) = 0 Then Exit Function

  Set GetNewMessages = RPCcnn.RPC(Dll, Class, ProcN, TOutSec, TC, gUserID, TopicGroup, Abs(LastMsgID), MsgLimit)
End Function

Public Function SendMessage(ByVal TopicGroup As String, Message As String, Optional ByVal BroadCastIP As String, Optional ByVal BroadCastPort As Long) As Boolean
Const ProcN$ = "SendMessage", TOutSec# = 5 '<-don't forget to adapt these consts appropriately
  If Not (RPCcnn.IsConnected Or RPCcnn.DebugMode) Or gUserID = 0 Then Exit Function
  
  If Len(TopicGroup) = 0 Or Len(Message) = 0 Then Exit Function
  
  SendMessage = RPCcnn.RPC(Dll, Class, ProcN, TOutSec, TC, gUserID, TopicGroup, Message, BroadCastIP, BroadCastPort)
End Function

Public Function CreateNewTopicGroup(ByVal NewTopicGroupName As String) As Boolean
Const ProcN$ = "CreateNewTopicGroup", TOutSec# = 5 '<-don't forget to adapt these consts appropriately
  If Not (RPCcnn.IsConnected Or RPCcnn.DebugMode) Or gUserID = 0 Then Exit Function
  
  If Len(NewTopicGroupName) = 0 Then Exit Function

  CreateNewTopicGroup = RPCcnn.RPC(Dll, Class, ProcN, TOutSec, TC, gUserID, NewTopicGroupName)
End Function

