VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cChatServer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'these values are initialized once over InitFrom(...) - This init-check is
'performed on top of each of the Public Functions the client can reach over RPC
Private New_c As cConstructor, Cnn As cConnection, UDP As cUDP


Public Function CreateNewUser(ByVal ThreadCollection As Collection, ByVal UserName As String, ByVal PassWordSHA1 As String) As Boolean
If New_c Is Nothing Then InitFrom ThreadCollection

Dim Rs As cRecordset
  If Len(UserName) = 0 Or Len(PassWordSHA1) = 0 Then Exit Function
    
  Set Rs = Cnn.OpenRecordset("Select * From Users Where Name = '" & UserName & "'") 'check only the UserName
  If Rs.RecordCount Then Exit Function 'Username already exists, so we return with false
  
  Rs.AddNew
    Rs!ID.Value = Rs.UniqueID64 'this creates a Int64-timestamp (with a large random "trail") - so that already reflects our "registered date"
    Rs!Name.Value = UserName
    Rs!PassWordSHA1.Value = PassWordSHA1
  Rs.UpdateBatch
  CreateNewUser = True
End Function

'passes back the UserID as an Int64, sitting in a CDec(Variant) - a returned Empty or Zero
'would mean "no-login" - a returned UserID with a -Sign would indicate "logged in, but not fully elevated"
Public Function Login(ByVal ThreadCollection As Collection, ByVal UserName As String, ByVal PassWordSHA1 As String) As Variant
If New_c Is Nothing Then InitFrom ThreadCollection

Dim D As Date, Rs As cRecordset
  If Len(UserName) = 0 Then Exit Function
  
  If Len(PassWordSHA1) = 0 Then 'a Login without password is allowed, but the User is not "elevated" to member-status
    Set Rs = Cnn.OpenRecordset("Select * From Users Where Name = '" & UserName & "'") 'check only the UserName
    If Rs.RecordCount Then Rs!FullyAuthenticated.Value = False
  Else 'Full Login-attempt with a password - if successfull, then "full Member-Status" is granted
    Set Rs = Cnn.OpenRecordset("Select * From Users Where Name = '" & UserName & "' And PassWordSHA1 ='" & PassWordSHA1 & "'")
    If Rs.RecordCount Then Rs!FullyAuthenticated.Value = True
  End If
  
  If Rs.RecordCount Then 'user exists
    D = Now
    Login = Rs!ID.Value
    If Not Rs!FullyAuthenticated.Value Then Login = -Login 'non-elevated Logins get a negative UserID passed back

    Rs!CurrentlyOnline.Value = True
    Rs!LastLogin.Value = D
    Rs!LastOnlinePing.Value = D
    Rs!LastActivity.Value = D
    Rs.UpdateBatch
  End If
End Function

Public Function WhosOnline(ByVal ThreadCollection As Collection, ByVal UserID, _
                           Optional LastMsgID, Optional ByVal TopicGroup As String) As cRecordset
If New_c Is Nothing Then InitFrom ThreadCollection

Dim Rs As cRecordset, D As Date, IsRegisteredUser As Boolean
  If UserID = 0 Then Exit Function 'don't event try
  
  UserID = Abs(UserID) 'first switch-off the negative-Value (signalizing, the logged in user was not elevated)
  Set Rs = Cnn.OpenRecordset("Select * From Users Where CurrentlyOnline OR ID=" & UserID)

  D = Now
  Do Until Rs.EOF
    If Rs!ID = UserID Then
      IsRegisteredUser = True
      Rs!CurrentlyOnline = True
      Rs!LastOnlinePing = D
    End If
    If DateDiff("s", Rs!LastActivity, D) > 5 And DateDiff("s", Rs!LastOnlinePing, D) > 5 Then
      Rs!CurrentlyOnline = False 'a ping-timeout of > 5 sec leads to Offline-Status
    End If
    Rs.MoveNext
  Loop
  
  If Not IsRegisteredUser Then Exit Function 'don't return anything, if the UserID was not found in our Set
  
  Rs.UpdateBatch 'update the possibly changed online-status of other users (who don't have pinged anymore)
  
  'now fill in the return-value with a somewhat reduced Column-Set (only what you need at the clientside)
  Set WhosOnline = Cnn.OpenRecordset("Select Name, FullyAuthenticated, LastLogin, " & _
                                            "LastActivity From Users Where CurrentlyOnline")
                                            
  '------------------------------------------------------------------------------------------------
  'finally we perform also a check for new messages inside this "Ping-Roundtrip" (since we're already here)
  ' thought as a secure fallback, in case the UDP-broadcasting "NewMsg is here" fails - new Msgs would then
  ' at least pop up on other clients with the slower 3sec-Ping-Interval we use at the clientside for this Online-Check
  If IsMissing(LastMsgID) Then LastMsgID = 0
  If LastMsgID = 0 Or Len(TopicGroup) = 0 Then Exit Function 'do nothing in case of Nulls
  
  Set Rs = Cnn.OpenRecordset("Select Top 1 ID From [" & TopicGroup & "] Where ID >" & LastMsgID)
  'in case we have newer Msgs, we just reflect that with a -Sign on the same ByRef-Param we used
  'here for the just performed "greater than" comparison
  If Rs.RecordCount = 0 Then LastMsgID = -LastMsgID 'reflect to the clientside: "no, we have no newer Msgs here"
End Function

Public Function GetRs(ByVal ThreadCollection As Collection, ByVal UserID, ByVal SQL As String) As cRecordset
If New_c Is Nothing Then InitFrom ThreadCollection
  
  Dim Rs As cRecordset, IsRegisteredUser As Boolean, IsAuthenticatedMember As Boolean
  If UserID = 0 Then Exit Function 'don't event try in case of non-logged-in-users
  
  UserID = Abs(UserID) 'first switch-off the negative-Value (in case the logged in user was not elevated)

  'check, if we have a registered User here
  Set Rs = Cnn.OpenRecordset("Select FullyAuthenticated From Users Where ID =" & UserID)
  IsRegisteredUser = Rs.RecordCount
  
  If Not IsRegisteredUser Then Exit Function 'don't return anything, if user is not registered (has a wrong ID)
  
  If Rs!FullyAuthenticated.Value Then IsAuthenticatedMember = True
  'This boolean value above is currently not used here (only set, to show you that we
  'could make decisions at the serverside, depending on "fully logged in and elevated" state
  'of members who gave not only a username at their client-login, but also a valid password)
  
  Set GetRs = Cnn.OpenRecordset(SQL) 'and finally we allow the select, delivering the Rs back to the clientside
End Function

Public Function GetNewMessages(ByVal ThreadCollection As Collection, ByVal UserID, ByVal TopicGroup As String, ByVal LastMsgID, ByVal MsgLimit As Long) As cRecordset
If New_c Is Nothing Then InitFrom ThreadCollection
  
  Dim Rs As cRecordset, IsRegisteredUser As Boolean, IsAuthenticatedMember As Boolean
  If UserID = 0 Then Exit Function 'don't event try in case of non-logged-in-users
  
  UserID = Abs(UserID) 'first switch-off the negative-Value (in case the logged in user was not elevated)

  'check, if we have a registered User here
  Set Rs = Cnn.OpenRecordset("Select FullyAuthenticated From Users Where ID =" & UserID)
  IsRegisteredUser = Rs.RecordCount
  
  If Not IsRegisteredUser Then Exit Function 'don't return anything, if user is not registered (has a wrong ID)
  
  With Cnn.CreateSelectCommand("Select M.ID, Name, Message, Postingdate From @Group M " & _
                              " Inner Join Users On Users.ID = Users_ID " & _
                              " Where M.ID > @LastID Order By M.ID Desc Limit @MsgLimit")
    .ReplColumnOrTableName !Group, TopicGroup
    .SetInt64 !LastID, Abs(LastMsgID)
    .SetInt32 !MsgLimit, MsgLimit
    Set GetNewMessages = .Execute
  End With
End Function


Public Function SendMessage(ByVal ThreadCollection As Collection, ByVal UserID, ByVal TopicGroup As String, Message As String, _
                            Optional ByVal BroadCastIP As String, Optional ByVal BroadCastPort As Long) As Boolean
If New_c Is Nothing Then InitFrom ThreadCollection
  
  Dim Rs As cRecordset, IsRegisteredUser As Boolean, IsAuthenticatedMember As Boolean
  If UserID = 0 Then Exit Function 'don't event try in case of non-logged-in-users
    
  UserID = Abs(UserID) 'first switch-off the negative-Value (in case the logged in user was not elevated)

  'check, if we have a registered User here
  Set Rs = Cnn.OpenRecordset("Select ID, FullyAuthenticated, LastActivity From Users Where ID =" & UserID)
  IsRegisteredUser = Rs.RecordCount
  
  If Not IsRegisteredUser Then Exit Function 'don't do anything, if user is not registered (has a wrong ID)
  
  If Rs!FullyAuthenticated.Value Then IsAuthenticatedMember = True
  
  'currently we allow both kind of registered Users to send Messages, but one could
  'restrict Msg-Sending for example to fully authenticated Members only over:
  'If Not IsAuthenticatedMember Then Exit Function
  
  'Ok, first the Update in our Users-Table-Record we currently have in the Rs
  Rs!LastActivity.Value = Now
  Rs.UpdateBatch
  
  'Now the insert of the new message into our TopicGroup-Table
  On Error GoTo RollBack
  Cnn.BeginTrans
    With Cnn.CreateCommand("Insert Into [" & TopicGroup & "](Users_ID, PostingDate, Message) Values(?,?,?)")
      .SetInt64 1, UserID
      .SetDate 2, Now
      .SetText 3, Message
      .Execute
    End With
  Cnn.CommitTrans
    
  BroadCast_NewMessageAvailable_Event BroadCastIP, BroadCastPort

  SendMessage = True
Exit Function

RollBack:
  Cnn.RollbackTrans 'in case of an Insert-failure
End Function


Public Function CreateNewTopicGroup(ByVal ThreadCollection As Collection, ByVal UserID, ByVal NewTopicGroupName As String) As Boolean
If New_c Is Nothing Then InitFrom ThreadCollection
  
  Dim Rs As cRecordset, IsRegisteredUser As Boolean, IsAuthenticatedMember As Boolean
  If UserID = 0 Then Exit Function 'don't event try in case of non-logged-in-users
  If Len(NewTopicGroupName) = 0 Then Exit Function
  
  UserID = Abs(UserID) 'first switch-off the negative-Value (in case the logged in user was not elevated)
  
  'check, if we have a registered User here
  Set Rs = Cnn.OpenRecordset("Select FullyAuthenticated From Users Where ID =" & UserID)
  IsRegisteredUser = Rs.RecordCount
  
  If Not IsRegisteredUser Then Exit Function 'don't return anything, if user is not registered (has a wrong ID)
  
  If Rs!FullyAuthenticated.Value Then IsAuthenticatedMember = True
  If Not IsAuthenticatedMember Then Exit Function 'this is the only function, which decides something on the (not) elevated member-state
  
  CreateNewTopicGroup = CreateNewTopicGroupTable(NewTopicGroupName)
End Function
'******************** End of the Public RPC-Interface-implementation **********************



'******************** Private Helper-Routines *********************
Private Sub InitFrom(ByVal ThreadCollection As Collection)
Dim Factory As cFactory
  Set Factory = ThreadCollection("dh_Factory")
  Set New_c = Factory.C 'create a cConstructor-Object in New_c
  
  Set UDP = New_c.UDP 'create an UDP-SocketObject
  Set Cnn = New_c.Connection 'create a DB-ConnectionObject
  
  On Error Resume Next
    Cnn.OpenDB App.Path & "\Chat.db"
  If Err Then 'DB does not yet exist
    Err.Clear
    Cnn.CreateNewDB App.Path & "\Chat.db" 'so let's create a new one
  End If
  
  'now we try to ensure the DB-Schema (the Table-Defs for the Users and the first TopicGroup/ChatRoom)
  CreateUsersTable
  CreateNewTopicGroupTable "General Discussion"

  If Err Then Set New_c = Nothing
End Sub

Private Sub CreateUsersTable()
  Cnn.Execute "Create Table If Not Exists Users(ID Integer Primary Key, " & _
                                                "Name Text Collate NoCase, " & _
                                                "PassWordSHA1 Text Collate NoCase, " & _
                                                "CurrentlyOnline Boolean, " & _
                                                "FullyAuthenticated Boolean, " & _
                                                "LastLogin DateTime, " & _
                                                "LastActivity DateTime, " & _
                                                "LastOnlinePing DateTime)"
  Cnn.Execute "Create Index If Not Exists idx_Name_PassWordSHA1 On Users(Name, PassWordSHA1)"
  Cnn.Execute "Create Index If Not Exists idx_CurrentlyOnline On Users(CurrentlyOnline)"
End Sub

Private Function CreateNewTopicGroupTable(TopicGroupName As String) As Boolean
  On Error Resume Next
  Cnn.Execute "Create Table [" & TopicGroupName & "](ID Integer Primary Key AutoIncrement, " & _
                                                "Users_ID Integer, " & _
                                                "Subject Text, " & _
                                                "PostingDate DateTime, " & _
                                                "ParentID Integer, " & _
                                                "Message Text, " & _
                                                "Attachment Blob)"
  
  Cnn.Execute "Create Index If Not Exists idx_Users_ID On [" & TopicGroupName & "](Users_ID)"
  Cnn.Execute "Create Index If Not Exists idx_ParentID On [" & TopicGroupName & "](ParentID)"
  Cnn.Execute "Create Index If Not Exists idx_PostingDate On [" & TopicGroupName & "](PostingDate)"
  
  If Err Then Err.Clear Else CreateNewTopicGroupTable = True
End Function

Private Sub BroadCast_NewMessageAvailable_Event(BroadCastIP As String, ByVal BroadCastPort As Long)
Dim strEvent As String
  If UDP Is Nothing Or Len(BroadCastIP) = 0 Or BroadCastPort = 0 Then Exit Sub

  If UDP.RemoteIP <> BroadCastIP Then UDP.RemoteIP = BroadCastIP
  If UDP.RemotePort <> BroadCastPort Then UDP.RemotePort = BroadCastPort
  
  strEvent = "Event_NewMessageAvailable"
  UDP.SendData StrPtr(strEvent) - 4, (4 + LenB(strEvent) + 2) 'LenInfo + StringContentLen + Null-WChar
End Sub
