VERSION 5.00
Begin VB.Form fDemo 
   BorderStyle     =   4  'Festes Werkzeugfenster
   Caption         =   "  dhSimpleXML-Demo"
   ClientHeight    =   9600
   ClientLeft      =   45
   ClientTop       =   270
   ClientWidth     =   12465
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   640
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   831
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CheckBox chkUseNotepad 
      Caption         =   "use Notepad instead"
      Height          =   240
      Left            =   10440
      TabIndex        =   18
      Top             =   3660
      Width           =   1860
   End
   Begin VB.CommandButton cmdStartNotePad 
      Caption         =   "Start Notepad.exe with the original File"
      Height          =   315
      Left            =   6300
      TabIndex        =   2
      Top             =   150
      Width           =   2985
   End
   Begin VB.CommandButton cmdRefreshList 
      Caption         =   "Refresh List --->"
      Height          =   315
      Left            =   135
      TabIndex        =   4
      Top             =   150
      Width           =   1500
   End
   Begin VB.Frame frTile 
      Height          =   30
      Index           =   2
      Left            =   180
      TabIndex        =   17
      Top             =   8940
      Width           =   12120
   End
   Begin VB.Frame frTile 
      Height          =   30
      Index           =   1
      Left            =   180
      TabIndex        =   16
      Top             =   3480
      Width           =   12120
   End
   Begin VB.Frame frTile 
      Height          =   30
      Index           =   0
      Left            =   180
      TabIndex        =   11
      Top             =   630
      Width           =   12120
   End
   Begin VB.CommandButton cmdMSDOMText 
      Caption         =   "MSDOM: Get Text-Content of the Root-Element"
      Height          =   315
      Left            =   6300
      TabIndex        =   7
      Top             =   3960
      Width           =   3795
   End
   Begin VB.PictureBox picMSDOMText 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   10110
      ScaleHeight     =   16
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   142
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   3960
      Width           =   2190
   End
   Begin VB.PictureBox picSimpleDOMText 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      Height          =   300
      Left            =   3945
      ScaleHeight     =   16
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   142
      TabIndex        =   13
      TabStop         =   0   'False
      Top             =   3960
      Width           =   2190
   End
   Begin VB.CheckBox chkPreserveWhiteSpace 
      Caption         =   "Preserve WhiteSpace"
      Height          =   285
      Left            =   10350
      TabIndex        =   3
      Top             =   180
      Value           =   1  'Aktiviert
      Width           =   1950
   End
   Begin VB.CommandButton cmdReload 
      Caption         =   "Reload current File"
      Default         =   -1  'True
      Height          =   315
      Left            =   4275
      TabIndex        =   1
      Top             =   150
      Width           =   1860
   End
   Begin VB.PictureBox picEnumerationOutput 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      Height          =   2175
      Left            =   6300
      ScaleHeight     =   141
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   396
      TabIndex        =   12
      TabStop         =   0   'False
      Top             =   1125
      Width           =   6000
   End
   Begin VB.ComboBox cmbXMLFiles 
      BackColor       =   &H00FFFFFF&
      Height          =   315
      ItemData        =   "fDemo.frx":0000
      Left            =   1710
      List            =   "fDemo.frx":0002
      Style           =   2  'Dropdown-Liste
      TabIndex        =   0
      Top             =   150
      Width           =   2490
   End
   Begin VB.TextBox txtMSDOMText 
      BackColor       =   &H00FFFFFF&
      Height          =   4470
      Left            =   6300
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Beides
      TabIndex        =   9
      Text            =   "fDemo.frx":0004
      Top             =   4275
      Width           =   6000
   End
   Begin VB.TextBox txtSimpleDOMText 
      BackColor       =   &H00FFFFFF&
      Height          =   4470
      Left            =   135
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Beides
      TabIndex        =   8
      Text            =   "fDemo.frx":000A
      Top             =   4275
      Width           =   6000
   End
   Begin VB.CommandButton cmdEnumeration 
      Caption         =   "'Flat'-Enumeration-Performance on all Elements in the Tree for both DOMs"
      Height          =   315
      Left            =   6300
      TabIndex        =   5
      Top             =   810
      Width           =   6000
   End
   Begin VB.CommandButton cmdTriggerSaxParsing 
      Caption         =   $"fDemo.frx":0010
      Height          =   315
      Left            =   135
      TabIndex        =   10
      Top             =   9135
      Width           =   12165
   End
   Begin VB.CommandButton cmdSimpleDOMText 
      Caption         =   "SimpleDOM: Get Text-Content of the Root-Element"
      Height          =   315
      Left            =   135
      TabIndex        =   6
      Top             =   3960
      Width           =   3795
   End
   Begin VB.Label lblTextComment 
      AutoSize        =   -1  'True
      Caption         =   $"fDemo.frx":00B4
      Height          =   195
      Left            =   135
      TabIndex        =   15
      Top             =   3675
      Width           =   10155
   End
End
Attribute VB_Name = "fDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'************ dhSimpleXML-Demo by Olaf Schmidt (2006) ************
'Please post misbehaviour or suggestions to os@datenhaus.de

Option Explicit

Implements cSimpleSax 'needed, to make this VB-Form a CallBack-Receiver of the Sax-Parser

'simple Counting-Vars, used inside the SaxParser-Callback-Routines
Private ParsingStartsCalls As Long
Private ElementOpenedCalls As Long
Private AttributeOpenedCalls As Long
Private AttributeContentCalls As Long
Private ElementContentCalls As Long
Private ElementClosedCalls As Long

Private Path As String
Private SimpleDOM As cSimpleDOM, MSDOM As MSXML2.DOMDocument30 '<- adjust this to the MS-Version you have

Private Sub Form_Load()
  AutoRedraw = True
  
  Set SimpleDOM = New_c.SimpleDOM
  
  Path = App.Path & "\XMLFiles\"

  cmdRefreshList_Click
End Sub

Private Sub cmdRefreshList_Click()
Dim FName As String
  cmbXMLFiles.Clear
  FName = Dir(Path & "*.xml")
  Do While Len(FName)
    cmbXMLFiles.AddItem FName
    FName = Dir()
  Loop
  If cmbXMLFiles.ListCount Then cmbXMLFiles.ListIndex = 0
End Sub

Private Sub cmdStartNotePad_Click()
  Shell "notepad """ & Path & cmbXMLFiles.Text & """", vbNormalFocus
End Sub

Private Sub cmbXMLFiles_Click()
Dim T As Double, FName As String
  On Error Resume Next
  FName = Path & cmbXMLFiles.Text
  
  'cleanup our previous Screen-Ouput
  txtSimpleDOMText.Text = "": txtMSDOMText.Text = ""
  picSimpleDOMText.Cls: picMSDOMText.Cls
  picEnumerationOutput.Cls
  Me.Cls: CurrentY = 53
  
  'here we go with the SimpleDOM
  Set SimpleDOM = New_c.SimpleDOM
  SimpleDOM.preserveWhiteSpace = (chkPreserveWhiteSpace.Value = 1)
  DoEvents
  T = HPTimer
    SimpleDOM.OpenFromFile FName
  T = HPTimer - T 'timing finished
  If Err Then Print "   "; Err.Description: Err.Clear: Exit Sub
  Print "   New SimpleDOM created after: " & Format(T * 1000, "0.00") & " msec! (document is"; _
            IIf(SimpleDOM.WellFormed, "", " not"); " wellformed)"
  Print "            Total Count of Elements in the Tree: " & SimpleDOM.ElementsTotal
  Print "            Total Count of Attributes in the Tree: " & SimpleDOM.AttributesTotal
  Print "            Level-Depth of the Tree: " & SimpleDOM.LevelDepth
  Print "            XML-Length: " & SimpleDOM.XMLLength
  Print "            Root-XML-String-Length: " & SimpleDOM.root.XMLLength
  Print "            XMLIs16BitUnicode-Property: " & SimpleDOM.XMLIs16BitUnicode
  Print "            XMLEncodingString-Property: '" & SimpleDOM.XMLEncodingString & "'"
  Print "            CurrentCodePage-Property: " & SimpleDOM.CurrentCodePage
  Print "            SuggestedCodePage-Property: " & SimpleDOM.SuggestedCodePage; vbCrLf
  Refresh
  'Now the MSDOM-Test
  'Comment in the following Call and Declare MSDOM as Object if you don't know, what your Version is
  'the LateBinding would have no effect on performance, because we do only one single Call...
  'Set MSDOM =CreateObject("MSXML2.DOMDocument")
  Set MSDOM = New MSXML2.DOMDocument30  '...or simply set the needed project-reference to your current Version
  If MSDOM Is Nothing Then Print "   Couldn't instantiate MS-XMLDOMDocument": Err.Clear: Exit Sub
  MSDOM.async = False
  MSDOM.validateOnParse = False 'no validation, since our SimpleDOM is non-validating
  MSDOM.preserveWhiteSpace = (chkPreserveWhiteSpace.Value = 1)
  Err.Clear
  T = HPTimer
    MSDOM.Load FName
  T = HPTimer - T 'timing finished
  If Err Then Print "   MSDOM: " & Err.Description: Err.Clear: Exit Sub
  If MSDOM.parseError Then Print "   MSDOM-Parsing-Error: " & MSDOM.parseError.reason: Exit Sub
  Print "   New MSDOM created after: " & Format(T * 1000, "0.00") & " msec!"
  Print "            Total Count of Elements in the Tree: " & MSDOM.getElementsByTagName("*").length
End Sub

Private Sub EnumerateElements(Elmt As cElement)
  If Elmt Is Nothing Then Exit Sub
  Debug.Print Space(Elmt.Level * 2); Elmt.Level & ": " & Elmt.tagName
  If Not Elmt.HasChildElements Then Exit Sub
  Dim Child As cElement
  For Each Child In Elmt.ChildElements
    EnumerateElements Child
  Next Child
End Sub

Private Sub cmdEnumeration_Click()
Dim T As Double
Dim Elmt As cElement, Attr As cAttribute
Dim MSElmt As IXMLDOMElement, MSAttr As IXMLDOMAttribute '<- Early-Binding for the MS-Vars (for fair comparison)
Dim ElementCount As Long, ElementName As String, ElementText As String
Dim AttributeCount As Long, AttributeName As String, AttributeText As String
  
  picEnumerationOutput.Cls 'clear previous Output
  
  'SimpleDOM-Loop...
  ElementCount = 0: AttributeCount = 0
  picEnumerationOutput.Print vbCrLf; " SimpleDOM Enumeration starts...": picEnumerationOutput.Refresh
  SimpleDOM.preserveWhiteSpace = (chkPreserveWhiteSpace.Value = 1)
  T = HPTimer
    For Each Elmt In SimpleDOM.elements
      ElementText = Elmt.Text
      ElementName = Elmt.tagName
      ElementCount = ElementCount + 1
      For Each Attr In Elmt.Attributes
        AttributeName = Attr.Name
        AttributeText = Attr.Text
        AttributeCount = AttributeCount + 1
      Next Attr
    Next Elmt
  T = HPTimer - T 'timing finished
  picEnumerationOutput.Print " Enumeration finished after: " & Format(T * 1000, "0.00"); " msec!"
  picEnumerationOutput.Print " (Elementcount: "; ElementCount & ", AttributeCount: " & AttributeCount; ")"; vbCrLf
  
  '...and here the appropriate MSDOM-Loop
  ElementCount = 0: AttributeCount = 0
  picEnumerationOutput.Print vbCrLf; " MSDOM Enumeration starts...": picEnumerationOutput.Refresh
  If MSDOM.parseError Then picEnumerationOutput.Print " No Content, because of a Parsing-Error": Exit Sub
  MSDOM.preserveWhiteSpace = (chkPreserveWhiteSpace.Value = 1)
  T = HPTimer
    For Each MSElmt In MSDOM.getElementsByTagName("*")
      ElementText = MSElmt.Text
      ElementName = MSElmt.tagName
      ElementCount = ElementCount + 1
      For Each MSAttr In MSElmt.Attributes
        AttributeName = MSAttr.Name
        AttributeText = MSAttr.Text
        AttributeCount = AttributeCount + 1
      Next MSAttr
    Next MSElmt
  T = HPTimer - T 'timing finished
  picEnumerationOutput.Print " Enumeration finished after: " & Format(T * 1000, "0.00"); " msec!"
  picEnumerationOutput.Print " (Elementcount: "; ElementCount & ", AttributeCount: " & AttributeCount; ")"
End Sub

Private Sub cmdReload_Click()
  cmbXMLFiles_Click
End Sub

Private Sub cmdSimpleDOMText_Click()
Dim Text As String, T As Double
  SimpleDOM.preserveWhiteSpace = (chkPreserveWhiteSpace.Value = 1)
  T = HPTimer
    Text = SimpleDOM.root.Text
  T = HPTimer - T 'timing finished
  'if no vbCrLfs in the original XML, then we try our best to make it readable on MS-Systems
  If InStr(Text, vbCrLf) = 0 Then Text = Replace(Text, vbLf, vbCrLf)
  picSimpleDOMText.Cls: picSimpleDOMText.CurrentY = 1
  picSimpleDOMText.Print Len(Text) & "  WChars (" & Format(T * 1000, "0.00") & " msec)"
  txtSimpleDOMText.Text = Text
  If chkUseNotepad Then ShowTextInNotepad "SimpleDOM.txt", Text
End Sub

Private Sub cmdMSDOMText_Click()
Dim Text As String, T As Double
  MSDOM.preserveWhiteSpace = (chkPreserveWhiteSpace.Value = 1)
  If MSDOM.parseError Then txtMSDOMText.Text = "No Content, because of a Parsing-Error": Exit Sub
  T = HPTimer
    Text = MSDOM.selectSingleNode("/*").Text
  T = HPTimer - T 'timing finished
  'because the MSDOM always replaces the original Whitespace-Linefeeds with vbLF, we make it readable this way
  Text = Replace(Text, vbLf, vbCrLf)
  picMSDOMText.Cls: picMSDOMText.CurrentY = 1
  picMSDOMText.Print Len(Text) & "  WChars (" & Format(T * 1000, "0.00") & " msec)"
  txtMSDOMText.Text = Text
  If chkUseNotepad Then ShowTextInNotepad "MSDOM.txt", Text
End Sub

Private Sub ShowTextInNotepad(FName As String, Text As String)
Dim B() As Byte
  On Error Resume Next
  B = Text '<-- this way we avoid VBs implicite UCS2-to-ANSI-Conversion
  Kill Path & FName: Err.Clear
  Open Path & FName For Binary As 1
  Put 1, , B: Close 1
  Shell "notepad """ & Path & FName & """", vbNormalFocus
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub
End Sub

Private Sub cmdTriggerSaxParsing_Click()
Dim T As Double
  ParsingStartsCalls = 0
  ElementOpenedCalls = 0
  AttributeOpenedCalls = 0
  AttributeContentCalls = 0
  ElementContentCalls = 0
  ElementClosedCalls = 0

  T = HPTimer
    Call SimpleDOM.root.TriggerXMLParsing(Me)
  T = HPTimer - T 'timing finished
  MsgBox "Sax-Parsing finsihed after: " & Format(T * 1000, "0.00") & " msec!" & vbCrLf & vbCrLf & _
         "ElementOpenedCalls: " & ElementOpenedCalls & vbCrLf & _
         "AttributeOpenedCalls: " & AttributeOpenedCalls & vbCrLf & _
         "AttributeContentCalls: " & AttributeContentCalls & vbCrLf & _
         "ElementContentCalls: " & ElementContentCalls & vbCrLf & _
         "ElementClosedCalls: " & ElementClosedCalls
End Sub



'***************************************************************************************
'Start-, Element- and Attribute-Callbacks against our here implemented cSimpleSax-Interface:
'---------------------------------------------------------------------------------------
'These CallBacks are initiated by SimpleDOMs internal Call: SomeElement.TriggerXMLParsing(...) -
'this restarts the DOM-internal SaxParser, looping only over the (Inner-)XML-Content of an Element.
'We use this VB-Form as the Receiver by specifying it as the CallBackObject-Parameter.
'The SaxParser of this Dll can of course also be used standalone (without populating a SimpleDOM).
'To measure only the pure SAX-Performance, we do only a simple Counting here inside the CallBacks
'(The parsing is so fast, that even these simple "Increments-by-One" have a measurable impact
' regarding the Sax-Parsers Timing-Results, if this DemoForm is running as PCode or inside the IDE).

'The reported Level-Param is ZeroBased (0 for the Root-Element in the Document-Tree).
'Also the "Pos-Params" are ZeroBased, so take this into respect, if working with them inside
'Mid()- or MidB-Calls against the XML-ByteArray (or String), previously given into the Parser.
'The ByteArray-Params in the CallBacks come ZeroBased too and are properly sized.
'They contain either "normal" 8Bit-Chars, or 16Bit-WideChars (2 Bytes each Char).
'An 'XMLIs16BitUnicode'-Param is reported in 'ParsingStarts': if 'False', then an appropriate
'Codepage should be used in additional Conversion Calls (StrConv or MultiByteToWideChar-API).
'An SuggestedCodePage-Param is also fired in 'ParsingStarts' (for usage in the two Conversion-Calls).
'The SimpleDOM does these "8Bit-To-16BitUnicode-Conversion" internally (on the fly) whilst
'working with the SaxParser and the SimpleDOM-Tree-Structures.
'In Case 'XMLIs16BitUnicode' is 'True', no special Conversion-Calls are needed, since VBs Strings
'have the same Format already - one can pass the ByteArrays then to VB-Strings or -Params directly
'(no extra String-Allocation, respective -Casting needed), so for example - you can pass them to
'StrComp-Calls directly.
Private Sub cSimpleSax_ParsingStarts(ByVal XMLIs16BitUnicode As Boolean, XMLEncodingAttribute As String, ByVal SuggestedCodePage As Long)
  ParsingStartsCalls = ParsingStartsCalls + 1
End Sub
Private Sub cSimpleSax_ElementOpened(ByVal Level As Long, Name() As Byte, ByVal NamePos As Long, ByVal NameLength As Long, ByVal TagPos As Long)
  ElementOpenedCalls = ElementOpenedCalls + 1
  Dim pName As Long
  pName = VarPtr(Name(0))
  
 ' B = Name
 'Debug.Print VarPtr(Name(0))
  'Debug.Print Name, NamePos
End Sub
Private Sub cSimpleSax_AttributeOpened(ByVal Level As Long, Name() As Byte, ByVal NamePos As Long, ByVal NameLength As Long)
  AttributeOpenedCalls = AttributeOpenedCalls + 1
End Sub
Private Sub cSimpleSax_AttributeContent(ByVal Level As Long, Content() As Byte, ByVal ContentPos As Long, ByVal ContentLength As Long)
  AttributeContentCalls = AttributeContentCalls + 1
End Sub
Private Sub cSimpleSax_ElementContent(ByVal Level As Long, Content() As Byte, ByVal ContentPos As Long, ByVal ContentLength As Long, ByVal IsDataSection As Boolean)
  ElementContentCalls = ElementContentCalls + 1
End Sub
Private Sub cSimpleSax_ElementClosed(ByVal Level As Long, Name() As Byte, ByVal NamePos As Long, ByVal NameLength As Long, ByVal TagLength As Long)
  ElementClosedCalls = ElementClosedCalls + 1
End Sub
'Interface-Stub for ParseXML (only to fullfill the Interface-Implementation)
Private Function cSimpleSax_ParseXML(RawXML() As Byte, CallBackObj As cSimpleSax, Optional ByVal Level As Long, Optional ByVal TagStartPos As Long, Optional ByVal TagLength As Long) As Boolean
  'no Callback is ever triggered for this Interface-Member)
End Function

