VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cReq"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public hSocket As Long

Private WebApp As cWebApp

Public Sub ProcessBytes(B() As Byte, TCPServer As cTCPServer)
Dim sReq$, sUrl$, PosStart&, PosEnd&, Params$()
  
  On Error GoTo CloseConn 'close Connection on any Error
  
  'just a word to this "naive" assumption, that the ByteArray B() always
  'contains the complete Request-String. This only works in this Demo,
  'because the Get-Requests, which come in over the Sockets are really
  'short and therefore are usually received in "one single piece".
  'Normally you should buffer the B()-Array-Contents up to the point, when
  'the entire Content is received by parsing the HTTP-Header of this Request
  sReq = StrConv(B, vbUnicode)
  
  'here in this simple Demo we restrict the Webserver,
  'to process Get-Requests only
  If UCase$(Left$(sReq, 3)) <> "GET" Then GoTo CloseConn
  
  PosStart = InStr(sReq, "/")
  PosEnd = InStr(PosStart, sReq, " ")
  sUrl = Mid(sReq, PosStart, PosEnd - PosStart)
  
  If Left$(sUrl, 1) = "/" Then sUrl = Right$(sUrl, Len(sUrl) - 1)
  
  If WebApp.Auth(sReq) Then 'already authenticated
    If Len(sUrl) = 0 Then
      SendHttpResponse TCPServer, 200, WebApp.DefaultPage
    Else
      Params = Split(sUrl, ",")
      SendHttpResponse TCPServer, 200, WebApp.FrameEngine(Params)
    End If
  Else 'let's authenticate the session first
    SendHttpResponse TCPServer, 401, "<HTML><BODY>Nice try! ;-)</BODY></HTML>"
  End If
Exit Sub

CloseConn:
  TCPServer.Disconnect hSocket
End Sub

Private Sub SendHttpResponse(TCPServer As cTCPServer, ByVal RespType&, sResp$, Optional ContentType$)
Dim SArr$(6), B() As Byte, ContentLen&
  ContentLen = Len(sResp)
  If Len(ContentType) = 0 Then ContentType = "text/html"
  
  Select Case RespType
    Case 200: SArr(0) = "HTTP/1.1 200 ok"
    Case 301: SArr(0) = "HTTP/1.1 301 Moved Permanently"
    Case 401: SArr(0) = "HTTP/1.1 401 Authorization Required" & vbCrLf & _
                      "WWW-Authenticate: Basic realm=""MyRealm"""
    Case 403: SArr(0) = "HTTP/1.1 403 Forbidden"
    Case 404: SArr(0) = "HTTP/1.1 404 File Not Found"
    Case Else: SArr(0) = "HTTP / 1.1 " & RespType
  End Select
  
  SArr(1) = "Server: MyServer/1.0"
  SArr(2) = "Connection: Keep-Alive"
  SArr(3) = "Content-Length: " & ContentLen
  SArr(4) = "Content-Type: " & ContentType
  'SArr(5) = left out, to create one additional vbCrLf
  SArr(6) = sResp 'and finally we place the real Response-Content behind all Headerlines
  
  'Now we convert all into a ByteArray and send it out completely
  B = StrConv(Join(SArr, vbCrLf), vbFromUnicode)
  TCPServer.SendData hSocket, VarPtr(B(0)), UBound(B) + 1
End Sub

Private Sub Class_Initialize()
  Set WebApp = New cWebApp
End Sub
