VERSION 5.00
Begin VB.Form fGridCalc 
   Caption         =   "Form1"
   ClientHeight    =   5460
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   8730
   LinkTopic       =   "Form1"
   ScaleHeight     =   5460
   ScaleWidth      =   8730
   StartUpPosition =   3  'Windows-Standard
   Begin SimpleSpreadSheet.ucCalc ucCalc1 
      Height          =   3975
      Left            =   450
      TabIndex        =   2
      Top             =   840
      Width           =   7575
      _ExtentX        =   13361
      _ExtentY        =   7011
   End
   Begin VB.PictureBox PTop 
      Align           =   1  'Oben ausrichten
      BorderStyle     =   0  'Kein
      Height          =   405
      Left            =   0
      ScaleHeight     =   405
      ScaleWidth      =   8730
      TabIndex        =   0
      Top             =   0
      Width           =   8730
      Begin VB.CommandButton cmdClear 
         Caption         =   "Clear View"
         Height          =   315
         Left            =   4890
         TabIndex        =   5
         Top             =   45
         Width           =   1215
      End
      Begin VB.ComboBox cmbSheets 
         Height          =   315
         Left            =   1170
         Sorted          =   -1  'True
         Style           =   2  'Dropdown-Liste
         TabIndex        =   4
         Top             =   45
         Width           =   2325
      End
      Begin VB.CommandButton cmdSave 
         Caption         =   "Save As..."
         Height          =   315
         Left            =   3570
         TabIndex        =   1
         Top             =   45
         Width           =   1215
      End
      Begin VB.Label lblSheets 
         Caption         =   "Sheets in DB:"
         Height          =   225
         Left            =   90
         TabIndex        =   3
         Top             =   120
         Width           =   1275
      End
   End
End
Attribute VB_Name = "fGridCalc"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This demo shows the usage of the cFormula-Class and also
'how to implement an efficient sparse-matrix-approach with
'the help of the fast cSortedDictionary, which can also accept
'Long-Keys instead of String-Keys - and the Long-Key-Value
'we use here is build with some BitOps (allows a max of 262143
'Rows and 8191 columns currently) - but you can adjust the
'appropriate Const in cSheet, to match better with your scenarios

'the used HFlex-Grid is not all that tightly integrated into
'the solution, since it does not know about cSheet or cCell
'(where the main-work/-calculation is done) - this Form here
'"connects" and manages the two worlds (the grid and the cSheet)
'over normal VB-Events, raised from both sides.

'also the SQLite-Wrapper is demonstrated as the persistence-engine
'for our Sheet-Data (the Cell-Content of a given Sheet is stored
'in a normal DB-Table in normal Columns)
Option Explicit

Private WithEvents Sheet As cSheet
Attribute Sheet.VB_VarHelpID = -1
Private ColKeys(0 To 26) As String
Private Cnn As cConnection

Private Sub Form_Load()
Dim i As Long
  On Error Resume Next
    Set Cnn = New_c.Connection(App.Path & "\Sheets.db") 'instantiate a DB-Connection (and try to open the File)
  If Err Then 'not yet there, so we create a new one
    On Error GoTo 0
    Set Cnn = New_c.Connection(App.Path & "\Sheets.db", DBCreateNewFileDB)
  End If

  RefreshSheetsCombo 'list the DB-Tables (where we store our Sheet-Content)
  
  For i = 1 To 26 'prefill a small Lookup-Table...
    ColKeys(i) = Chr$(64 + i) 'for a somewhat faster mapping of Col-Idxes to the ColHeader-Chars A-Z
  Next i
  
  ucCalc1.Rows = 256 'set max-rows (the Columns in this Demo are currently "hardwired" at 26 Cols (A-Z)
  
  Timing Start
    Set Sheet = New cSheet
    FillDemoSheet Sheet
    Sheet.ReCalc
  Caption = Timing & " for a Fill with " & Sheet.CellCount & " Cells and the first Recalc"
End Sub

Private Sub Form_Resize()
  ucCalc1.Move 0, PTop.Height, ScaleWidth, ScaleHeight - PTop.Height
End Sub

Private Sub cmbSheets_Click()
  If cmbSheets.ListIndex < 0 Then Exit Sub
  Timing Start
    ucCalc1.Grid.Clear
    Sheet.LoadFromDb Cnn, cmbSheets.Text
    If ucCalc1.Rows < Sheet.CurrentLastRow Then 'set some more Rows in the hosting-Grid, than the cSheet contains
      ucCalc1.Rows = Sheet.CurrentLastRow + 20
    End If
    Sheet.ReCalc
  Caption = Timing & " for a Fill with " & Sheet.CellCount & " Cells and the first Recalc"
End Sub

Private Sub cmdSave_Click()
Dim SheetName As String
  SheetName = InputBox("Which SheetName?")
  If Len(SheetName) = 0 Then Exit Sub
  
  Sheet.SaveToDB Cnn, SheetName
  RefreshSheetsCombo
  cmbSheets.Text = SheetName
End Sub

Private Sub cmdClear_Click() 'only the current Sheet is cleared, this action does not interact with the DB
  Sheet.Clear
  ucCalc1.Grid.Clear
  cmbSheets.ListIndex = -1
  ucCalc1.Rows = 64
End Sub

Private Sub RefreshSheetsCombo()
Dim Tbl As cTable
  cmbSheets.Clear
  For Each Tbl In Cnn.DataBases(1).Tables
    cmbSheets.AddItem Tbl.Name
  Next Tbl
End Sub

Private Sub Sheet_RecalcFinished()
  GridRefresh
End Sub

Private Sub ucCalc1_StartEdit(ByVal Row As Long, ByVal Col As Long, Text As String)
  If Len(Sheet.Cell(ColKeys(Col) & Row).Formula) Then
    Text = "=" & Sheet.Cell(ColKeys(Col) & Row).Formula
  End If
End Sub

Private Sub ucCalc1_EndEdit(ByVal Row As Long, ByVal Col As Long, Text As String, Cancel As Boolean)
  If Left$(Text, 1) = "=" Then
    Sheet.Cell(ColKeys(Col) & Row).Formula = Text
  Else
    If Left$(Text, 1) = "." Or Left$(Text, 1) = "," Then Text = "0" & Text
    If IsNumeric(Text) Then
      Sheet.Cell(ColKeys(Col) & Row).Value = Val(Replace(Text, ",", "."))
    Else
      Sheet.Cell(ColKeys(Col) & Row).Value = Text
    End If
  End If
  Timing Start
  Sheet.ReCalc
  Caption = Sheet.CellCount & " " & Timing
End Sub

Private Sub ucCalc1_DelKeyPressed(ByVal Row As Long, ByVal Col As Long, Cancel As Boolean)
  Sheet.CellRemove ColKeys(Col) & Row
  Sheet.ReCalc
  Caption = Sheet.CellCount
End Sub

Private Sub GridRefresh()
Dim Cell As cCell, RowBuf As Long, ColBuf As Long, V
  
  With ucCalc1.Grid
    .Redraw = False
    RowBuf = .Row: ColBuf = .Col
    
    For Each Cell In Sheet
      .Row = Cell.RowIdx: .Col = Cell.ColIdx
      .Text = Cell.Text
    Next Cell
    
    .Row = RowBuf: .Col = ColBuf
    .Redraw = True
  End With
End Sub

'just to demonstrate the direct-fill-mode, which the Demo starts with
'(for DB-Loading you will have to click the Combo)
Private Sub FillDemoSheet(Sheet As cSheet)
Dim i As Long, j As Long, Cell As cCell
  For i = 1 To 20 'loop over the Columns
    For j = 1 To 100 'loop over the Rows
      Sheet.Cell(ColKeys(i) & j).Value = j 'and simply add the Row-Index as the Cell-Value
    Next j
  Next i

  'loop over the Rows, to add a Sum-Formula to the right (in Column "U")
  For j = 1 To 100
    Sheet.Cell("U" & j).Formula = "Sum(A" & j & ":T" & j & ")"
    Sheet.Cell("U" & j).FormatString = "0.00 "
  Next j
  'loop over the Rows, to add a Tax-Formula to the right of Column "U" (in Column "V")
  For j = 1 To 101
    Set Cell = Sheet.Cell("V" & j)
    Cell.Formula = "U" & j & " * 0.19"
    Cell.FormatString = "0.00 "
  Next j

  For i = 1 To 20 'loop over the Cols, to add a Sum-Formula to the Bottom (in Row 101)
    Set Cell = Sheet.Cell(ColKeys(i) & "101")
    Cell.Formula = "Sum(" & ColKeys(i) & "1:" & ColKeys(i) & "100)"
    Cell.FormatString = "0.00 "
  Next i

  Sheet.Cell("U101").Formula = "Sum(A101:T101)" 'finally a "nested" Sum of the Column-Sums in Row 201
  Sheet.Cell("U101").FormatString = "0.00 "
End Sub

