VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cCell"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public FormatString As String

Private mCB As cCircleBreaker, mAddr As String
Private mValue, mCalculatedValue, mReCalc As Boolean
Private mFormula As String, mPreparedFormula As String
Private CellRefs() As String, SumDefs() As String

Friend Sub SetCBAndAddr(CB As cCircleBreaker, Addr As String)
  Set mCB = CB
  mAddr = Addr
End Sub

Friend Sub SetRecalcFlag()
  mReCalc = True
End Sub

Public Property Get RowIdx() As Long
  RowIdx = Mid$(mAddr, 2)
End Property
Public Property Get ColIdx() As Long
  ColIdx = Asc(mAddr) - 64
End Property

Public Property Let Value(ByVal NewValue)
  mValue = NewValue
  If Not IsEmpty(mValue) Then
    mFormula = vbNullString
  Else
    mCB.ParentSheet.CellRemove mAddr
  End If
End Property
Public Property Get Value()
  If Len(mFormula) Then
    If mReCalc Then Calculate
    Value = mCalculatedValue
  Else
    Value = mValue
  End If
End Property

Public Property Get Text() As String
  If Len(FormatString) Then
    Text = Format$(Value, FormatString)
  Else
    Text = Value
  End If
End Property

Public Property Get Addr() As String
  Addr = mAddr
End Property

Public Property Let Formula(NewValue As String)
  If Left$(NewValue, 1) = "=" Then
    mFormula = Mid$(NewValue, 2)
  Else
    mFormula = NewValue
  End If
  If Len(mFormula) Then
    mValue = vbNullString
    mPreparedFormula = mFormula & vbNullChar
    PreParseFormula
  Else
    If Len(mValue) = 0 Then mCB.ParentSheet.CellRemove mAddr
  End If
End Property
Public Property Get Formula() As String
  Formula = mFormula
End Property


'-------- the following Private Helper-Subs are only called once (when setting a new Formula for a Cell) -------
Private Sub PreParseFormula()
  ParseSumDefs
  ParseCellRefs
End Sub

Private Sub ParseSumDefs()
Dim i&, PosStart As Long, Pos As Long, PosEnd As Long, Arg As String
  SumDefs = Split(vbNullString) 'set a 0 to -1 array
  'now we replace the Sum-Formulas with a Variable-Expression
  PosStart = 1
  Do
    Pos = InStr(PosStart, mPreparedFormula, "Sum(", vbTextCompare)
    If Pos = 0 Then 'Ok, one last fallback with a space following 'Sum'
      Pos = InStr(PosStart, mPreparedFormula, "Sum (", vbTextCompare)
    End If
    If Pos = 0 Then Exit Do
    
    PosStart = Pos
    PosEnd = InStr(PosStart + 5, mPreparedFormula, ")", vbTextCompare)
    If PosEnd = 0 Then Exit Do
    Arg = Mid$(mPreparedFormula, PosStart, PosEnd - PosStart + 1)
    Arg = Replace$(Arg, "Sum", vbNullString, , , vbTextCompare)
    Arg = UCase$(Trim$(Replace$(Replace$(Arg, ")", vbNullString), "(", vbNullString)))
    Arg = "Sum_" & Replace$(Arg, ":", "_")
    AddSumDef Arg
    Mid$(mPreparedFormula, PosStart, PosEnd - PosStart + 1) = Arg & "   " 'replace the former SumDef
    PosStart = PosEnd
  Loop
End Sub
Private Sub AddSumDef(SumDef As String)
Dim NewIdx As Long
  NewIdx = UBound(SumDefs) + 1
  ReDim Preserve SumDefs(NewIdx)
  SumDefs(NewIdx) = SumDef
End Sub

Private Sub ParseCellRefs()
Dim i&, WithinString As Long, Char As Long
  CellRefs = Split(vbNullString) 'set a 0 to -1 array
  For i = 1 To Len(mPreparedFormula)
    Char = AscW(Mid$(mPreparedFormula, i, 1))
    Select Case Char
      Case 65 To 90, 97 To 122 'A-Z, a-z
        If WithinString = 0 And Mid$(mPreparedFormula, IIf(i - 1 > 0, i - 1, 1), 1) <> "_" Then
          Select Case AscW(Mid$(mPreparedFormula, i + 1, 1))
            Case 48 To 57: AddCellRef mPreparedFormula, i
          End Select
        End If
        
      Case 34, 39
        If WithinString = 0 Then
          WithinString = Char
        ElseIf WithinString = Char Then
          WithinString = 0
        End If
    End Select
  Next i
End Sub
Private Sub AddCellRef(Formula As String, StartPos As Long)
Dim i As Long, NewIdx As Long, Char As Long
  NewIdx = UBound(CellRefs) + 1
  ReDim Preserve CellRefs(NewIdx)
  CellRefs(NewIdx) = UCase$(Mid$(Formula, StartPos, 1))
  Do
    StartPos = StartPos + 1
    Char = AscW(Mid$(Formula, StartPos, 1))
    If Char < 48 Or Char > 57 Then Exit Do
    CellRefs(NewIdx) = CellRefs(NewIdx) & Chr(Char)
  Loop
End Sub
'-------------------- End of Preparsing the Formula -----------------------



'And finally the Cell-Calculation-Routine...
'which is pretty small, since we make use of the preparsed mPreparedFormula-StringVariable
'which already contains the Expression for our cFormula-based Evaluator -
'what we do before the Evaluation on of mPreparedFormula, is to ensure the correct
'setting of the Evaluator-internal Variables (we need to pass the VarIdentifiers which
'are contained in mPreparedFormula to the Evaluator (together with their values of course)
Private Sub Calculate()
Dim i&, ErrString As String, ParentSheet As cSheet
  On Error Resume Next

  Set ParentSheet = mCB.ParentSheet

  For i = 0 To UBound(SumDefs) 'the real sum-defs were replaced inside PreParseFormula() with normal Var-Identifiers
    ParentSheet.Evaluator.SetVar SumDefs(i), ParentSheet.CalcSum(SumDefs(i)) 'so we calculate and set these vars beforehand
  Next i
  For i = 0 To UBound(CellRefs)
    ParentSheet.Evaluator.SetVar CellRefs(i), ParentSheet.Cell(CellRefs(i)).Value 'get and set the CellRef-Vars too...
  Next i
  
  mCalculatedValue = ParentSheet.Evaluator.Evaluate(mPreparedFormula, ErrString) 'so that we can calculate the expression now
  
  If Len(ErrString) Then mCalculatedValue = "#" & ErrString
  If Err Then Err.Clear
  mReCalc = False 'make sure, each cell does it only once after each Sheet.Recalc (which has set this Flag to true)
End Sub
