VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Begin VB.Form fTestNWindADO 
   Caption         =   "ADO: Query-Performance"
   ClientHeight    =   7245
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   8955
   LinkTopic       =   "Form1"
   ScaleHeight     =   7245
   ScaleWidth      =   8955
   StartUpPosition =   3  'Windows-Standard
   Begin VB.Frame fDG 
      Caption         =   "DataGrid"
      Height          =   4875
      Left            =   90
      TabIndex        =   6
      Top             =   2130
      Width           =   8655
      Begin MSDataGridLib.DataGrid DG 
         Height          =   3345
         Left            =   270
         TabIndex        =   7
         Top             =   360
         Width           =   7125
         _ExtentX        =   12568
         _ExtentY        =   5900
         _Version        =   393216
         HeadLines       =   1
         RowHeight       =   15
         BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ColumnCount     =   2
         BeginProperty Column00 
            DataField       =   ""
            Caption         =   ""
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1031
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column01 
            DataField       =   ""
            Caption         =   ""
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1031
               SubFormatType   =   0
            EndProperty
         EndProperty
         SplitCount      =   1
         BeginProperty Split0 
            BeginProperty Column00 
            EndProperty
            BeginProperty Column01 
            EndProperty
         EndProperty
      End
   End
   Begin VB.CheckBox chkSimulateAppServerRequests 
      Caption         =   "Force querying, to work as in Client/AppServer-Scenarios using disconnected Recordsets"
      Height          =   645
      Left            =   6120
      TabIndex        =   5
      Top             =   135
      Width           =   2580
   End
   Begin VB.ListBox lstTables 
      Height          =   1425
      Left            =   630
      Sorted          =   -1  'True
      TabIndex        =   1
      Top             =   135
      Width           =   2175
   End
   Begin VB.ListBox lstViews 
      Height          =   1425
      Left            =   3600
      Sorted          =   -1  'True
      TabIndex        =   0
      Top             =   135
      Width           =   2220
   End
   Begin VB.Label lTiming 
      BorderStyle     =   1  'Fest Einfach
      ForeColor       =   &H00FF0000&
      Height          =   330
      Left            =   90
      TabIndex        =   4
      Top             =   1710
      Width           =   8655
   End
   Begin VB.Label lTables 
      Caption         =   "Tables"
      Height          =   240
      Left            =   90
      TabIndex        =   3
      Top             =   165
      Width           =   645
   End
   Begin VB.Label lViews 
      Caption         =   "Views"
      Height          =   240
      Left            =   3105
      TabIndex        =   2
      Top             =   165
      Width           =   555
   End
End
Attribute VB_Name = "fTestNWindADO"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Basically the same (Performance-)Demo as in fTestNWinddhSQLite -
'but here we work with ADO-Rs over JET/OLEDB against an Access-*.mdb.
'Look at the amount of the needed Code - we need quite a bit more
'LOC than with the SQLite-Pendant. This grounds more or less on
'the need, to release CycleRefs inside the dependend Objects over
'the appropriate Close-Methods. dhSQLites Obj-Model (Connections,
'Recordsets, Binding-Sources) contains no Cycle-Refs and doesn't
'need separate Close-Methods. Simply set the appropriate SQLite-
'object to Nothing and you are done - less Code-Typing, no Memory-
'Leaks due to lazy coding, etc.

'There's one catch with dhSQLites "Non-Cyclic-Implementation",
'especially (and only if) using the ADO-Databinding:
'As soon as an dhSQLite-Rs is set to nothing (and terminates),
'an eventually bound Control disconnects immediately and frees
'all its Binding-Resources (meaning, it shows no Data anymore).
'So other than with "original" ADO-Rs-Databinding you have to keep
'the dhSQLite-Recordset "alive" (declare the Variable at Form-
'or Class-Level), as long as you don't want to see only a short
'"blink" of the Data, showing up e.g. in a bound Datagrid only
'for a very short time. E.g. if you've declared the dhSQLite-Rs
'only at Procedure-Level and you are running over End Sub - the
'SQLite-Rs-Variable then goes automatically out of scope (is set
'to nothing) and your Databinding is released instantly at this
'point.

Option Explicit

'Private DGExt As VBControlExtender, DG As Object 'DataGrid-Variables
Private Cnn As ADODB.Connection, Rs As ADODB.Recordset, DBName$

Private Sub Form_Load()
Dim RsSchema As ADODB.Recordset, FType As ADODB.Field, FName As ADODB.Field
  DBName = App.Path & "\NWind.mdb"
  
  'add the Datagrid dynamically (without using the registry)
'  fMain.AddDataGrid Me, DGExt, DG, fDG
  
  Set Cnn = New ADODB.Connection
  Cnn.CursorLocation = adUseClient
  
  Timing Start

    Cnn.Open "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & DBName
    Set RsSchema = Cnn.OpenSchema(adSchemaTables)
    Set FName = RsSchema.Fields("TABLE_NAME")
    Set FType = RsSchema.Fields("TABLE_TYPE")
    Do Until RsSchema.EOF
      If FType.Value = "TABLE" Then
        lstTables.AddItem FName.Value
      ElseIf FType.Value = "VIEW" Then
        lstViews.AddItem FName.Value
      End If
      RsSchema.MoveNext
    Loop
  
  lTiming.Caption = Timing & " to open the DB and to " & _
                    "populate all Lists with the Table- and View-Names"
End Sub

Private Sub lstTables_Click()
  If lstTables.ListIndex = -1 Then Exit Sub Else lstViews.ListIndex = -1
  Screen.MousePointer = 13
    QueryAndVisualize lstTables.Text
  Screen.MousePointer = 0
End Sub

Private Sub lstViews_Click()
  If lstViews.ListIndex = -1 Then Exit Sub Else lstTables.ListIndex = -1
  Screen.MousePointer = 13
    QueryAndVisualize lstViews.Text
  Screen.MousePointer = 0
End Sub

Private Sub QueryAndVisualize(TableOrViewName As String)
Static SW As Boolean: SW = Not SW
  If chkSimulateAppServerRequests.Value = 1 Then 'simulate an Appserver-Scenario using disconnected Rs
    
    Timing Start 'timing starts at the serverside - until the client can do work with the data
    
      'at the serverside:
      Dim ServerCnn As ADODB.Connection, ServerRs As ADODB.Recordset, BytesToSend() As Byte
      Set ServerCnn = New ADODB.Connection
      ServerCnn.CursorLocation = adUseClient
      ServerCnn.Open "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & DBName
      Set ServerRs = New ADODB.Recordset
      ServerRs.Open "Select * from [" & TableOrViewName & "]", ServerCnn, adOpenStatic, adLockBatchOptimistic
      'now serialize into Bytes, to send them "over the wire"
      Dim PB As PropertyBag
      Set PB = New PropertyBag
      PB.WriteProperty "Rs", ServerRs
      BytesToSend = PB.Contents
      Set PB = Nothing
      If ServerRs.State = adStateOpen Then ServerRs.Close 'proper ADO-Rs-Cleanup
      Set ServerRs = Nothing
      If ServerCnn.State = adStateOpen Then ServerCnn.Close 'proper ADO-Cnn-Cleanup
      Set ServerCnn = Nothing
      'we have done our cleanup at the serverside and are ready to transfer the Bytes
      
      'simulation of transferring bytes over e.g. TCP/IP ...
      Dim BytesReceived() As Byte
      BytesReceived = BytesToSend
      
      'Now that our Bytes arrived at the clientside,...
      If Not Rs Is Nothing Then If Rs.State = adStateOpen Then Rs.Close 'proper ADO-Rs-Cleanup
      Set PB = New PropertyBag
      PB.Contents = BytesReceived
      Set Rs = PB.ReadProperty("Rs") '...we can deserialize them into an Rs...
      Set PB = Nothing
      
      '...and open the ClientRs for "visual processing"
    
    lTiming.Caption = Timing & " for " & Rs.RecordCount & " Records (" & Rs.Fields.Count & " Columns)"
    
  Else '"normal", clientside DB-Requests on an already established Connection
  
    Timing Start
    
      If Not Rs Is Nothing Then If Rs.State = adStateOpen Then Rs.Close 'proper ADO-Rs-Cleanup
      Set Rs = New ADODB.Recordset
      Rs.Open "Select * from [" & TableOrViewName & "]", Cnn, adOpenStatic, adLockBatchOptimistic
      
    lTiming.Caption = Timing & " for " & Rs.RecordCount & " Records (" & Rs.Fields.Count & " Columns)"
  End If
  
  Set DG.DataSource = Rs
End Sub

Private Sub Form_Resize()
On Error Resume Next
  fDG.Move 45, (lTiming.Top + lTiming.Height), ScaleWidth - 90, ScaleHeight - (lTiming.Top + lTiming.Height) - 45
  DG.Move 15, 240, fDG.Width - 45, fDG.Height - 255
  lTiming.Move -3, lTiming.Top, ScaleWidth + 6
End Sub

Private Sub Form_Unload(Cancel As Integer)
  'all this is needed only with ADO-Objects and -Databinding
  'dhSQLite-Objects and -Databindings don't need separate
  'Close-Statements, to break cyclic references and do cleanup
  Set DG.DataSource = Nothing
  If Not Rs Is Nothing Then
    If Rs.State = adStateOpen Then Rs.Close
  End If
  If Not Cnn Is Nothing Then
    If Cnn.State = adStateOpen Then Cnn.Close
  End If
  Set Rs = Nothing
  Set Cnn = Nothing
  
 'remove our dynamically added DataGrid
'  Set DG = Nothing
'  Set DGExt = Nothing
'  Controls.Remove "DG"
End Sub

