VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Begin VB.Form fStarSchema 
   Caption         =   "NWind.db - Star-Schema"
   ClientHeight    =   7830
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   13095
   LinkTopic       =   "Form1"
   ScaleHeight     =   7830
   ScaleWidth      =   13095
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton cmdShowCube 
      Caption         =   "Show Cube..."
      Height          =   345
      Left            =   120
      TabIndex        =   3
      Top             =   1920
      Width           =   1155
   End
   Begin VB.ListBox lstSchema 
      Height          =   1425
      Left            =   120
      TabIndex        =   1
      Top             =   360
      Width           =   1125
   End
   Begin MSDataGridLib.DataGrid DG 
      Height          =   7365
      Left            =   1410
      TabIndex        =   0
      Top             =   360
      Width           =   11535
      _ExtentX        =   20346
      _ExtentY        =   12991
      _Version        =   393216
      AllowUpdate     =   0   'False
      HeadLines       =   1
      RowHeight       =   15
      BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ColumnCount     =   2
      BeginProperty Column00 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1031
            SubFormatType   =   0
         EndProperty
      EndProperty
      BeginProperty Column01 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1031
            SubFormatType   =   0
         EndProperty
      EndProperty
      SplitCount      =   1
      BeginProperty Split0 
         BeginProperty Column00 
         EndProperty
         BeginProperty Column01 
         EndProperty
      EndProperty
   End
   Begin VB.Label Label2 
      Caption         =   "Just click into the list to the left, to see what the different InMemory-Tables contain"
      Height          =   255
      Left            =   1410
      TabIndex        =   4
      Top             =   120
      Width           =   7155
   End
   Begin VB.Label Label1 
      Caption         =   "Star-Schema:"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   1155
   End
End
Attribute VB_Name = "fStarSchema"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private FileCnn As cConnection, Rs As cRecordset
Public StarCnn As cConnection 'make this visible to the "outside" (frmCube in this case)

Private Sub cmdShowCube_Click()
  fCube.Show , Me
End Sub

Private Sub Form_Load()
  Timing Start
  
  'open a filebased DB, which delivers the real Data for our InMemory-StarSchema
  Set FileCnn = New_c.Connection(App.Path & "\Nwind.db")
  'create an InMemory-DBConnection-Object
  Set StarCnn = New_c.Connection(, DBCreateInMemory)

  'Ok, let's create the simple star-schema inside the InMemory-DB

  'First the central Facts-Table, which holds the IDs to its
  '"dimension-tables" in CustomerID, CountryID, EmployeeID, CategoryID
  'and ProductID - and additionally of course also the "Facts-"
  'or Data-Columns" as e.g. selled Units and also precalculated
  'ExtendedPrices (based on Units * UnitPrice - Discount).
  'The "Time-Dimension" is included directly inside the Facts-Table
  '(with Year-, Quarter-, Month-, Week- and Day-Columns) and *not*
  'separated over an appropriate "Time-Dimension-ID", pointing to a
  '"Time-Dimension-Table" (to allow easier and faster queries)
  CreateFactsTableInMemory
  
  'Now, since we have our central Facts-Table in our StarCnn,
  'we can create the Dimension-Tables (which give us details
  'to the referencing xxxIDs in the facts-table)...and as said above -
  'for the Time-Dimension(s) we do not use this "Table-Indirection"
  CreateDimension "Customers", "CustomerID, CompanyName"
  CreateDimension "Countries", "CountryID, Country"
  CreateDimension "Employees", "EmployeeID, FirstName || ' ' || LastName As EmployeeName"
  CreateDimension "Categories", "CategoryID, CategoryName"
  CreateDimension "Products", "ProductID, ProductName"

  'Now we place the contained Star-Table-Names in a ListBox (for your Lookup)
  'since we've created new stuff on it, we update the Schema-ObjModel first...
  StarCnn.DataBases(1).ReScanSchemaInfo
  '...and enumerate the tables, we currently have in StarCnn
  Dim Tbl As cTable
  For Each Tbl In StarCnn.DataBases(1).Tables
    lstSchema.AddItem Tbl.Name
  Next Tbl

  Caption = Caption & " created InMemory after: " & Timing
  Set FileCnn = Nothing
End Sub

Private Sub lstSchema_Click()
  Set Rs = StarCnn.OpenRecordset("Select * From " & lstSchema.Text)
  Set DG.DataSource = Rs.DataSource
End Sub

Private Sub CreateFactsTableInMemory()
Dim Rs As cRecordset, SQL As String
  'retrieve the facts-table-resultset
  SQL = "SELECT Orders.OrderID, CustomerID, 0 As CountryID, EmployeeID, CategoryID, Products.ProductID," & vbCrLf & _
          "CLng(Left$(OrderDate,4)) As Year," & vbCrLf & _
          "CLng(DatePart('q', OrderDate)) As Quarter," & vbCrLf & _
          "CLng(Mid$(OrderDate,6,2)) as Month," & vbCrLf & _
          "CLng(DatePart('ww', OrderDate)) as Week," & vbCrLf & _
          "OrderDate As Day, " & vbCrLf & _
          "Quantity," & vbCrLf & _
          "Round([Order Details].UnitPrice * Quantity * (1 - Discount), 2) AS ExtendedPrice," & vbCrLf & _
          "Round([Order Details].UnitPrice * Quantity * Discount, 2) AS ExtendedDiscount" & vbCrLf & _
        "From Products" & vbCrLf & _
        "Inner Join [Order Details]" & vbCrLf & _
        "ON Products.ProductID = [Order Details].ProductID" & vbCrLf & _
        "Inner Join Orders" & vbCrLf & _
        "On Orders.OrderID = [Order Details].OrderID" & vbCrLf & _
        "Order By Orders.OrderID"
  Set Rs = FileCnn.OpenRecordset(SQL)
  
  'and now let's beam the content of the Rs as a new table into a new InMemory-DB
  StarCnn.CreateTableFromRsContent Rs.Content, "Facts"
  
  'and finally create the indexes for all our Dimension-Fields
  CreateIndexOn "Facts", "OrderID", "OrderID, Year, Quarter"
  CreateIndexOn "Facts", "CustomerID", "CustomerID, Year, Quarter"
  CreateIndexOn "Facts", "EmployeeID", "EmployeeID, Year, Quarter"
  CreateIndexOn "Facts", "CategoryID", "CategoryID, Year, Quarter"
  CreateIndexOn "Facts", "ProductID", "ProductID, Year, Quarter"
  CreateIndexOn "Facts", "Year", "Year, Quarter, Month"
  CreateIndexOn "Facts", "Quarter", "Quarter, Month"
  CreateIndexOn "Facts", "Month"
  CreateIndexOn "Facts", "Week"
  CreateIndexOn "Facts", "Day"

  
  'Ok, normally that should have been the tasks for the facts-table, but we
  'need to perform an additional "operation" on the currently yet empty
  'CountryID-Dimension-Column (where we have placed only a Zero-Integer so far
  'as a "placeholder") - please look at it as "additional denormalization-effort" ;-)
  'The NWind-DB does not have a separate Countries-Table, so we create one now
  '(only as a Temp-Table in Memory - but on the Filebased-DB-Connection)
  FileCnn.Execute "Create Temp Table Countries(CountryID Integer Primary Key, Country Text)"
  FileCnn.Execute "Insert Into Countries Select Distinct Null As CountryID, Country From Customers"
  'after we've created our Countries-table, we create an "inverse lookup-Recordset" now
  Set Rs = FileCnn.OpenRecordset("Select CustomerID, CountryID From Customers " & _
           " Inner Join Countries On Customers.Country=Countries.Country")
  'and do our Updates against the InMem-DB appropriately (over a Command-Object)
  With StarCnn.CreateCommand("Update Facts Set CountryID=? Where CustomerID=?")
    Do Until Rs.EOF
      .SetInt32 1, Rs(1).Value
      .SetText 2, Rs(0).Value
      .Execute
      Rs.MoveNext
    Loop
  End With
  CreateIndexOn "Facts", "CountryID", "CountryID, Year, Quarter" 'and the index on this later on populated Fact-Column
End Sub

Private Sub CreateDimension(NewTableName As String, FieldList As String, Optional ByVal SrcTableName As String)
Dim Rs As cRecordset
  'perform the Select on only these Fields we want to store in the Dimension-Table
  If Len(SrcTableName) = 0 Then SrcTableName = NewTableName
  Set Rs = FileCnn.OpenRecordset("Select " & FieldList & " From " & SrcTableName)
  
  'and create the appropriate InMem-Table from the Resultset
  StarCnn.CreateTableFromRsContent Rs.Content, NewTableName
  
  'finally here also the Index-Creation
  CreateIndexOn NewTableName, Split(FieldList, ",")(0)
End Sub

Private Sub CreateIndexOn(ByVal TableName As String, ByVal IndexName As String, Optional FieldList As String)
  If Len(FieldList) = 0 Then FieldList = IndexName
  StarCnn.Execute "Create Index If Not Exists [idx_" & IndexName & "] " & _
                  "On [" & TableName & "](" & FieldList & ")"
End Sub

