VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Begin VB.Form fInMemoryDBFromADO 
   Caption         =   "InMemory-DB (build from serialized Rs)"
   ClientHeight    =   6330
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   10335
   LinkTopic       =   "Form1"
   ScaleHeight     =   6330
   ScaleWidth      =   10335
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CommandButton cmdDump 
      Caption         =   "Dump from NWind.mdb into InMemory-Tables -->"
      Height          =   315
      Left            =   90
      TabIndex        =   2
      Top             =   120
      Width           =   3705
   End
   Begin VB.ComboBox cmbTables 
      Height          =   315
      Left            =   3900
      Style           =   2  'Dropdown-Liste
      TabIndex        =   1
      Top             =   120
      Width           =   1515
   End
   Begin VB.Frame fDG 
      Caption         =   "DataGrid"
      Height          =   5175
      Left            =   90
      TabIndex        =   0
      Top             =   1020
      Width           =   10125
      Begin MSDataGridLib.DataGrid DG 
         Height          =   4395
         Left            =   270
         TabIndex        =   4
         Top             =   390
         Width           =   8235
         _ExtentX        =   14526
         _ExtentY        =   7752
         _Version        =   393216
         HeadLines       =   1
         RowHeight       =   15
         BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ColumnCount     =   2
         BeginProperty Column00 
            DataField       =   ""
            Caption         =   ""
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1031
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column01 
            DataField       =   ""
            Caption         =   ""
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1031
               SubFormatType   =   0
            EndProperty
         EndProperty
         SplitCount      =   1
         BeginProperty Split0 
            BeginProperty Column00 
            EndProperty
            BeginProperty Column01 
            EndProperty
         EndProperty
      End
   End
   Begin VB.Label lTiming 
      BorderStyle     =   1  'Fest Einfach
      Height          =   330
      Left            =   90
      TabIndex        =   3
      Top             =   540
      Width           =   10125
   End
End
Attribute VB_Name = "fInMemoryDBFromADO"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This examples wants to demonstrate, how to use SQLite
'as an InMemory-DBEngine. Working InMemory is in no
'way different than working with a filebased Connection
'(beside the lacking "Disk-Persistence").

'This concrete example here demonstrates only a simple
'ADO-Recordset-based "Dumping" of all tables inside NWind.mdb
'into memory using a small helper-function (CreateTableFromADORs)
'which will be a candidate for integration into the toolset
'in a next release - but here it comes as sourcecode
Option Explicit

Private DBName As String, Cnn As cConnection, Rs As cRecordset

Private Sub cmdDump_Click()
Dim CnnSrc As ADODB.Connection, RsSrc As ADODB.Recordset, T!
Dim RsSchema As ADODB.Recordset, TType As ADODB.Field, TName As ADODB.Field
  DBName = App.Path & "\NWind.mdb"

  'open a filebased Src-Database (the one we want to dump into memory)
  Set CnnSrc = New ADODB.Connection
  CnnSrc.CursorLocation = adUseClient
  CnnSrc.Open "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & DBName
  
  'now the destination-Database (an InMemory-DB)
  Set Cnn = New_c.Connection
  Cnn.CreateNewDB 'without Params the new DB is created inside memory
  
    
  'now the loop for the table-dump
  Timing Start
  cmbTables.Clear
  
  Set RsSchema = CnnSrc.OpenSchema(adSchemaTables)
  Set TName = RsSchema.Fields("TABLE_NAME")
  Set TType = RsSchema.Fields("TABLE_TYPE")
  Do Until RsSchema.EOF
    If TType.Value = "TABLE" Then
      cmbTables.AddItem TName.Value
      
      'cleanup the previous Rs first
      If Not RsSrc Is Nothing Then
        If RsSrc.State = adStateOpen Then RsSrc.Close
      End If
      Set RsSrc = New ADODB.Recordset
      'select the new Src-Rs from our Filebased-DB-Connection
      RsSrc.Open "Select * from [" & TName.Value & "]", CnnSrc, adOpenStatic, adLockBatchOptimistic
      
      CreateTableFromADORs Cnn, TName.Value, RsSrc
    End If
    RsSchema.MoveNext
  Loop
  
  If cmbTables.ListCount Then cmbTables.Tag = "ex": cmbTables.ListIndex = 0

  lTiming.Caption = Timing & " for copying " & cmbTables.ListCount & _
                    " complete Tables into the InMemory-DB"
End Sub

Private Sub cmbTables_Click()
  If cmbTables.Tag = "ex" Then cmbTables.Tag = "": Exit Sub 'only a Fill-Event-Blocking
  
  'now let's work with the InMemory-DB and -Data from our tables
  Timing Start
    Set Rs = Cnn.OpenRecordset("Select * from [" & cmbTables.Text & "]")
    Set DG.DataSource = Rs.DataSource
  lTiming.Caption = Timing & " for " & Rs.RecordCount & " Records (" & Rs.Fields.Count & " Columns)"
End Sub

Private Sub Form_Resize()
On Error Resume Next
  fDG.Move 45, (lTiming.Top + lTiming.Height), ScaleWidth - 90, ScaleHeight - (lTiming.Top + lTiming.Height) - 45
  DG.Move 15, 240, fDG.Width - 45, fDG.Height - 255
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Set DG.DataSource = Nothing
  Set Rs = Nothing
  Set Cnn = Nothing
End Sub

Private Sub CreateTableFromADORs(CnnDst As cConnection, ByVal TableName As String, ADORs As Object)
Dim Rs As ADODB.Recordset, Fld As ADODB.Field, V, B() As Byte
Dim i As Long, SQLiteFTs() As FieldType, FDesc() As String, Cmd As cCommand

  Set Rs = ADORs 'first we do the cast
  If Rs Is Nothing Then Exit Sub
  If Rs.Fields.Count = 0 Then Exit Sub
  
  ReDim SQLiteFTs(Rs.Fields.Count - 1) 'redim the FieldType-Array
  ReDim FDesc(Rs.Fields.Count - 1) 'redim the Field-Description-Array
  
  If Left$(TableName, 1) <> "[" Then TableName = "[" & TableName & "]"
  
  'now scan for the Fieldnames and FieldTypes
  For i = 0 To Rs.Fields.Count - 1
    FDesc(i) = " [" & Rs.Fields(i).Name & "] " & _
               GetSQLiteFieldType(Rs.Fields(i).Type, SQLiteFTs(i))
  Next i
  
On Error GoTo RollBack
  CnnDst.BeginTrans
    'first we try to create the appropriate table on the SQLiteCnn
    CnnDst.Execute "Create Table " & TableName & " (" & Join$(FDesc, ",") & ")"
    
    'now the insert-loop
    If Rs.RecordCount Then
      For i = 0 To UBound(FDesc)
        FDesc(i) = "?" 'prepare InsertParam-PlaceHolders
      Next i
      
      Set Cmd = CnnDst.CreateCommand("Insert Into " & TableName & " Values(" & Join$(FDesc, ",") & ")")
      
      Rs.MoveFirst
      Do Until Rs.EOF
        For i = 0 To UBound(SQLiteFTs)
          With Rs.Fields(i)
            V = .Value
            If IsNull(V) Then
              Cmd.SetNull i + 1
            Else
              Select Case SQLiteFTs(i)
                Case SQLite_TEXT: Cmd.SetText i + 1, CStr(V)
                Case SQLite_INTEGER: Cmd.SetInt32 i + 1, V
                Case SQLite_DOUBLE: Cmd.SetDouble i + 1, V
                Case VB_Boolean_AutoConverted: Cmd.SetBoolean i + 1, V
                Case VB_DATE_AutoConverted: Cmd.SetDate i + 1, V
                Case VB_ShortDate_AutoConverted: Cmd.SetShortDate i + 1, V
                Case VB_Time_AutoConverted: Cmd.SetTime i + 1, V
                Case SQLite_BLOB: B = V: Cmd.SetBlob i + 1, B
              End Select
            End If
          End With
        Next i
        Cmd.Execute
        
        Rs.MoveNext
      Loop
    End If
  CnnDst.CommitTrans
Exit Sub
RollBack:
  CnnDst.RollbackTrans
End Sub

Private Function GetSQLiteFieldType(ByVal DataType As ADODB.DataTypeEnum, SQLiteFT As FieldType) As String
  Select Case DataType
    Case adBoolean
      GetSQLiteFieldType = "BIT": SQLiteFT = VB_Boolean_AutoConverted
    Case adInteger, adBigInt, adSmallInt, adTinyInt, adUnsignedBigInt, adUnsignedInt, adUnsignedSmallInt, adUnsignedTinyInt
      GetSQLiteFieldType = "INTEGER": SQLiteFT = SQLite_INTEGER
    Case adDate, adDBTimeStamp
      GetSQLiteFieldType = "DATE": SQLiteFT = VB_DATE_AutoConverted
    Case adDBDate
      GetSQLiteFieldType = "SHORTDATE": SQLiteFT = VB_ShortDate_AutoConverted
    Case adDBTime
      GetSQLiteFieldType = "TIME": SQLiteFT = VB_Time_AutoConverted
    Case adDouble, adSingle, adCurrency, adNumeric, adVarNumeric, adDecimal
      GetSQLiteFieldType = "REAL": SQLiteFT = SQLite_DOUBLE
    Case adBinary, adVarBinary, adLongVarBinary
      GetSQLiteFieldType = "BLOB": SQLiteFT = SQLite_BLOB
    Case Else 'adChar, adWChar, adVarChar, adVarWChar, adBSTR, adGUID
      GetSQLiteFieldType = "TEXT": SQLiteFT = SQLite_TEXT
  End Select
End Function
