VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cMyAggFunc"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Implements IAggregateFunction

Private MyCount As Long

'this is called for each member in the appropriate group
Private Sub IAggregateFunction_CallbackStep(ByVal ZeroBasedNameIndex As Long, ByVal ParamCount As Long, UDF As cUDFMethods)
  If ParamCount > 0 Then 'MyCount is used with a parameter (usually the Content of a Field-Definition or an expression)
    If UDF.GetType(1) = SQLite_NULL Then Exit Sub 'in our "Count-Implementation" we don't count Nulls
  End If
  MyCount = MyCount + 1 'increment the internal Private-Var
End Sub

'...and this is called, after the last member of a group was processed,
'to give you the chance, to reset internal variables and of course to tell
'the sqlite-engine the result of your aggregation-function
Private Sub IAggregateFunction_CallbackFinal(ByVal ZeroBasedNameIndex As Long, UDF As cUDFMethods)
  UDF.SetResultInt32 MyCount
  MyCount = 0 'reset the Counter-Private-Var to zero (for the next round)
End Sub

'here we implement only one aggregate-function, that's why the
'result of this implemented Property contains just the single
'entry 'MyCount'
Private Property Get IAggregateFunction_DefinedNames() As String
  IAggregateFunction_DefinedNames = "MyCount"
End Property
