VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cDimension"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'this class is used in the StarSchema-Demo (fStarSchema and fCube)
'and used for fast reverse-lookup from DimensionIDs to DimensionDetails
Option Explicit

Public DimensionTableName As String
Public FactsDimensionIDColumn As String
Public Entries As cCollection
Public IDFieldIsStringType As Boolean

Friend Sub Init(StarCnn As cConnection, DimensionTbl As cTable)
Dim Rs As cRecordset, SQL As String
Dim ColIDNameInBrackets As String, ColEntryNameInBrackets As String

  DimensionTableName = DimensionTbl.Name
  FactsDimensionIDColumn = DimensionTbl.Columns(1).Name 'we assume, the first Column in a Dimension-Table holds the ID
  ColIDNameInBrackets = DimensionTbl.Columns(1).NameInBrackets
  ColEntryNameInBrackets = DimensionTbl.Columns(2).NameInBrackets
  
  'let's reduce the DimensionValue-Entries to those, which are currently
  'contained in the Facts-Table
  SQL = "Select " & DimensionTableName & ".* From " & DimensionTableName & " Inner Join Facts On " & _
          DimensionTableName & "." & ColIDNameInBrackets & " = Facts." & ColIDNameInBrackets & _
          " Group By  Facts." & ColIDNameInBrackets & _
          " Order By " & DimensionTableName & "." & ColEntryNameInBrackets
  Set Rs = StarCnn.OpenRecordset(SQL)
  IDFieldIsStringType = Rs.Fields(0).ColumnType = SQLite_TEXT
  
  'and copy them over for fast Id->DimensionValue-Lookup into a cCollection (with the ID as Key)
  If IDFieldIsStringType Then
    Do Until Rs.EOF
      Entries.Add Rs.Fields(1).Value, CStr(Rs.Fields(0).Value)
      Rs.MoveNext
    Loop
  Else
    Do Until Rs.EOF
      Entries.Add Rs.Fields(1).Value, CDbl(Rs.Fields(0).Value)
      Rs.MoveNext
    Loop
  End If
End Sub

Private Sub Class_Initialize()
  Set Entries = New_c.Collection(False)
End Sub
