VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cConverter"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Event SchemaProgress(ByVal TableName As String, ByVal TablesCount As Long, ByVal TablesCreated As Long)
Event InsertProgress(ByVal TableName As String, ByVal RecordCount As Long, ByVal RecordsInserted As Long)
Event IndexProgress(ByVal TableName As String, ByVal IndexName As String, ByVal IndexesCount As Long, ByVal IndexesCreated As Long)

Private mAddNoCase As Boolean

Public Sub ConvertDatabase(Cnn As ADODB.Connection, sCnn As cConnection)
Dim i&, sRs As cRecordset
Dim RsTables As Recordset, RsColumns As Recordset, RsIDXs As Recordset, Rs As Recordset
Dim FName As ADODB.Field, PKColumn$, FldCount&
Dim TblCount&, RecCount&, Cols$(), ColsCounter&
  
  If Cnn Is Nothing Or sCnn Is Nothing Then Exit Sub
  
  Set Rs = New Recordset
  Set RsTables = Cnn.OpenSchema(adSchemaTables)
  Set RsColumns = Cnn.OpenSchema(adSchemaColumns)
  Set RsIDXs = Cnn.OpenSchema(adSchemaIndexes)
  
  RsTables.Filter = "TABLE_TYPE = 'TABLE'"
  Set FName = RsTables.Fields("TABLE_NAME")
  
  Do Until RsTables.EOF
    RsColumns.Filter = "TABLE_NAME = '" & FName.Value & "'"
    RsColumns.Sort = "ORDINAL_POSITION ASC"
    RsColumns.MoveFirst
    ReDim Cols(RsColumns.RecordCount - 1)
    ColsCounter = 0
    
    RsIDXs.Filter = "TABLE_NAME = '" & FName.Value & "' AND PRIMARY_KEY = True"
    If RsIDXs.RecordCount > 1 Then
      PKColumn = ", PRIMARY KEY ("
      Do Until RsIDXs.EOF
        PKColumn = PKColumn & " [" & RsIDXs("COLUMN_NAME") & "],"
        RsIDXs.MoveNext
      Loop
      PKColumn = Left$(PKColumn, Len(PKColumn) - 1) & ")"
    ElseIf RsIDXs.RecordCount = 1 Then
      PKColumn = RsIDXs("COLUMN_NAME")
    Else
      PKColumn = ""
    End If
    Do Until RsColumns.EOF
      
      PrepareCol Cols(ColsCounter), RsColumns("COLUMN_NAME").Value, _
                                    RsColumns("DATA_TYPE").Value, _
                                    RsColumns("CHARACTER_MAXIMUM_LENGTH").Value, _
                                    RsColumns("IS_NULLABLE").Value, _
                                    RsColumns("COLUMN_DEFAULT").Value, _
                                    PKColumn
      ColsCounter = ColsCounter + 1
      RsColumns.MoveNext
    Loop
    
    If RsIDXs.RecordCount = 1 Then PKColumn = "" 'already included in the appropriate Column-Constraint
    Cols(0) = Replace(Cols(0), "GenGUID()", "GenGUID")
    sCnn.Execute "Create Table [" & FName.Value & "] (" & Join(Cols, ", ") & PKColumn & ")"
    sCnn.DataBases(1).ReScanSchemaInfo
    TblCount = TblCount + 1
    RaiseEvent SchemaProgress(FName.Value, RsTables.RecordCount, TblCount)
    
    If Rs.State = adStateOpen Then Rs.Close
    Rs.Open "Select * from [" & FName.Value & "]", Cnn, adOpenStatic, adLockReadOnly
    Set sRs = sCnn.OpenRecordset("Select * from [" & FName.Value & "]")
    FldCount = Rs.Fields.Count - 1
    RecCount = 0
    Do Until Rs.EOF
      sRs.AddNew
      RecCount = RecCount + 1
      For i = 0 To FldCount
        sRs.Fields(i).Value = Rs.Fields(i).Value
      Next i
      Rs.MoveNext
      
      If RecCount Mod 200 = 0 Then
        sRs.UpdateBatch
        RaiseEvent InsertProgress(FName.Value, Rs.RecordCount, RecCount)
        If sRs.AbsolutePosition > 5000 Then 'we don't want to hold too much data in srs
          Set sRs = sCnn.OpenRecordset("Select * from [" & FName.Value & "] Where 0")
        End If
      End If
    Loop
    If sRs.RecordCount Then sRs.UpdateBatch
    RaiseEvent InsertProgress(FName.Value, Rs.RecordCount, RecCount)

    RsTables.MoveNext
  Loop
  On Error Resume Next
  RsTables.Close
  RsColumns.Close
  RsIDXs.Close
  Rs.Close
  Err.Clear
End Sub

Public Sub ConvertIndexes(Cnn As ADODB.Connection, sCnn As cConnection)
Dim SQL$, TblName$, IdxName$, Unique As Boolean
Dim RsIDXs As Recordset, IdxsCount&, Idx&

  If Cnn Is Nothing Or sCnn Is Nothing Then Exit Sub
  
  Set RsIDXs = Cnn.OpenSchema(adSchemaIndexes)
  RsIDXs.Filter = "(Primary_Key=0 AND Table_Name < 'MSys') " & _
               "OR (Primary_Key=0 AND Table_Name > 'MSysz')"
  RsIDXs.Sort = "Table_Name, Index_Name"
  
  Do Until RsIDXs.EOF
    If Len(IdxName) > 0 And IdxName <> RsIDXs("INDEX_NAME").Value Then
      IdxsCount = IdxsCount + 1
    End If
    IdxName = RsIDXs("INDEX_NAME").Value
    RsIDXs.MoveNext
  Loop
  IdxsCount = IdxsCount + 1
  
  IdxName = ""
  RsIDXs.MoveFirst
  TblName = RsIDXs("TABLE_NAME").Value
  SQL = "[" & RsIDXs("COLUMN_NAME").Value & "]"
  Do Until RsIDXs.EOF
    If Len(IdxName) > 0 And (IdxName <> RsIDXs("INDEX_NAME").Value Or TblName <> RsIDXs("TABLE_NAME").Value) Then
      sCnn.Execute "Create " & IIf(Unique, "UNIQUE", "") & " Index IF NOT EXISTS [idx_" & IdxName & "] ON [" & TblName & "] (" & SQL & ")"
      SQL = "[" & RsIDXs("COLUMN_NAME").Value & "]"
      Idx = Idx + 1
      RaiseEvent IndexProgress(TblName, IdxName, IdxsCount, Idx)
    ElseIf RsIDXs.AbsolutePosition > 1 Then
      SQL = SQL & ", [" & RsIDXs("COLUMN_NAME").Value & "]"
    End If
    TblName = RsIDXs("TABLE_NAME").Value
    IdxName = RsIDXs("INDEX_NAME").Value
    Unique = RsIDXs("Unique").Value
    RsIDXs.MoveNext
  Loop
  sCnn.Execute "Create " & IIf(Unique, "UNIQUE", "") & " Index IF NOT EXISTS [idx_" & IdxName & "] ON [" & TblName & "] (" & SQL & ")"
  Idx = Idx + 1
  RaiseEvent IndexProgress(TblName, IdxName, IdxsCount, Idx)
End Sub

Private Sub PrepareCol(S$, ByVal Name$, ByVal DataType As DataTypeEnum, ByVal CharLength, ByVal Nullable As Boolean, ByVal Default, PKColumn$)
Dim SType$, IsText As Boolean
  Select Case DataType
    Case adBoolean
      SType = "BIT"
    Case adInteger, adBigInt, adSmallInt, adTinyInt, adUnsignedBigInt, adUnsignedInt, adUnsignedSmallInt, adUnsignedTinyInt
      SType = "INTEGER"
    Case adDate, adDBTimeStamp
      SType = "DATE"
    Case adDBDate
      SType = "SHORTDATE"
    Case adDBTime
      SType = "TIME"
    Case adDouble, adSingle, adCurrency, adNumeric, adVarNumeric, adDecimal
      SType = "REAL"
    Case adBinary, adVarBinary, adLongVarBinary
      SType = "BLOB"
    Case Else 'adChar, adWChar, adVarChar, adVarWChar, adBSTR, adGUID
      IsText = True
      SType = "TEXT"
      If Not IsNull(CharLength) Then
        If Val(CharLength) > 0 Then
          SType = SType & "(" & CharLength & ")"
        End If
      End If
  End Select
  S = "[" & Name & "] " & SType
  
  If Name = PKColumn Then S = S & " PRIMARY KEY"
  If Not Nullable Then S = S & " NOT NULL"
  If Not IsNull(Default) Then
    If Left$(Default, 1) = "=" Then Default = Mid$(Default, 2) 'remove the '=', if there is any
    If Default = "" Then
      Default = "Null"
    Else
      If SType = "BIT" Then
        If LCase$(Default) = "false" Or LCase$(Default) = "no" Or Default = "0" Or LCase$(Default) = LCase$(CStr(False)) Then
          Default = "0"
        Else
          Default = "1"
        End If
      End If
    End If
    If IsNumeric(Default) Then Default = Replace(Default, ",", ".")
    S = S & " Default " & Default
  End If
  If mAddNoCase And IsText Then S = S & " Collate NoCase"
End Sub

Public Property Get CaseInSensitive_TextColumns() As Boolean
  CaseInSensitive_TextColumns = mAddNoCase
End Property
Public Property Let CaseInSensitive_TextColumns(ByVal NewValue As Boolean)
  mAddNoCase = NewValue
End Property



