VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cMyReport"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'This class acts as an example for a typical Report-Document-Type
'including Headers/Footers, a nice "Logo" + the usual Recordset-Content

Option Explicit

'some constants, wich define the keys for some reusable (during the lifetime of the Doc)
'GDI-Drawing-objects, wich we add in Class_Initialize here
Private Const DefaultFont$ = "DefaultFont"
Private Const ArrowFont$ = "ArrowFont"
Private Const HeaderFont$ = "HeaderFont"
Private Const SmallFont$ = "SmallFont"
Private Const BlackPen_01$ = "BlackPen_01"
Private Const BlackPen_04$ = "BlackPen_04"
Private Const WhiteBrush$ = "WhiteBrush"
Private Const YellowBrush$ = "YellowBrush"
Private Const HollowBrush$ = "HollowBrush"

Public Doc As cReportDocument

Private Sub Class_Initialize()
  Set Doc = New_c.ReportDocument
  
  'generate all the FontObjects we need on Point-Basis
  Doc.AddFont HeaderFont, "Times New Roman", 11, True, True
  Doc.AddFont DefaultFont, "Arial", 9
  Doc.AddFont ArrowFont, "Arial", 9, , , 45
  Doc.AddFont SmallFont, "Arial", 7
  
  'generate all the DrawingObjects we need on mm-Basis (wich is the Default-Scale)
  Doc.AddPen BlackPen_01, 0.1, vbBlack   '0.1mm PenWidth
  Doc.AddPen BlackPen_04, 0.4, vbBlack  '0.4mm PenWidth
  Doc.AddBrush WhiteBrush, vbWhite
  Doc.AddBrush YellowBrush, vbYellow
  Doc.AddBrush HollowBrush
  'All those GDI-Objects are automatically cleaned up, if the Document-Object dies
End Sub

Public Sub GenerateContent(Rs As Recordset, Optional ByVal FirstPageLandscape As Boolean)
Dim FirstPage As cReportPage
  
  Set FirstPage = Doc.AddPage 'add our "opener-page" to the document

  'now we initialize the page and draw some "MasterPage"-Content
  InitPage FirstPage, FirstPageLandscape '<- just to show, that we can mix LandScape-Pages into the report-document

  'and here we go with our Drawing-Routines, wich begin with the first page,
  'but then there are automatically new pages added if the length of the
  'content makes this necessary
  DrawPages FirstPage, Rs
End Sub

'this routine initializes to either Landscape or normal Page-Orientation
'and it also acts like a Masterpage - here occurs the rendering of the
'default Objects (Logo + some Header/Footer-Content)
Private Sub InitPage(Page As cReportPage, Optional ByVal bLandScape As Boolean) 'here we init and draw our Defaults
  With Page
    .InitDrawMode bLandScape

    'draw our "Logo"
    .SelectHandle BlackPen_01
    .DrawRectangle .PageWidth - 7.5 - 25, 7.5, 25, 25, 3, 3
    .DrawImage LoadPicture(App.Path & "\TestLogo.bmp"), .PageWidth - 10 - 20, 10, 20, 20, True
    
    'draw some Header-Text
    .SelectHandle SmallFont
    .TextOut 7.5, 7.5, "Report-Creation-Date: " & Now
    
    'and draw some Footer-Text
    .TextOutBaseLine .PageWidth - 7.5, .PageHeight - 7.5, "Page " & .PageNumber, vbRightJustify
  End With
End Sub

Private Sub DrawPages(Page As cReportPage, Rs As Recordset)
Dim S As String, DTWidth As Double, DTHeight As Double, i&
'Only Some Tests regarding the autocorrection-capabilities
'of the engine, if something is rendered into the nonprintable
'areas of a printer
'  Page.SelectHandle BlackPen_01
'  Page.DrawRectangle 0, 0, 10, 10
'
'  Page.SelectHandle BlackPen_04
'  Page.DrawRectangle Page.PageWidth - 10, Page.PageHeight - 10, 10, 10
'Exit Sub

  'Now we draw some "Demo-Objects", to show what's possible...
  'We enter this routine with the first Page-object and that is, where
  'the following Demo-Graphics are created on
  '---------------------Begin of Demo-Objects-Rendering-------------------------
  'the yellow circle
  Page.SelectHandle YellowBrush
  Page.SelectHandle BlackPen_01
  Page.DrawEllipse 50, 50, 110, 110
  
  'the 45 Arrow and below the Arrow the appropriate rotated Text
  Page.DrawArrowLine 25, 25 + 160, 25 + 160, 25, 0, 4
  Page.SelectHandle ArrowFont, vbBlack
  Page.TextOut 25 + 160 - 5, 25 + 5, "Rotated Text ArrowFont, angle: 45", vbRightJustify

  'the TopLeft Rectangle
  Page.SelectHandle WhiteBrush
  Page.SelectHandle BlackPen_04
  Page.DrawRectangle 25, 25, 80, 80, 10, 10

    'HeaderFont-Test with a DrawText-Extent-Calculation
    Page.SelectHandle HeaderFont, vbBlue
    S = "Test for HeaderFont (Times 11Pt, Bold, Italic) this text should be word- wrapped"
    DTWidth = 44

    DTHeight = Page.CalcDrawTextRows(DTWidth, S) * Page.TextHeight
    Page.DrawText 30, 30, DTWidth, DTHeight, S, False, 0

    Page.SelectHandle BlackPen_01
    For i = 0 To 18
      Page.DrawArrowLine 30.5 + i * 2, 33 + DTHeight + 0.05, 32 + i * 2, 30 + DTHeight + 0.05, 0, 1
    Next i

    Page.SelectHandle SmallFont, vbBlack
    Page.TextOut 30, 33.5 + DTHeight, "DrawText-Height ends exactly here!"
    
  'the BottomRight Rectangle
  Page.SelectHandle BlackPen_04
  Page.DrawRectangle 105, 105, 80, 80, 10, 10
    'Test for DefaultFont (including a Path-Effect Demonstration)
    Page.SelectHandle DefaultFont, vbBlack
    Page.BeginPath
      Page.TextOut 110, 110, "Test for DefaultFont (Arial 9Pt) Single-Line"
    Page.EndPath
    Page.SelectClipPath RGN_COPY
    Page.DrawGradient vbBlue, vbRed, 110, 110, 65, 4
    Page.ResetClipPath

    'inside this Rectangle some Rounded-Corner-Effects (useful for nice OrgCharts)
    Page.SelectHandle HollowBrush
    'the "Apple"
    Page.DrawArrowLine 127, 146.5, 134, 138, 6, 0
    Page.DrawGradient vbYellow, &H33FF66, 110, 145, 37, 35, 27, 35, False
    Page.DrawRectangle 110, 145, 37, 35, 27, 35
    Page.DrawRectangle 127, 180, 2.5, 0.5, 1, 0.5
    'the OrgChart-Box
    Page.DrawGradient &HA0FFFF, &H40FFB0, 134, 120, 46, 18, 5, 5, True
    Page.DrawRectangle 134, 120, 46, 18, 5, 5
    Page.DrawText 137, 125, 40, 12, "Rounded-Corner-Gradients for nice looking OrgCharts", , 1
    
  'and a small Center-Rectangle in the middle of the "Demo-Construct"
  Page.SelectHandle BlackPen_01
  Page.SelectHandle HollowBrush
  Page.DrawRectangle 103.8, 103.8, 2.4, 2.4
    '--------------------End of Demo-Objects-Rendering---------------------
  
  'Now the "real stuff" ;-)
  'if the Rs-Content doesn't fit on the remaining Page-Space,
  'then new pages are automatically added to the Document
  'It tries to begin with this first page-Object - and in
  'case the first page is not landscape, there are already some
  'Records rendered on this first page (following the Demo-
  'Graphics).
  DrawRsContent Page, Rs
End Sub

Private Sub DrawRsContent(Page As cReportPage, Rs As Recordset)
Dim YStart#, XStart#, RowHeight#, RenderedRecords&
  If Rs Is Nothing Then Exit Sub
  
  'Draw the RsContent
  XStart = 25 'Left Border-Offset
  YStart = 210 'Top-Offset on the first Page (we have content above)
  Rs.MoveFirst

  RenderRsHeader Page, Rs, XStart, YStart
  Do
    RenderRsRecords Page, Rs, XStart, YStart, RenderedRecords
    If Rs.EOF Then Exit Do

    'if not yet at the last record, then create a new page and repeat
    Set Page = Doc.AddPage
    InitPage Page 'init and set the "Master-Page-Defaults"
    XStart = 25 'Left Border-Offset
    YStart = 35 'Top-Offset on our just created new page
    RenderRsHeader Page, Rs, XStart, YStart
  Loop
End Sub

Private Sub RenderRsHeader(Page As cReportPage, Rs As Recordset, XStart#, YStart#)
Dim i&, RowHeight#, BottomBorder#
  RowHeight = 4.5
  BottomBorder = Page.PageHeight - (XStart - RowHeight - 5)
  If (YStart + RowHeight > BottomBorder) Then Exit Sub
  
  Page.SelectHandle DefaultFont, vbBlack
  YStart = YStart + 5 'spare some space for a comment-line above the header
  
  'Draw the Header
  Page.SelectHandle BlackPen_01
  Page.SelectHandle HollowBrush
  
  For i = 0 To Rs.Fields.Count - 1
    Page.DrawGradient &HE8E8E8, &HC8C8C8, XStart + i * 40, YStart, 40, RowHeight, , , True
    Page.DrawCell XStart + i * 40, YStart, 40, RowHeight, Rs.Fields(i).Name, True, IIf(i = 1, 0, 2), 0.5
  Next i
  YStart = YStart + RowHeight
End Sub

Private Sub RenderRsRecords(Page As cReportPage, Rs As Recordset, XStart#, YStart#, RenderedRecords&)
Dim RowHeight#, BottomBorder#, RecordStart&, CommentY#
  RowHeight = 4
  BottomBorder = Page.PageHeight - (XStart - RowHeight)
  Page.SelectHandle BlackPen_01
  Page.SelectHandle SmallFont, vbBlack
  
  RecordStart = RenderedRecords
  CommentY = YStart - 9.5
  Do Until Rs.EOF Or (YStart + RowHeight > BottomBorder)
    'render the current record as an appropriate table-row
    If Rs.BOF Then Rs.MoveFirst
    Page.DrawCell XStart, YStart, 40, RowHeight, Rs!ID.Value, True, vbRightJustify, 0.7
    Page.DrawCell XStart + 40, YStart, 40, RowHeight, Rs!ProductName.Value, True, vbLeftJustify, 0.7
    Page.DrawCell XStart + 80, YStart, 40, RowHeight, Format$(Rs!Price.Value, "$ 0.00"), True, vbRightJustify, 0.7
    Page.DrawCell XStart + 120, YStart, 40, RowHeight, Rs!AvailablePieces.Value, True, vbRightJustify, 0.7
    YStart = YStart + RowHeight
    RenderedRecords = RenderedRecords + 1
    Rs.MoveNext
  Loop
  If RenderedRecords > RecordStart Then
    Page.SelectHandle DefaultFont, vbBlack
    Page.TextOut XStart, CommentY, "Records " & RecordStart + 1 & "-" & RenderedRecords & _
                                   " of " & Rs.RecordCount & " total Records"
  End If
End Sub
