VERSION 5.00
Begin VB.Form fRPCServer 
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "RPC-Server-Controller"
   ClientHeight    =   6765
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   7920
   Icon            =   "fRPCServer.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   451
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   528
   StartUpPosition =   3  'Windows-Standard
   Begin VB.PictureBox pSysTray 
      BackColor       =   &H0080C0FF&
      BorderStyle     =   0  'Kein
      Height          =   330
      Left            =   7020
      ScaleHeight     =   22
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   25
      TabIndex        =   22
      Top             =   3150
      Visible         =   0   'False
      Width           =   375
   End
   Begin VB.CommandButton cmdKeyPair 
      Caption         =   "Create new   Key-Pair..."
      Height          =   555
      Left            =   6105
      TabIndex        =   21
      Top             =   2385
      Width           =   1710
   End
   Begin VB.CommandButton cmdSHA1 
      Caption         =   "SHA1-Hexvalue for   RPCServerAdmin..."
      Height          =   600
      Left            =   6105
      TabIndex        =   20
      Top             =   1530
      Width           =   1710
   End
   Begin VB.Frame frStatus 
      Caption         =   "Status-Informations"
      Height          =   6495
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   5910
      Begin VB.VScrollBar VScroll1 
         Enabled         =   0   'False
         Height          =   270
         Left            =   5130
         Max             =   64
         Min             =   1
         TabIndex        =   4
         TabStop         =   0   'False
         Top             =   1290
         Value           =   60
         Width           =   315
      End
      Begin VB.TextBox tClientConnects 
         Height          =   3840
         Left            =   150
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertikal
         TabIndex        =   3
         TabStop         =   0   'False
         Top             =   2475
         Width           =   5580
      End
      Begin VB.Label Label1 
         Caption         =   "Connected Clients:"
         Height          =   240
         Left            =   135
         TabIndex        =   19
         Top             =   2250
         Width           =   1395
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   3
         Left            =   1935
         TabIndex        =   18
         Top             =   1305
         Width           =   330
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   6
         Left            =   1530
         TabIndex        =   17
         Top             =   2250
         Width           =   555
      End
      Begin VB.Label Label4 
         Caption         =   "Current ThreadPool-Size:"
         Height          =   240
         Left            =   135
         TabIndex        =   16
         Top             =   1305
         Width           =   1815
      End
      Begin VB.Label lblPoolSize 
         Alignment       =   1  'Rechts
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fest Einfach
         Height          =   255
         Left            =   4725
         TabIndex        =   15
         Top             =   1290
         Width           =   375
      End
      Begin VB.Label Label6 
         Caption         =   "---->    Change ThreadPoolSize to:"
         Height          =   240
         Left            =   2250
         TabIndex        =   14
         Top             =   1305
         Width           =   2505
      End
      Begin VB.Label Label7 
         Caption         =   "Current JobQueue-Size:"
         Height          =   240
         Left            =   135
         TabIndex        =   13
         Top             =   1530
         Width           =   1755
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   4
         Left            =   1890
         TabIndex        =   12
         Top             =   1530
         Width           =   435
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   0
         Left            =   135
         TabIndex        =   11
         Top             =   360
         Width           =   5730
      End
      Begin VB.Label Label10 
         Caption         =   "Responses/Sec:"
         Height          =   240
         Left            =   135
         TabIndex        =   10
         Top             =   1755
         Width           =   1275
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   5
         Left            =   1440
         TabIndex        =   9
         Top             =   1755
         Width           =   570
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   1
         Left            =   1485
         TabIndex        =   8
         Top             =   585
         Width           =   4380
      End
      Begin VB.Label lblState 
         Height          =   240
         Index           =   2
         Left            =   765
         TabIndex        =   7
         Top             =   810
         Width           =   5100
      End
      Begin VB.Label Label2 
         Caption         =   "Server listens on:"
         Height          =   240
         Left            =   135
         TabIndex        =   6
         Top             =   585
         Width           =   1320
      End
      Begin VB.Label Label3 
         Caption         =   "UpTime:"
         Height          =   240
         Left            =   135
         TabIndex        =   5
         Top             =   810
         Width           =   690
      End
   End
   Begin VB.CheckBox chkService 
      Caption         =   "Install as Service"
      Height          =   330
      Left            =   6120
      TabIndex        =   1
      Top             =   990
      Width           =   1635
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start/Stop Server"
      Height          =   570
      Left            =   6105
      Style           =   1  'Grafisch
      TabIndex        =   0
      Top             =   225
      Width           =   1710
   End
   Begin VB.Timer tmrCheck 
      Enabled         =   0   'False
      Interval        =   50
      Left            =   6390
      Top             =   3090
   End
End
Attribute VB_Name = "fRPCServer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const WM_LBUTTONDOWN& = &H201     'Button down
Private Const WM_LBUTTONUP& = &H202       'Button up
Private Const WM_LBUTTONDBLCLK& = &H203   'Double-click
Private Const WM_RBUTTONDOWN& = &H204     'Button down
Private Const WM_RBUTTONUP& = &H205       'Button up
Private Const WM_RBUTTONDBLCLK& = &H206   'Double-click

Private Declare Function OpenEventA Lib "kernel32" (ByVal dwDesiredAccess As Long, ByVal bInheritHandle As Long, ByVal lpName As String) As Long
Private Declare Function CreateEventA Lib "kernel32" (ByVal lpEventAttributes As Long, ByVal bManualReset As Long, ByVal bInitialState As Long, ByVal lpName As String) As Long
Private Declare Function SetEvent Lib "kernel32" (ByVal hEvent As Long) As Long
Private Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long

Private Const StopNormalName$ = "dhRPCService_StopPending"

Private ServState As SERVICE_STATE, Installed As Boolean, hStopNormalEvent&
Private Host$, Port&, ThreadPoolSize&, ForceAuthentication As Boolean, AllowedGroup$, AdminPassword$
Private WithEvents Cnn As cRPCConnection, SysTray As CSysTrayIcon, PopupMsg&
Attribute Cnn.VB_VarHelpID = -1

Private Sub cmdInstall_Click()

End Sub

Private Sub Form_Load()
  On Error Resume Next
  
  'let's read the current Ini-Values (this Control-Application and dhRPCService.exe share the same Ini-File)
  New_c.RPCListener.ReadIniValues Host, Port, ThreadPoolSize, ForceAuthentication, AllowedGroup, AdminPassword
  
  'now let's instantiate the
  Set Cnn = New_c.RPCConnection
  If Cnn Is Nothing Then
    MsgBox "Couldn't instantiate RPC-Connection-Object"
    tmrCheck.Tag = "x"
    If Err Then Err.Clear
    Unload Me
    Exit Sub
  End If
  
  Installed = (GetServiceConfig() = 0) 'check, if we run as service
  If Installed Then chkService.Tag = "NoAction": chkService.Value = 1
  
  'now we prepare for our first connect
  Cnn.Host = Host
  Cnn.Port = Port
  Cnn.KeepAlive = True
  Cnn.ServerAuthentication = True
  Cnn.UserName = "RPCServerAdmin" 'retrieving Server-Status-Infos needs an Admin-Login
  Cnn.PassWord = AdminPassword
  Cnn.Connect 0.5
  tmrCheck.Enabled = True
  
  CheckService

  Set SysTray = New CSysTrayIcon
  SysTray.AddIcon pSysTray.hwnd, Me.Icon.Handle, "dhRPCServer-Controller"

  Err.Clear
End Sub

Private Sub Form_Resize()
  If Tag = "M" Then Tag = "": Exit Sub
  If WindowState = vbMinimized And Tag = "" Then Tag = "M": Hide
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
  On Error Resume Next
    If UnloadMode = vbFormControlMenu Then Cancel = True: Hide: Exit Sub
    If tmrCheck.Tag = "" Then Me.Hide: tmrCheck.Tag = "Unload Me": Cancel = True: Cnn.Cancel
  Err.Clear
End Sub

Private Sub Form_Unload(Cancel As Integer)
  tmrCheck.Enabled = False
End Sub

Private Sub chkService_Click()
  CheckService
  If chkService.Tag = "NoAction" Then chkService.Tag = "": Exit Sub
  If chkService.Value = 1 Then
    If Not Installed Then
      StopUserProcess
      SetNTService
    End If
  Else
    If Installed Then
      StopNTService
      DeleteNTService
    End If
  End If
  CheckService
End Sub

Private Sub StopUserProcess()
  hStopNormalEvent = OpenEventA(2, 0, StopNormalName)
  If hStopNormalEvent Then
    SetEvent hStopNormalEvent
    CloseHandle hStopNormalEvent
  End If
End Sub

Private Sub ClearStatusInfos()
Dim i&
  lblState(0).Caption = "Process '" & Service_File_Name & "' is not running!"
  For i = 1 To 6
    lblState(i).Caption = ""
  Next i
  tClientConnects.Text = ""
End Sub

Private Sub cmdKeyPair_Click()
  If MsgBox("This will overwrite the existing Key-Pair inside your Server-Path!" & vbCrLf & _
            "Continue?", vbYesNo Or vbQuestion, "Create new Key-Pair") = vbYes Then
    If Cnn.CreateNewKeyPair = False Then
      MsgBox "Couldn't create the new Key-Files"
    End If
  End If
End Sub

Private Sub cmdSHA1_Click()
Dim OldIniPW$
  OldIniPW = AdminPassword
  fSHA1Dialog.ShowWith AdminPassword
  If OldIniPW <> AdminPassword Then
    Cnn.PassWord = AdminPassword
    If Cnn.IsConnected Then MsgBox "You must restart the server for changes to take effect!"
  End If
End Sub

Private Sub pSysTray_MouseMove(Button As Integer, Shift As Integer, x As Single, Y As Single)
  If Y <> 0 Then Exit Sub
  If x <> 512 Then PopupMsg = x
  If Cnn.IsConnected And Not Cnn.WaitingForRPCResult Then
    ShowTrayPopup
  End If
End Sub
Private Sub ShowTrayPopup()
Dim Msg&
  Msg = PopupMsg: PopupMsg = 0
  Select Case Msg
    Case WM_RBUTTONUP
      Select Case SysTray.PopupMenu(Me.hwnd, "*Show RPCController", "Hide", "-", "Exit RPCController")
        Case 1: WindowState = 0: Show
        Case 2: Hide
        Case 4: Unload Me
      End Select  ' popUpMenu
    Case WM_LBUTTONUP
      WindowState = 0: Show
  End Select
End Sub

Private Sub VScroll1_Change()
  ThreadPoolSize = VScroll1.Max - VScroll1.Value + VScroll1.Min
  lblPoolSize.Caption = ThreadPoolSize
End Sub


'check service status
Private Sub CheckService()
  If GetServiceConfig() = 0 Then
    Installed = True
    ServState = GetServiceStatus()
  Else
    Installed = False
  End If
End Sub

Private Sub cmdStart_Click()
  CheckService
  cmdStart.Enabled = False
  If InStr(cmdStart.Caption, "Stop") Then
    If Installed Then 'servicemode detected
      StopNTService
    Else
      StopUserProcess
    End If
  Else
    If Installed Then 'servicemode detected
      StartNTService
    Else
      Shell App.Path & "\" & Service_File_Name & " AsUserProcess"
    End If
  End If
  CheckService
End Sub

Private Sub tmrCheck_Timer()
Dim sCaption$
Static cc&
  
  tmrCheck.Enabled = False
  If tmrCheck.Tag = "Unload Me" Then Unload Me: Exit Sub
  On Error Resume Next
  If PopupMsg Then ShowTrayPopup
  cc = (cc + 1) Mod 10
  If cc = 0 Then
    CheckService
    cmdStart.Enabled = True
    If Cnn.IsConnected Then
      UpdateStatus Cnn.GetServerStatus(True, ThreadPoolSize)
      'If PopupMsg Then ShowTrayPopup
      If cmdStart.BackColor <> &H80FF80 Then cmdStart.BackColor = &H80FF80
      If Installed Then
        sCaption = "      Stop Service       (green if running)"
      Else
        sCaption = "  Stop User-Process  (green if running)"
      End If
      VScroll1.Enabled = True
    Else
      lblState(6).Caption = ""
      Cnn.Connect 0.5
      'If PopupMsg Then ShowTrayPopup
      If cmdStart.BackColor <> &H8000000F Then cmdStart.BackColor = &H8000000F
      If Not Cnn.IsConnected Then
        If Installed Then
          sCaption = "      Start Service      (green if running)"
        Else
          sCaption = "  Start User-Process  (green if running)"
        End If
      End If
      ClearStatusInfos
      VScroll1.Enabled = False
    End If
    If sCaption <> cmdStart.Caption Then cmdStart.Caption = sCaption
  End If
  'If Err Then Debug.Print Err.Description: Err.Clear
  
  tmrCheck.Enabled = True
End Sub

Private Sub UpdateStatus(Status As cRPCStatusInfo)
Dim i&, CInfo As cRPCClientInfo, SArr$(), ClCount&, Responses&
  If lblPoolSize.Caption = "" Then VScroll1.Value = VScroll1.Max - Status.CurrentThreadPoolSize + VScroll1.Min
  lblState(0).Caption = "Server is running with Account: " & Status.ServerAccount
  lblState(1).Caption = Status.ServerIPAndPort
  lblState(2).Caption = Status.UpTime
  lblState(3).Caption = Status.CurrentThreadPoolSize
  lblState(4).Caption = Status.JobCount
  Responses = Status.ResponsesPerSecond - 2
  If Responses < 0 Then Responses = 0
  lblState(5).Caption = Responses
  ClCount = Status.ClientInfoCount - 1
  If ClCount < 0 Then ClCount = 0
  lblState(6).Caption = ClCount
  
  If Status.ClientInfoCount = 0 Then tClientConnects.Text = "": Exit Sub
  
  ReDim SArr(Status.ClientInfoCount - 1)
  For Each CInfo In Status.ClientInfos
    SArr(i) = CInfo.IPAndPort & " " & CInfo.Status
    i = i + 1
  Next CInfo
  tClientConnects.Text = Join(SArr, vbCrLf)
End Sub


