VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CSysTrayIcon"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'this is not my code, but I don't remember where I found
'it and who the author was - feel free to inform me, so
'that I can give credits to whom they belong ...
Option Explicit

Private Const NIM_ADD = &H0
Private Const NIM_MODIFY = &H1
Private Const NIM_DELETE = &H2
Private Const NIF_MESSAGE = &H1
Private Const NIF_ICON = &H2
Private Const NIF_TIP = &H4

Private Const MIIM_STATE As Long = &H1
Private Const MIIM_ID As Long = &H2
Private Const MIIM_SUBMENU As Long = &H4
Private Const MIIM_CHECKMARKS As Long = &H8
Private Const MIIM_TYPE As Long = &H10
Private Const MIIM_DATA As Long = &H20

Private Const MFT_STRING As Long = &H0
Private Const MFT_RADIOCHECK As Long = &H200
Private Const MFT_SEPARATOR = &H800&
Private Const MFS_DEFAULT = &H1000
Private Const MFS_ENABLED = &H0&
Private Const MFS_DISABLED = &H3&

Private Const TPM_RIGHTBUTTON = &H2&
Private Const TPM_LEFTALIGN = &H0&
Private Const TPM_NONOTIFY = &H80&
Private Const TPM_RETURNCMD = &H100&

Private Type POINT
  x As Long
  Y As Long
End Type

Private Type MENUITEMINFO
  cbSize As Long
  fMask As Long
  fType As Long
  fState As Long
  wID As Long
  hSubMenu As Long
  hbmpChecked As Long
  hbmpUnchecked As Long
  dwItemData As Long
  dwTypeData As String
  cch As Long
End Type

' Used as the ID of the call back message
Private Const WM_MOUSEMOVE& = &H200

Private Declare Function CreatePopupMenu Lib "user32" () As Long
Private Declare Function InsertMenuItem Lib "user32" Alias "InsertMenuItemA" (ByVal hMenu As Long, ByVal un As Long, ByVal bool As Boolean, ByRef lpcMenuItemInfo As MENUITEMINFO) As Long
Private Declare Function TrackPopupMenu Lib "user32" (ByVal hMenu As Long, ByVal wFlags As Long, ByVal x As Long, ByVal Y As Long, ByVal nReserved As Long, ByVal hwnd As Long, nIgnored As Long) As Long
Private Declare Function DestroyMenu Lib "user32" (ByVal hMenu As Long) As Long
Private Declare Function Shell_NotifyIcon Lib "shell32" Alias "Shell_NotifyIconA" (ByVal dwMessage As Long, pnid As NOTIFYICONDATA) As Boolean
Private Declare Function GetCursorPos Lib "user32" (lpPoint As POINT) As Long
Private Declare Function SetForegroundWindow Lib "user32" (ByVal hwnd As Long) As Long
      
' Used by Shell_NotifyIcon
Private Type NOTIFYICONDATA
    cbSize As Long
    hwnd As Long
    uId As Long
    uFlags As Long
    uCallBackMessage As Long
    hIcon As Long
    szTip As String * 256
End Type

Private TrayIcon As NOTIFYICONDATA
Private Activated As Boolean

Private Sub Class_Terminate()
  DeleteIcon
End Sub

Public Sub setTrayIcon(hIcon As Long)
  If Not Activated Then Exit Sub
  TrayIcon.hIcon = hIcon
  Call Shell_NotifyIcon(NIM_MODIFY, TrayIcon)
End Sub

Public Sub setTrayToolTip(p_tooltip As String)
Dim szToolTip As String, ret&
  If Not Activated Then Exit Sub
  If Len(p_tooltip) >= 255 Then
      szToolTip = Left(p_tooltip, 255) & Chr(0) ' trim to 64 characters
  Else
      szToolTip = p_tooltip & Chr(0)
  End If

  TrayIcon.szTip = szToolTip
  Call Shell_NotifyIcon(NIM_MODIFY, TrayIcon)
End Sub

Public Sub AddIcon(p_form_hwnd&, p_icon&, p_tooltip$)
Dim szToolTip As String
  If Len(p_tooltip) >= 255 Then
      szToolTip = Left(p_tooltip, 255) & Chr(0) ' trim to 64 characters
  Else
      szToolTip = p_tooltip & Chr(0)
  End If
  TrayIcon.cbSize = Len(TrayIcon)
  TrayIcon.hwnd = p_form_hwnd
  TrayIcon.hIcon = p_icon
  ' ID code of the icon
  TrayIcon.uId = vbNull
  ' Flags
  TrayIcon.uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE
  ' ID of the call back message
  TrayIcon.uCallBackMessage = WM_MOUSEMOVE
  ' The icon
  TrayIcon.hIcon = p_icon
  ' The Tooltip for the icon
  TrayIcon.szTip = szToolTip
  ' Windows API to Add icon to the tray
  Call Shell_NotifyIcon(NIM_ADD, TrayIcon)
  Activated = True
End Sub

Public Sub DeleteIcon()
  ' Windows API to delete icon from the tray
  Call Shell_NotifyIcon(NIM_DELETE, TrayIcon)
  Activated = False
End Sub

Private Function BuildMenu&(sCaption)
Dim hMenu&, iMenu&, uMII As MENUITEMINFO, iOffset&
Dim SubCaptions, Subs$
  hMenu = CreatePopupMenu()
  With uMII
    .cbSize = Len(uMII)
    .fMask = MIIM_ID Or MIIM_TYPE Or MIIM_STATE Or MIIM_SUBMENU Or MIIM_CHECKMARKS
    .wID = 0
    .hSubMenu = 0
    .hbmpChecked = 0
    .hbmpUnchecked = 0
    .dwItemData = 0
  End With

  iOffset = 1 - LBound(sCaption)
  For iMenu = LBound(sCaption) To UBound(sCaption)
    uMII.wID = iMenu + iOffset
    uMII.hSubMenu = 0
    uMII.fType = MFT_STRING
    uMII.fState = MFS_ENABLED
    
    If Left(sCaption(iMenu), 1) = "#" Then
      sCaption(iMenu) = Right(sCaption(iMenu), Len(sCaption(iMenu)) - 1)
      Subs = Mid(sCaption(iMenu), InStr(sCaption(iMenu), vbTab) + 1)
      SubCaptions = Split(Subs, vbTab)
      uMII.hSubMenu = BuildMenu(SubCaptions)
      sCaption(iMenu) = Left(sCaption(iMenu), InStr(1, sCaption(iMenu), vbTab) - 1)
    ElseIf Left(sCaption(iMenu), 1) = "!" Then
      sCaption(iMenu) = Right(sCaption(iMenu), Len(sCaption(iMenu)) - 1)
      uMII.fType = MFT_RADIOCHECK
    ElseIf Left(sCaption(iMenu), 1) = "*" Then
      sCaption(iMenu) = Right(sCaption(iMenu), Len(sCaption(iMenu)) - 1)
      uMII.fState = MFS_DEFAULT
    ElseIf Left(sCaption(iMenu), 1) = "~" Then
      sCaption(iMenu) = Right(sCaption(iMenu), Len(sCaption(iMenu)) - 1)
      uMII.fState = MFS_DISABLED
    ElseIf Trim$("" & sCaption(iMenu)) = "-" Then
      'seperator
      uMII.fType = MFT_SEPARATOR
    End If
    
    'text caption
    uMII.dwTypeData = "" & sCaption(iMenu)
    uMII.cch = Len("" & sCaption(iMenu))

    Call InsertMenuItem(hMenu, iMenu + iOffset, False, uMII)
  Next iMenu
  BuildMenu = hMenu
End Function

Public Function PopupMenu(ByVal hOwner As Long, ParamArray sCaption() As Variant) As Long
  Dim uCursor As POINT
  Dim hMenu As Long
  Dim cCaption()
  If (UBound(sCaption) - LBound(sCaption) + 1) <= 0 Then
    PopupMenu = 0 'cancel

  Else
    'get the cursor position
    GetCursorPos uCursor

    'create an populate the popup menu
    cCaption = sCaption
    hMenu = BuildMenu(cCaption)

    SetForegroundWindow hOwner
    PopupMenu = TrackPopupMenu(hMenu, TPM_NONOTIFY Or TPM_RETURNCMD Or TPM_RIGHTBUTTON Or TPM_LEFTALIGN, uCursor.x, uCursor.Y, 0, hOwner, 0)

    'done with the menu
    DestroyMenu hMenu
  End If
End Function
