Attribute VB_Name = "RPCService"
'This module wraps the cRPCListener-Class from dhRichClient.dll,
'which does all the "hard work" regarding answering RPC-Requests
'over the Dll-builtin-Threadpool, which is able to call Public
'Class-Methods from Dlls, which you place inside the Bin-Subfolder:
'\RPCDlls   -  and that without any need, to register them at the
'serverside.
'There's also a smaller "Listener-Hosting"-Example available in this package,
'which you will find inside the Folder \Src_RPCServer
'But this Service, combined with the separate Controller-App described
'below, is of course the more professional approach, which offers
'more options for a serious RPCServer-Hosting on a dedicated machine.
'
'As you see, this Service-Exe-Project doesn't contain any Userinterface -
'hence, the communication with this service is done over an appropriate
'Service-Controller-Application, which you find in: \Src_RPCServiceControllerApp
Option Explicit

'Private Declare Function GETINSTANCE Lib "DirectCom" (FName As String, ClassName As String) As Object
'Private Declare Function dhRF Lib "dhRichClient" () As cFactory

Public Type OSVERSIONINFO
  dwOSVersionInfoSize As Long
  dwMajorVersion As Long
  dwMinorVersion As Long
  dwBuildNumber As Long
  dwPlatformId As Long
  szCSDVersion(1 To 128) As Byte
End Type

Private Const Service_Name = "dhRPCService"
Private Const StopNormalName$ = "dhRPCService_StopPending"
Private Const INFINITE& = -1&
Private Const WAIT_TIMEOUT& = 258&
Private Const VER_PLATFORM_WIN32_NT = 2&

Private Declare Function MsgWaitForMultipleObjects Lib "user32" (ByVal nCount As Long, pHandles As Long, ByVal fWaitAll As Long, ByVal dwMilliseconds As Long, ByVal dwWakeMask As Long) As Long
Private Declare Function GetTickCount Lib "kernel32" () As Long
Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" (lpVersionInformation As OSVERSIONINFO) As Long
Private Declare Sub RtlMoveMemory Lib "kernel32" (Dst As Any, Src As Any, ByVal bc&)
Private Declare Function OpenSCManager Lib "advapi32" Alias "OpenSCManagerW" (ByVal lpMachineName As Long, ByVal lpDatabaseName As Long, ByVal dwDesiredAccess As Long) As Long
Private Declare Function OpenService Lib "advapi32" Alias "OpenServiceW" (ByVal hSCManager As Long, ByVal lpServiceName As Long, ByVal dwDesiredAccess As Long) As Long   '** Change Service_Name as needed
Private Declare Function CloseServiceHandle Lib "advapi32" (ByVal hSCObject As Long) As Long
Private Declare Function CreateEventA Lib "kernel32" (ByVal lpEventAttributes As Long, ByVal bManualReset As Long, ByVal bInitialState As Long, ByVal lpName As String) As Long

Private Declare Function SetTimer& Lib "user32" (ByVal hWnd&, ByVal nID&, ByVal el&, ByVal TProc&)
Private Declare Function KillTimer& Lib "user32" (ByVal hWnd&, ByVal nID&)

Private Server As cRPCListener, Path$, hStopNormalEvent As Long
Private UDP As cUDP, BrIPBytes(3) As Byte, TIDUDP As Long 'timerID for our BroadCastTimer

Private Sub Main()
Dim ThreadHdl As Long, H(0 To 1) As Long, IsNTService As Boolean, S As String
  
  If App.PrevInstance Then Exit Sub
  Path = App.Path: If Right$(Path, 1) <> "\" Then Path = Path & "\"
    
  If IsServiceInstalled Then
    If Command = "AsUserProcess" Then Exit Sub
    
    hStartEvent = CreateEventW(0&, 1&, 0&, 0&)
    hStopPendingEvent = CreateEventW(0, 1, 0, 0&)
    hStopEvent = CreateEventW(0&, 1&, 0&, 0&)
    ServiceNamePtr = StrPtr(Service_Name)
    
    ThreadHdl = StartAsService() 'create ServiceControl-Thread
    H(0) = ThreadHdl: H(1) = hStartEvent
    ' Waiting for one of two events: sucsessful service start (1) or
    ' terminaton of service thread (0)
    IsNTService = (MsgWaitObj(INFINITE, H(0), 2&) = 1&)

    If Not IsNTService Then
      CloseHandle ThreadHdl
      LogEvent "Cannot initialize Service-Thread!", EVENTLOG_ERROR
    Else 'enter the Service-Loop
      If Init Then  'initialize RPC-Server

        SetServiceState SERVICE_RUNNING
        LogEvent Service_Name & " started!", EVENTLOG_INFORMATION
        
        Do: Loop While MsgWaitObj(10&, hStopPendingEvent, 1&) = WAIT_TIMEOUT
        Set Server = Nothing
        
        SetServiceState SERVICE_STOPPED
        LogEvent Service_Name & " stopped!", EVENTLOG_INFORMATION
      Else
        SetServiceState SERVICE_STOPPED
      End If
      
      SetEvent hStopEvent 'signalize the Service-Thread its termination
      MsgWaitObj INFINITE, ThreadHdl, 1& 'wait on the ThreadHdl until Svc-Control-Thread terminates
      CloseHandle ThreadHdl
      If hStartEvent Then CloseHandle hStartEvent
      If hStopPendingEvent Then CloseHandle hStopPendingEvent
      If hStopEvent Then CloseHandle hStopEvent
    End If
  Else 'start as "normal" User-Process
    hStopNormalEvent = CreateEventA(0, 0, 0, StopNormalName)
    If hStopNormalEvent = 0 Then LogEvent "Cannot create Stop-Event in User-Process!", EVENTLOG_ERROR: Exit Sub
    If Init Then  'initialize RPC-Server

      Do: Loop While MsgWaitObj(10&, hStopNormalEvent, 1&) = WAIT_TIMEOUT
      Set Server = Nothing
      
    End If
    If hStopNormalEvent Then CloseHandle hStopNormalEvent
  End If
  
  EndBroadCasting
End Sub

Private Function Init() As Boolean
Dim Host$, Port&, ThreadPoolSize&, ForceAuthentication As Boolean, AllowedGroup$, AdminPassWord$
  On Error Resume Next
  Set Server = New_c.RPCListener
  
  If Server Is Nothing Then
    Err.Clear
    LogEvent "Cannot instantiate dhRPC-ListenerClass!", EVENTLOG_ERROR
    Exit Function
  End If
  
  Server.ReadIniValues Host, Port, ThreadPoolSize, ForceAuthentication, AllowedGroup, AdminPassWord
 
  If Not Server.StartServer(Host, Port, ThreadPoolSize, ForceAuthentication, AdminPassWord, AllowedGroup) Then
    LogEvent "Cannot start the dhRPC-Listener!", EVENTLOG_ERROR
    Exit Function
  End If
  
  'comment that out, if you don't want the current IP of that machine broadcasted
  StartBroadCasting 1000, Host, Port

  Init = True
End Function

Private Function CheckIsNT() As Boolean
Dim OSVer As OSVERSIONINFO
  OSVer.dwOSVersionInfoSize = LenB(OSVer)
  GetVersionEx OSVer
  CheckIsNT = OSVer.dwPlatformId = VER_PLATFORM_WIN32_NT
End Function

Private Function MsgWaitObj(ByVal Interval As Long, Optional hObj As Long, Optional ByVal nObj As Long) As Long
Dim T1 As Currency, T2 As Currency, OriginalInterval As Currency
  T1 = 0: RtlMoveMemory T1, GetTickCount(), 4: T1 = T1 * 10000 'retrieve Ticks up to 4294967295
  OriginalInterval = Interval 'store the original Interval
  Do
    MsgWaitObj = MsgWaitForMultipleObjects(nObj, hObj, 0&, Interval, 255)    'returns on all Win-Messages
    If MsgWaitObj <> nObj Then Exit Do 'It was one of the Hdls or the MsgWait-TimeOut, so we leave
    
    DoEvents 'It was a Win-Msg, so we process Events and stay inside the loop

    T2 = 0: RtlMoveMemory T2, GetTickCount(), 4: T2 = T2 * 10000
    If T2 < T1 Then T2 = T2 + 4294967296@ 'check for GetTickCount-Overflow and correct T2
    Interval = OriginalInterval - (T2 - T1) 'calculate the remaining Wait-Interval
    If Interval < 0 Then MsgWaitObj = WAIT_TIMEOUT: Exit Do 'TimeOut expired, so we leave
  Loop
End Function

Public Function IsServiceInstalled() As Boolean
Dim hSCManager As Long, hService As Long
  On Error Resume Next
  hSCManager = OpenSCManager(0&, 0&, 1)  'SC_MANAGER_CONNECT
  If hSCManager Then
    hService = OpenService(hSCManager, StrPtr(Service_Name), 1) 'SERVICE_QUERY_CONFIG
    If hService Then
      CloseServiceHandle hService
      IsServiceInstalled = True
    End If
    CloseServiceHandle hSCManager
  End If
  Err.Clear
End Function

'####### here comes the new part, which is there for UDP-Broadcasting of the ServerIP
Private Sub StartBroadCasting(ByVal Interval As Long, ByVal Host As String, ByVal Port As Long)
Dim i&, IP As String, IPParts() As String
  EndBroadCasting
  
  On Error Resume Next
    Set UDP = New_c.UDP
    
    IP = UDP.GetIP(Host) 'get the current Host-ip of this machine
    IPParts = Split(IP, ".")
    For i = 0 To UBound(IPParts)
      BrIPBytes(i) = IPParts(i) 'prepare the ByteArray, which we use in the timer-proc for send
    Next i
    
    IPParts(3) = 255 'overwrite last part for broadcast
    UDP.RemoteIP = Join(IPParts, ".")
    UDP.RemotePort = Port
  If Err Then
    Err.Clear
    Set UDP = Nothing
    LogEvent "Cannot init UDP-IP-Broadcasting!", EVENTLOG_ERROR
  End If
  
  TIDUDP = SetTimer(0, 0, Interval, AddressOf TimerProc)
End Sub

Private Sub TimerProc(ByVal hWnd As Long, ByVal uMsg As Long, ByVal idEvent As Long, ByVal lngSysTime As Long)
  If Not UDP Is Nothing Then UDP.SendData VarPtr(BrIPBytes(0)), 4
End Sub

Private Sub EndBroadCasting()
  If TIDUDP = 0 Then Exit Sub
  KillTimer 0, TIDUDP
  TIDUDP = 0
  Set UDP = Nothing
End Sub
