Attribute VB_Name = "NTServiceHelper"
'This is a code-module from Sergey Merzlikins great
'NTService-examples, which I only somewhat "ripped off"
'because I don't needed all the functionality.
'The Service.RES, which contains the Service-Icon -
'and also the VB-friendly Typelib steams from his download,
'which you find here: http://www.smsoft.ru/en/ntservice.htm
Option Explicit

Private Declare Function RegisterEventSource Lib "advapi32.dll" Alias "RegisterEventSourceA" (ByVal lpUNCServerName As String, ByVal lpSourceName As String) As Long
Private Declare Function DeregisterEventSource Lib "advapi32.dll" (ByVal hEventLog As Long) As Long
Private Declare Function ReportEvent Lib "advapi32.dll" Alias "ReportEventW" (ByVal hEventLog As Long, ByVal wType As Integer, ByVal wCategory As Integer, ByVal dwEventID As Long, ByVal lpUserSid As Any, ByVal wNumStrings As Integer, ByVal dwDataSize As Long, plpStrings As Any, lpRawData As Any) As Boolean
Private Declare Function RegOpenKey Lib "advapi32.dll" Alias "RegOpenKeyA" (ByVal hKey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Private Declare Function RegCreateKey Lib "advapi32.dll" Alias "RegCreateKeyA" (ByVal hKey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Private Declare Function RegSetValueEx Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpData As Any, ByVal cbData As Long) As Long
Private Const HKLM& = &H80000002
Public Enum LogTypes
  EVENTLOG_ERROR = 1
  EVENTLOG_WARNING = 2
  EVENTLOG_INFORMATION = 4
End Enum

Private Declare Function CreateThread Lib "kernel32" (ByVal lpThreadAttributes As Long, ByVal dwStackSize As Long, ByVal lpStartAddress As Long, ByVal lpParameter As Long, ByVal dwCreationFlags As Long, lpThreadId As Long) As Long
Private Const INFINITE& = -1&

Private ServiceStatus As SERVICE_STATUS, hServiceStatus As Long

Public ServiceNamePtr As Long, hStopEvent As Long, hStartEvent As Long, hStopPendingEvent As Long

' The FncPtr function returns function pointer.
Function FncPtr(ByVal fnp As Long) As Long
  FncPtr = fnp
End Function

' The StartAsService function creates Service Dispatcher thread.
Public Function StartAsService() As Long
Dim ThreadID As Long
  StartAsService = CreateThread(0&, 0&, AddressOf ServiceThread, 0&, 0&, ThreadID)
End Function

' The ServiceThread sub starts the service.
' This sub returns control only after service termination.
Private Sub ServiceThread(ByVal dummy As Long)
Dim ServiceTableEntry As SERVICE_TABLE
  ServiceTableEntry.lpServiceName = ServiceNamePtr
  ServiceTableEntry.lpServiceProc = FncPtr(AddressOf ServiceMain)
  StartServiceCtrlDispatcherW ServiceTableEntry
End Sub

' The ServiceMain sub - main service sub.
' It initializes service,
' sets event hStartEvent, and waits hStopEvent event.
' When hStopEvent fires, this sub exits and service stops.
Private Sub ServiceMain(ByVal dwArgc As Long, ByVal lpszArgv As Long)
  ServiceStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS
  ServiceStatus.dwControlsAccepted = SERVICE_ACCEPT_STOP Or SERVICE_ACCEPT_SHUTDOWN
  ServiceStatus.dwWin32ExitCode = 0&
  ServiceStatus.dwServiceSpecificExitCode = 0&
  ServiceStatus.dwCheckPoint = 0&
  ServiceStatus.dwWaitHint = 0&
  hServiceStatus = RegisterServiceCtrlHandlerW(ServiceNamePtr, AddressOf Handler)
  SetServiceState SERVICE_START_PENDING
  
  SetEvent hStartEvent 'Set hStartEvent. It unlocks the waiting main-application
  WaitForSingleObject hStopEvent, INFINITE ' Wait until hStopEvent fires
End Sub
   
' The Handler sub processes commands from Service Dispatcher.
' It sets event hStopEvent when processes command
' SERVICE_CONTROL_STOP or SERVICE_CONTROL_SHUTDOWN.
Private Sub Handler(ByVal fdwControl As Long)
  Select Case fdwControl
    Case SERVICE_CONTROL_SHUTDOWN, SERVICE_CONTROL_STOP
      SetServiceState SERVICE_STOP_PENDING
      SetEvent hStopPendingEvent
    Case Else
      SetServiceState
  End Select
End Sub

' The SetServiceState sub changes service state.
' If parameter omitted, it confirms previous state.
Public Sub SetServiceState(Optional ByVal NewState As SERVICE_STATE = 0&)
  If NewState <> 0& Then ServiceStatus.dwCurrentState = NewState
  SetServiceStatus hServiceStatus, ServiceStatus
End Sub

Public Sub LogEvent(ByVal EvtString As String, LogType As LogTypes)
Dim hEventLog As Long, RegKey As String, EvtDll As String, hK&
  hEventLog = RegisterEventSource(vbNullString, App.Title)
  If hEventLog = 0 Then Exit Sub
  RegKey = "System\CurrentControlSet\Services\Eventlog\Application\" & App.Title
  EvtDll = "%SystemRoot%\System32\msvbvm60.dll"
  If RegOpenKey(HKLM, RegKey, hK) Then  'if not yet existent
    If RegCreateKey(HKLM, RegKey, hK) Then Exit Sub
    RegSetValueEx hK, "EventMessageFile", 0, 1, ByVal EvtDll, Len(EvtDll)
    RegSetValueEx hK, "TypesSupported", 0, 4, 4&, 4
    RegCloseKey hK
  Else
    RegCloseKey hK
  End If
  EvtString = Split(",Error:,Warning:,,Information:", ",")(LogType) _
              & vbCrLf & vbCrLf & EvtString
  ReportEvent hEventLog, LogType, 0, 1, 0&, 1, 0, StrPtr(EvtString), 0&
  DeregisterEventSource hEventLog
End Sub

