VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cTestMethods"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const SingletonKey As String = "SingletonTestKey"
Private SingletonThread As cThreadHandler

'Param-Reflection (to demonstrate a simple call and
'to determine the "RoundTrip-Overhead" - respective
'the Maximum "Requests-Per-Second" using our Demo-App-RPCLoop
'(in this case with very small Strings).
'The String-Len is doubled inside, to show with a second
'Reflect-Function-Call (behind the 'Reflect-Large-String'-Button)
'the maximum Transport-Capacity and -Time of one single RPC.
'The Max-Size for a serialized Request is 2,000,000 Bytes.
'We transport Strings as UniCode, so sending a String with a
'Len of 1,000,000 fills our Sendbuffer to its limit (ok, we've
'set the real limit a few 100 Bytes higher, because of some
'Serializing-Overhead, but so you have a bit of space left for
'some smaller parameters in the call.
'The Server-Response can be twice as large - here we have a
'4,000,000 Bytes limit, so that a String with a Len of 2,000,000
'or a Byte-Array with 4,000,000 Bytes can be transported.
'These Values have to do with predefined Socket-Buffers
'(Performance-Reasons). If compression is switched on (highly
'recommended, if working with large Content like Recordsets,
'XML-Strings, etc.), then you have good chances, that even
'(much) larger content fits into our limit, but that of course
'depends on the compressibility of your Data.
Public Function Reflect(S As String) As String
  Reflect = S & S
End Function

'this call is blocking the Worker-Thread inside the ThreadPool
'of our RPC-Server (used to demonstrate the RPC-TimeOut-Handling
'and the robustness of the server-side Worker-ThreadPool)
Public Sub BlockingLoop(ByVal DurationInSeconds As Long)
Dim StartDate As Date
  StartDate = Now
  Do
  Loop Until DateDiff("s", StartDate, Now) > DurationInSeconds
End Sub

'simple call, to demonstrate the Transport of unhandled Errors
'from inside a Method over the Server to the Client
Public Sub ErrorCall1()
Dim Dummy As Double
  Dummy = 1 / 0
End Sub

'simple call, to demonstrate, how to achieve correct Error-Transport
'in case of handled Errors using 'On Error Goto'-Semantics
Public Sub ErrorCall2()
Dim Dummy As Double
  On Error GoTo ErrHandler
  Dummy = 1 / 0
Exit Sub

ErrHandler: 'Standard-ErrHandler-Marker
  Err.Raise vbObjectError, , "Your own 1/0-Error-Message"
End Sub

'same as above (like ErrorCall2), but using
'On Error Resume Next'-Semantics
Public Sub ErrorCall3()
Dim Dummy As Double
  On Error Resume Next
  Dummy = 1 / 0
  
  If Err Then
    'handle the error directly after the statement
    If Err = 11 Then 'Divide by Zero Error - we cancel here:
      'don't Err.Clear and the received Error is bubbling up
      'or Raise your own Error without special preparation (as shown in the line below)
      'Err.Raise vbObjectError, , "Your own 1/0-Error-Message"
      Exit Sub
    Else 'some error we can live with
      '...
      Err.Clear 'go further with cleared Err-Object
    End If
  End If
  '...do further processing eventually...
End Sub

'Array-Returning of a Byte-Array
Public Function ReturnByteArray(ByVal P1 As Byte, ByVal P2 As Byte) As Byte()
Dim Arr() As Byte
  ReDim Arr(0 To 1)
  Arr(0) = P1: Arr(1) = P2
  ReturnByteArray = Arr
End Function

'ByRef-Params are not recommended in DCOM-Scenarios, but we can
'use them without Performance-Loss (recommended also for Strings
'or ByteArrays with large Content - anyway, the "Variant-Rule"
'stays the same: Don't use them, if you can avoid them (stronger
'Typing helps to avoid failures - and our Serializer performes
'better on NonVariant-Types). The slowest Type in serializing is
'the "pure" Variant-Array (this thing, that only contains other
'Variants a the Index-Positions - a Variant containing a ByteArray
'is Ok - but then you can also use the ByteArray-Type directly,
'regarding stronger typing - see the Method 'ByRefArrayTypes' below)
Public Sub ByRefSimpleTypes(C As Currency, D As Date, B As Boolean)
  C = 98765.4321 'incoming with 12345.6789
  D = CDbl(D) + 1 'one day later
  B = True
End Sub

'ByRef-Arrays are recommended, to transport large Content
'(look at the ByRef-Comments above)
'Our server-side Serializer detects every change inside a ByRef-
'Array - so we can effectively avoid unnecessary backtransport
'over the wire for array-content, that remains unchanged inside
'the Server-Methods.
Public Sub ByRefArrayTypes(B() As Byte, S() As String, V())
Dim LB As Long, UB As Long, i As Long
  On Error Resume Next
  LB = LBound(B): UB = UBound(B)
  If Err Then Exit Sub 'no Err.Clear - so the Error bubbles up
  
  For i = LB To UB 'changes inside are reflected...
    If B(i) + 10 <= 255 Then B(i) = B(i) + 10
  Next i
  '...but one can also overwrite with a new array...
  S = Split("x,y,z", ",")
  '...or completely Redim and change Dimensions
  '(deomonstrates nested Variants also)
  'but remember - avoid Variants, especially large Variant-Arrays
  'if possible (they have the slowest Serialization-Performance)!
  ReDim V(5, 5, 5, 1)
  V(5, 5, 5, 1) = Array(1, 2, Array("another text"))
End Sub

'ByRef-Recordset-Example:
'Of course you can also give serializable Objects back as
'the Result of a Function (see StdPicture-DemoCall below)
'Typically a "GetRecordset-Function" would look like:
'Public Function(ConnString$, SQL$) as Recordset
'  ...Do your ADO-Stuff there (Cnn.Open, Rs.Open, etc.)
'End Function
'Here we simply want to demonstrate, that the Rs-Transport-
'Mechanism works well - and of course the "Change-Detection" of
'serialized Objects is equal to ByRef-Arrays regarding
'unnecessary backtransports (see above) - if you dont change
'the Object, then there's no need to send it back to the client.
'The Cnn-Object at the client-side always holds the original
'Param and if the RPC-Server-Part doesn't report any changes
'for a given Param-Position, the Cnn-Object simply passes the
'original Param back to the Caller. But here we change the
'internal Content of Rs, and so changes go back to the Client.
Public Sub AddOneHundredRecordsTo(Rs As Recordset)
Dim i As Long, C As Long
  C = Rs.RecordCount 'get the actual Recordcount
  For i = 1 To 100
    Rs.AddNew
    Rs!SomeInteger = C + i: Rs!SomeString = "String" & (C + i)
  Next i
  Rs.UpdateBatch
End Sub

'Shows, that Object-Transport also works per Function-Result.
Public Function GetFirstBitmapIn(SomeServerFolder As String) As StdPicture
Dim FName As String
  On Error Resume Next
  If Right$(SomeServerFolder, 1) <> "\" Then SomeServerFolder = SomeServerFolder & "\"
  FName = Dir(SomeServerFolder & "*.bmp")
  If FName = "" Then Err.Raise vbObjectError, , "No Bmp found": Exit Function
  Set GetFirstBitmapIn = LoadPicture(SomeServerFolder & FName)
End Function

'Demonstrates Singleton-Access:
Public Sub SingletonAddEntry(ByVal ThreadCollection As Collection, ByVal Key As String, ByVal StringData As String)
  EnsureAndConnectToSingleton ThreadCollection
  
  SingletonThread.CallSynchronous "AddEntry", Key, StringData
End Sub

Public Function SingletonGetEntry(ByVal ThreadCollection As Collection, ByVal Key As String) As String
  EnsureAndConnectToSingleton ThreadCollection
  
  SingletonGetEntry = SingletonThread.CallSynchronous("GetEntry", Key)
End Function

Public Function SingletonGetCollectionCount(ByVal ThreadCollection As Collection) As Long
  EnsureAndConnectToSingleton ThreadCollection
  
  SingletonGetCollectionCount = SingletonThread.CallSynchronous("GetCollectionCount")
End Function

Private Sub EnsureAndConnectToSingleton(ThreadCollection As Collection)
Dim dhF As cFactory
  If SingletonThread Is Nothing Then
    Set dhF = ThreadCollection("dh_Factory")
    Set SingletonThread = dhF.regfree.ThreadObjectConnect(SingletonKey)
  ElseIf Not SingletonThread.IsConnected Then
    SingletonThread.ReConnect
  End If
End Sub

