VERSION 5.00
Begin VB.Form fRPCDemo 
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "datenhaus RPC-Demo-Client"
   ClientHeight    =   8055
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   9045
   Icon            =   "RPCDemoClient.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   8055
   ScaleWidth      =   9045
   StartUpPosition =   3  'Windows-Standard
   Begin VB.Frame frSingletons 
      BackColor       =   &H00C0FFFF&
      Caption         =   "Server-Singletons"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4500
      Left            =   6495
      TabIndex        =   43
      Top             =   3420
      Width           =   2415
      Begin VB.CommandButton bGetCollectionItem 
         BackColor       =   &H00C0FFFF&
         Caption         =   "Get the last Collection-Entry"
         Height          =   300
         Left            =   135
         Style           =   1  'Grafisch
         TabIndex        =   49
         Top             =   1950
         Width           =   2145
      End
      Begin VB.CommandButton bGetCollectionCount 
         BackColor       =   &H00C0FFFF&
         Caption         =   "Get the Collection-Count"
         Height          =   300
         Left            =   135
         Style           =   1  'Grafisch
         TabIndex        =   48
         Top             =   1650
         Width           =   2145
      End
      Begin VB.CommandButton bAddToCollection 
         BackColor       =   &H00C0FFFF&
         Caption         =   "Add a Collection-Entry"
         Height          =   300
         Left            =   135
         Style           =   1  'Grafisch
         TabIndex        =   47
         Top             =   1320
         Width           =   2145
      End
      Begin VB.CommandButton bCloseSingleton 
         BackColor       =   &H00C0FFFF&
         Caption         =   "Close the Internal-Singleton"
         Height          =   375
         Left            =   150
         Style           =   1  'Grafisch
         TabIndex        =   45
         Top             =   2550
         Width           =   2145
      End
      Begin VB.CommandButton bEnsureSingleton 
         BackColor       =   &H00C0FFFF&
         Caption         =   "Ensure a Internal-Singleton (not reachable from outside the RPCServer)"
         Height          =   675
         Left            =   135
         Style           =   1  'Grafisch
         TabIndex        =   44
         Top             =   270
         Width           =   2145
      End
   End
   Begin VB.Frame frDemoCalls 
      Caption         =   "Simple Demo-Calls"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1035
      Left            =   135
      TabIndex        =   12
      Top             =   6885
      Width           =   6210
      Begin VB.CommandButton bRecordsetCall 
         Caption         =   "ObjCall (Recordset.Add)"
         Height          =   315
         Left            =   2940
         TabIndex        =   29
         Top             =   600
         Width           =   1875
      End
      Begin VB.CommandButton bStdPictureCall 
         Caption         =   "ObjCall (StdPicture)  -->"
         Height          =   315
         Left            =   2940
         TabIndex        =   28
         Top             =   240
         Width           =   1875
      End
      Begin VB.CommandButton bByRefParams 
         Caption         =   "ByRef-Params"
         Height          =   315
         Left            =   120
         TabIndex        =   16
         Top             =   240
         Width           =   1155
      End
      Begin VB.CommandButton bLargeString 
         Caption         =   "Reflect Large String"
         Height          =   315
         Left            =   1320
         TabIndex        =   15
         Top             =   600
         Width           =   1575
      End
      Begin VB.CommandButton bByRefArrays 
         Caption         =   "ByRef-Arrays"
         Height          =   315
         Left            =   120
         TabIndex        =   14
         Top             =   600
         Width           =   1155
      End
      Begin VB.CommandButton bByteArray 
         Caption         =   "ByteArray-Returning"
         Height          =   315
         Left            =   1320
         TabIndex        =   13
         Top             =   240
         Width           =   1575
      End
      Begin VB.Image imgStdPictureRequest 
         BorderStyle     =   1  'Fest Einfach
         Height          =   675
         Left            =   4860
         Top             =   240
         Width           =   1215
      End
   End
   Begin VB.Frame frErrors 
      Caption         =   "Server-Stability and Error-Bubbling"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1275
      Left            =   135
      TabIndex        =   10
      Top             =   5445
      Width           =   6210
      Begin VB.CommandButton bErrorCall3 
         Caption         =   "ErrorCall3"
         Height          =   435
         Left            =   5220
         TabIndex        =   20
         Top             =   720
         Width           =   855
      End
      Begin VB.CommandButton bErrorCall2 
         Caption         =   "ErrorCall2"
         Height          =   435
         Left            =   5220
         TabIndex        =   19
         Top             =   240
         Width           =   855
      End
      Begin VB.CommandButton bErrorLoop 
         Caption         =   $"RPCDemoClient.frx":058A
         Height          =   915
         Left            =   120
         TabIndex        =   18
         Top             =   240
         Width           =   3615
      End
      Begin VB.CommandButton bErrorCall1 
         Caption         =   "ErrorCall1 - a simple unhandled Error in the Servermethod"
         Height          =   915
         Left            =   3780
         TabIndex        =   17
         Top             =   240
         Width           =   1395
      End
      Begin VB.Label lErrInfo 
         Alignment       =   2  'Zentriert
         Height          =   675
         Left            =   3780
         TabIndex        =   21
         Top             =   240
         Width           =   1395
         WordWrap        =   -1  'True
      End
   End
   Begin VB.Frame frStressTest 
      Caption         =   "Server-Stressing and Performance-Test"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1875
      Left            =   135
      TabIndex        =   8
      Top             =   3420
      Width           =   6210
      Begin VB.Frame frStressLoop 
         Height          =   1110
         Left            =   120
         TabIndex        =   22
         Top             =   660
         Width           =   5955
         Begin VB.CommandButton bSingleReflect 
            Caption         =   "Single Reflect-Call"
            Height          =   285
            Left            =   4170
            TabIndex        =   46
            Top             =   180
            Width           =   1665
         End
         Begin VB.CheckBox cEnterLoop 
            Caption         =   "RPCStressing-Loop     -->   Req/sec = "
            Height          =   255
            Left            =   120
            TabIndex        =   24
            Top             =   180
            Width           =   3075
         End
         Begin VB.TextBox tReflect 
            Height          =   315
            Left            =   120
            TabIndex        =   23
            Text            =   "Text1"
            Top             =   480
            Width           =   1335
         End
         Begin VB.Label lStressing 
            Caption         =   "Reflects to     -->     Result and RoundTrip-Time for a single call"
            Height          =   195
            Left            =   120
            TabIndex        =   27
            Top             =   840
            Width           =   4575
         End
         Begin VB.Label lReqPerSec 
            BorderStyle     =   1  'Fest Einfach
            Caption         =   "0"
            Height          =   255
            Left            =   3240
            TabIndex        =   26
            Top             =   180
            Width           =   495
         End
         Begin VB.Label lResults 
            BorderStyle     =   1  'Fest Einfach
            Height          =   315
            Left            =   1500
            TabIndex        =   25
            Top             =   480
            Width           =   4335
         End
      End
      Begin VB.CommandButton bLoop4 
         Caption         =   "Forces a 4s-Blocking-Loop at the ServerSide (TimeOut is 5s, so it goes through)"
         Height          =   315
         Left            =   120
         TabIndex        =   9
         Top             =   300
         Width           =   5955
      End
   End
   Begin VB.Frame frConnection 
      Caption         =   "Connection-Settings and Error-Log"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3075
      Left            =   135
      TabIndex        =   0
      Top             =   180
      Width           =   8775
      Begin VB.CheckBox cEncryption 
         Caption         =   "Encryption"
         Height          =   195
         Left            =   945
         TabIndex        =   42
         Top             =   780
         Width           =   1230
      End
      Begin VB.CheckBox cAuth 
         Caption         =   "ServerAuthentication"
         Height          =   240
         Left            =   4095
         TabIndex        =   38
         Top             =   270
         Width           =   1965
      End
      Begin VB.TextBox tPassWord 
         Height          =   300
         IMEMode         =   3  'DISABLE
         Left            =   4095
         PasswordChar    =   "*"
         TabIndex        =   37
         Top             =   1260
         Width           =   1770
      End
      Begin VB.TextBox tDomainName 
         Height          =   300
         Left            =   4095
         TabIndex        =   36
         Top             =   900
         Width           =   1770
      End
      Begin VB.TextBox tUserName 
         Height          =   300
         Left            =   4095
         TabIndex        =   35
         Top             =   540
         Width           =   1755
      End
      Begin VB.CommandButton bCancelRequest 
         BackColor       =   &H0080C0FF&
         Cancel          =   -1  'True
         Caption         =   "Cancel Request"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   705
         Left            =   135
         Style           =   1  'Grafisch
         TabIndex        =   34
         Top             =   270
         Width           =   705
      End
      Begin VB.ListBox lstErrorLog 
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H000000C0&
         Height          =   1230
         Left            =   120
         TabIndex        =   11
         Top             =   1680
         Width           =   8520
      End
      Begin VB.CheckBox cKeepAlive 
         Caption         =   "KeepAlive"
         Height          =   255
         Left            =   945
         TabIndex        =   5
         Top             =   270
         Value           =   1  'Aktiviert
         Width           =   1215
      End
      Begin VB.CheckBox cCompression 
         Caption         =   "Compression"
         Height          =   195
         Left            =   945
         TabIndex        =   4
         Top             =   540
         Width           =   1695
      End
      Begin VB.CommandButton bConnect 
         Caption         =   "               Connect                 (green if connected)"
         Default         =   -1  'True
         Height          =   555
         Left            =   6525
         Style           =   1  'Grafisch
         TabIndex        =   3
         Top             =   270
         Width           =   2115
      End
      Begin VB.TextBox tHost 
         Height          =   300
         Left            =   6540
         TabIndex        =   2
         Top             =   900
         Width           =   2100
      End
      Begin VB.TextBox tPort 
         Height          =   300
         Left            =   6540
         TabIndex        =   1
         Text            =   "22222"
         Top             =   1260
         Width           =   615
      End
      Begin VB.Label Label3 
         Alignment       =   1  'Rechts
         Caption         =   "PassWord"
         Height          =   240
         Left            =   3195
         TabIndex        =   41
         Top             =   1305
         Width           =   825
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Rechts
         Caption         =   "Domain"
         Height          =   240
         Left            =   3465
         TabIndex        =   40
         Top             =   945
         Width           =   555
      End
      Begin VB.Label Label1 
         Alignment       =   1  'Rechts
         Caption         =   "User"
         Height          =   240
         Left            =   3465
         TabIndex        =   39
         Top             =   585
         Width           =   555
      End
      Begin VB.Label lSendOut 
         BorderStyle     =   1  'Fest Einfach
         ForeColor       =   &H00008080&
         Height          =   255
         Left            =   945
         TabIndex        =   33
         Top             =   1035
         Width           =   2115
      End
      Begin VB.Label lSend 
         Caption         =   "Bytes sent:"
         ForeColor       =   &H00008080&
         Height          =   195
         Left            =   120
         TabIndex        =   32
         Top             =   1080
         Width           =   795
      End
      Begin VB.Label lRecvOut 
         BorderStyle     =   1  'Fest Einfach
         ForeColor       =   &H00800000&
         Height          =   255
         Left            =   945
         TabIndex        =   30
         Top             =   1305
         Width           =   2115
      End
      Begin VB.Label lRecv 
         Caption         =   "Bytes rcvd:"
         ForeColor       =   &H00C00000&
         Height          =   195
         Left            =   120
         TabIndex        =   31
         Top             =   1320
         Width           =   870
      End
      Begin VB.Label lHost 
         Caption         =   "Host:"
         Height          =   255
         Left            =   6120
         TabIndex        =   7
         Top             =   945
         Width           =   405
      End
      Begin VB.Label lPort 
         Caption         =   "Port:"
         Height          =   195
         Left            =   6165
         TabIndex        =   6
         Top             =   1305
         Width           =   435
      End
   End
   Begin VB.Timer tmLoopDecoupling 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   360
      Top             =   0
   End
   Begin VB.Timer tmRequestCounter 
      Interval        =   500
      Left            =   -60
      Top             =   0
   End
End
Attribute VB_Name = "fRPCDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Author: Olaf Schmidt (datenhaus GmbH, Berlin)
'E-Mail: os@datenhaus.de
'--------------------------------------------------------------------
'RPC-Client-Demo - shows, how to work with the client-side RPC-Helper
'cRPCConnection', sitting in 'dhRichClient3.Dll' enabling easy to
'implement RPC-Calls against the serverside of dhRPC, which is
'also implemented inside dhRichClient3.Dll.

'!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
'Please make sure, that you've started an RPCServer,
'before using this Demo-Client (RPCServer.exe, located
'in the Bin-Folder of this Demo-Directory-Structure)
'!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

'--------------------------------------------------------------------
'You can freely use the Code inside this Demo-Client in your own Apps
'and also all Binaries (ServerTest.dll) which come with this example.
Option Explicit

Private Const SingletonKey As String = "SingletonTestKey"

Private RequestCount&, RPCLooping As Boolean
Private TestMethods As cWrapcTestMethods

Private WithEvents Cnn As cRPCConnection
Attribute Cnn.VB_VarHelpID = -1

Private Sub Form_Load()
  On Error Resume Next
  
  'our ClientConnection-Object (instantiated from the Factory)
  Set Cnn = New_c.RPCConnection
  
  If Cnn Is Nothing Then
    MsgBox "Couldn't instantiate RPC-Connection-Object"
    Unload Me: Exit Sub
  End If
  Cnn.Host = tHost.Text
  Cnn.Port = tPort.Text
  Cnn.KeepAlive = (cKeepAlive.Value = 1)

  Set TestMethods = New cWrapcTestMethods
  TestMethods.SetRPCConnection Cnn

  'if running the Project-Group in the IDE, we can enable here
  'a comfortable "Server-Debugging" without the real RPC-Server.
  'The Cnn-Object then uses its internal "RoundTrip-Simulation",
  'which does exactly the same thing like the Server inside the
  'WorkerThread - incl. Serializing/Deserializing, Compression
  '(if switched on) etc. - only the Socket-Transfer is bypassed.
  'So you can set breakpoints inside your Server-Methods and
  'validate them, before compiling your Server-Binary and copying
  'it to the RPCDlls-Folder at the ServerSide.
  'Note: DebuggingMode expects, that the ProjectName (or better, the left
  'part of the Dlls ProgID can be determined from the DllName defined
  'in your WrapperClass.
  If RunningInIde Then
    Cnn.DebugMode = True 'you can switch to false here, if you want to use the real server
    
    'for Debugging we overwrite the internal DllName 'ServerTest.Dll',
    '(which would be used in "real ServerMode") with the left part of
    'the ServerDlls ProgID - so our Cnn-internal "RoundTrip-Simulator"
    'can call CreateObject(DllName & "." & ClassName) instead of:
    'GETINSTANCE(DllName, ClassName)
    If Cnn.DebugMode Then TestMethods.DllName = "ServerTest"
  End If
End Sub

Private Sub bConnect_Click()
  If InStr(1, bConnect.Caption, "DisConnect", vbTextCompare) Then
    Cnn.Disconnect
  Else
    Cnn.Host = tHost.Text
    Cnn.Port = tPort.Text
    If Cnn.DebugMode Then
      MsgBox "DebugMode is enabled - you don't need to connect!"
      Exit Sub
    End If
    On Error Resume Next
    If Not Cnn.Connect(2) Then 'Connect-Attempt with 2sec TimeOut
      If Err Then
        RPCErrorHandler
      Else
        Err.Raise vbObjectError, , "Couldn't connect!"
        RPCErrorHandler
      End If
    End If
  End If
End Sub

Private Sub bCancelRequest_Click()
  Cnn.Cancel 'cancels all pending connects or requests
End Sub

'Connect- and Disconnect-Events, fired by our Cnn-Object
Private Sub Cnn_Connected()
  bConnect.BackColor = &H80FF80
  bConnect.Caption = "             DisConnect              (green if connected)"
End Sub
Private Sub Cnn_DisConnected()
  bConnect.BackColor = &H8000000F
  bConnect.Caption = "               Connect                 (green if connected)"
End Sub

'Progress-Events (interesting especially on slower internet-connections and larger transfers)
Private Sub Cnn_SendProgress(ByVal Bytes As Long, ByVal BytesTotal As Long)
  lSendOut.Caption = Bytes & " of " & BytesTotal & " (" & CLng(Bytes / BytesTotal * 100) & "%)"
  If Bytes <> BytesTotal Then lSendOut.Refresh
  If Bytes < BytesTotal Then lRecvOut.Caption = "Waiting for receive..."
End Sub
Private Sub Cnn_ReceiveProgress(ByVal Bytes As Long, ByVal BytesTotal As Long)
  lRecvOut.Caption = Bytes & " of " & BytesTotal & " (" & CLng(Bytes / BytesTotal * 100) & "%)"
  If Bytes <> BytesTotal Then lRecvOut.Refresh
End Sub

Private Sub cKeepAlive_Click()
  Cnn.KeepAlive = (cKeepAlive.Value = 1)
End Sub
Private Sub cCompression_Click()
  Cnn.Compression = (cCompression.Value = 1)
End Sub
Private Sub cEncryption_Click()
  On Error Resume Next
  Cnn.Encryption = (cEncryption.Value = 1)
  If Err Then
    RPCErrorHandler
    cEncryption.Value = IIf(Cnn.Encryption, 1, 0)
    cEncryption.Refresh
  End If
  If Cnn.Encryption Then cAuth.Value = 1 'Setting Encryption automatically forces Authentication
End Sub

Private Sub cAuth_Click()
  On Error Resume Next
  Cnn.ServerAuthentication = (cAuth.Value = 1)
  If Err Then
    RPCErrorHandler
    cAuth.Value = IIf(Cnn.ServerAuthentication, 1, 0)
    cAuth.Refresh
  End If
  If Not Cnn.ServerAuthentication Then cEncryption.Value = 0 'Disabling Auth. also disables Encr.
End Sub

Private Sub tUserName_Change()
  Cnn.UserName = tUserName.Text
End Sub
Private Sub tDomainName_Change()
  Cnn.DomainName = tDomainName.Text
End Sub
Private Sub tPassWord_Change()
  Cnn.PassWord = tPassWord.Text
End Sub

Private Sub bSingleReflect_Click()
Dim T#, Result$
  T = HPTimer
  Result = TestMethods.Reflect(tReflect.Text)
  lResults.Caption = Result & " " & CLng((HPTimer - T) * 100000) / 100 & "  ms"
End Sub

Private Sub bLoop4_Click()
  TestMethods.BlockingLoop 4
  If Err Then RPCErrorHandler: Exit Sub
  
  MsgBox "4s-Blocking-Loop finished without problems!"
End Sub

Private Sub bByRefParams_Click()
Dim C As Currency, D As Date, B As Boolean
  C = 12345.6789: D = Now: B = False
  
  TestMethods.ByRefSimpleTypes C, D, B
  If Err Then RPCErrorHandler: Exit Sub
  
  MsgBox Str(C) & ", Tomorrow, same time: " & D & ", " & B
End Sub

Private Sub bByrefArrays_Click()
Dim B() As Byte, S() As String, V(), i&, Result$
  'input for our three arrays
  ReDim B(0 To 9): For i = 0 To 9: B(i) = i: Next i
  S = Split("a,b,c", ",")
  ReDim V(1, 1, 1, 1, 5): V(1, 1, 1, 1, 5) = Array("Array-inside-Array")
  
  TestMethods.ByRefArrayTypes B, S, V
  If Err Then RPCErrorHandler: Exit Sub
  
  For i = 0 To UBound(B): Result = Result & ", " & B(i): Next i
  MsgBox Mid$(Result, 3) & vbCrLf & Join(S, ",") & vbCrLf & V(5, 5, 5, 1)(2)(0)
End Sub

Private Sub bByteArray_Click()
Dim Result() As Byte

  Result = TestMethods.ReturnByteArray(12, 34)
  If Err Then RPCErrorHandler: Exit Sub
  
  MsgBox Result(0) & " " & Result(1)
End Sub

Private Sub bLargeString_Click()
Dim T As Double, S As String
  T = HPTimer
  
  S = TestMethods.Reflect("a" & Space(1000000) & "z")
  If Err Then RPCErrorHandler: Exit Sub
  
  MsgBox CLng((HPTimer - T) * 1000) & "ms, " & Left(S, 1) & "-" & Right(S, 1)
End Sub

Private Sub cEnterLoop_Click()
  If cEnterLoop.Value = 1 Then
    tmLoopDecoupling.Enabled = True 'don't loop inside here, we use a timer (see below)
  Else
    RPCLooping = False
  End If
End Sub
'Loop-Decoupling-Timer (disabled instantly, if we are inside the Timer-Event)
Private Sub tmLoopDecoupling_Timer()
Dim T#, Result
Static CC&
  tmLoopDecoupling.Enabled = False
  RPCLooping = True
  Do
    T = HPTimer
    Result = TestMethods.Reflect(tReflect.Text)
    CC = (CC + 1) Mod 50
    If CC = 0 Then 'refresh only all 50 requests
      lResults.Caption = Result & " " & CLng((HPTimer - T) * 100000) / 100 & "  ms"
    End If
    RequestCount = RequestCount + 1
    DoEvents
  Loop While RPCLooping And Err = 0
  If Err Then RPCErrorHandler
  RPCLooping = False: cEnterLoop.Value = 0
  If Tag = "Unload Me" Then Unload Me
End Sub

Private Sub bErrorCall1_Click()
  TestMethods.ErrorCall1
  If Err Then RPCErrorHandler: Exit Sub
End Sub

Private Sub bErrorCall2_Click()
  TestMethods.ErrorCall2
  If Err Then RPCErrorHandler: Exit Sub
End Sub

Private Sub bErrorCall3_Click()
  TestMethods.ErrorCall3
  If Err Then RPCErrorHandler: Exit Sub
End Sub

Private Sub bErrorLoop_Click()
  If Cnn.DebugMode Then
    MsgBox "If running in DebugMode, the RPC-TimeOuts are not used," _
    & vbCrLf & "because you want a relaxed BreakPoint-Debugging ;-)." _
    & vbCrLf & vbCrLf & "So it's better, not to force this call in the IDE!"
    Exit Sub
  End If
  'much too long do we force looping (120sec, simulating a hanging call)
  '- so the server needs to kick out its "hanging" WorkerThread
  'using the RPC-Timeout, specified in the wrapper-class
  '(the timeout for this BlockingLoop-RPC is set to 5 seconds)
  TestMethods.BlockingLoop 120 'try to block for 120 seconds
  If Err Then RPCErrorHandler: Exit Sub
End Sub

Private Sub bRecordsetCall_Click()
Dim Rs As Recordset, T#
  Set Rs = New Recordset
  Rs.Fields.Append "SomeInteger", adInteger
  Rs.Fields.Append "SomeString", adVarWChar, 255
  Rs.Open
  Rs.AddNew
  Rs!SomeInteger = 1: Rs!SomeString = "String1"
  Rs.Update
  T = HPTimer
  TestMethods.AddOneHundredRecordsTo Rs
  If Err Then RPCErrorHandler: Exit Sub
  
  Rs.MoveLast 'set position to the last record
  MsgBox "The Rs now contains " & Rs.RecordCount & " Records - the last Record is:" _
         & vbCrLf & vbCrLf & "Rs!SomeInteger = " & Rs!SomeInteger _
         & " and Rs!SomeString = '" & Rs!SomeString & "'" & vbCrLf & vbCrLf _
         & "The Call was finished after: " & CLng((HPTimer - T) * 1000) & "ms"
End Sub

Private Sub bStdPictureCall_Click()
  imgStdPictureRequest.Stretch = True
  imgStdPictureRequest.Picture = Nothing
  Set imgStdPictureRequest.Picture = TestMethods.GetFirstBitmapIn("C:\Windows\")
  If Err Then RPCErrorHandler: Exit Sub
End Sub

Private Sub bEnsureSingleton_Click()
Dim Success As Boolean
  On Error Resume Next
  Success = Cnn.EnsureServerSingletonIsRunning("ServerTest.Dll", "cTestSingleton", SingletonKey)
  If Err Then RPCErrorHandler: Exit Sub
  
  If Success Then MsgBox "Singleton is running! (""" & SingletonKey & """)"
End Sub
'
''Singleton-Parameters are used in a special way:
''They always have to be ByVal-Variants - here at client-side you
''have to place the appropriate Singleton-Key in them, at the
''server-side they are automatically replaced with the matching
''Singleton-Object-Instance (Cnn.EnsureServerSingletonIsRunning
''should be called prior of course)
'Private Sub bIncrementSingleton_Click()
'Dim ActualSingletonCounter As Long
'  ActualSingletonCounter = TestMethods.SingletonCall(SingletonKey)
'  If Err Then RPCErrorHandler: Exit Sub
'
'  MsgBox "Actual Singleton-Counter: " & ActualSingletonCounter
'End Sub
'
'Private Sub bShowSingletonStatusForm_Click()
'
'  TestMethods.SingletonShowStatusForm SingletonKey
'  If Err Then RPCErrorHandler: Exit Sub
'
'  MsgBox "The Singleton-StatusForm should now run!" & vbCrLf & _
'         "If the RPCServer runs as Service, you have to enable the" & vbCrLf & _
'         "'Interact with Desktop'-Switch inside the Service-Manager!"
'End Sub

Private Sub bAddToCollection_Click()
Dim CurCount As Long
  CurCount = TestMethods.SingletonGetCollectionCount()
  If Err Then RPCErrorHandler: Exit Sub
  
  TestMethods.SingletonAddEntry CStr(CurCount + 1), "Item_" & CurCount + 1
  If Err Then RPCErrorHandler: Exit Sub
End Sub

Private Sub bGetCollectionCount_Click()
Dim CurCount As Long
  CurCount = TestMethods.SingletonGetCollectionCount()
  If Err Then RPCErrorHandler: Exit Sub
  
  MsgBox "Current Collection-Count: " & CurCount
End Sub

Private Sub bGetCollectionItem_Click()
Dim CurCount As Long, LastItem As String
  CurCount = TestMethods.SingletonGetCollectionCount()
  If Err Then RPCErrorHandler: Exit Sub
    
  LastItem = TestMethods.SingletonGetEntry(CStr(CurCount))
  If Err Then RPCErrorHandler: Exit Sub
  
  MsgBox "The last Collection-Entry is: " & LastItem
End Sub

Private Sub bCloseSingleton_Click()
Dim Success As Boolean
  
  On Error Resume Next
  Success = Cnn.DestroyServerSingleton(SingletonKey)
  If Err Then RPCErrorHandler: Exit Sub
  
  If Success Then MsgBox "Singleton with the Key: '" & SingletonKey & "' destroyed!"
End Sub

'Private Sub RPCErrorHandler(ErrString As String)
'Dim EArr() As String, i As Long
'  Err.Clear 'clear the Err-Object first
'  'now process the Error-String (here logging only)
'  'Beep 'inform the user ;-)
'  EArr = Split(ErrString, vbCrLf) 'most errors come in two lines
'  ReDim Preserve EArr(UBound(EArr) + 1) 'add one empty line
'  For i = 0 To UBound(EArr)
'    lstErrorLog.AddItem Replace(EArr(i), vbLf, " - ") 'some VB-Errors contain only LFs
'    If lstErrorLog.ListCount > 6 Then lstErrorLog.RemoveItem 0
'  Next i
'End Sub
Private Sub RPCErrorHandler()
Dim EArr() As String, i As Long, ENr$
  If Err.Number = 0 Then Exit Sub
  'now process the Error-String (here logging only)
  'Beep 'inform the user ;-)
  EArr = Split(Err.Description, vbCrLf) 'most errors come in two lines
  
  If Err.Number < 0 And Err.Number >= vbObjectError Then
    ENr = "vbObjectError + " & Err.Number - vbObjectError
  Else
    ENr = Err.Number
  End If
  EArr(UBound(EArr)) = EArr(UBound(EArr)) & " (Err.Number: " & ENr & ", Err.Source: " & Err.Source & ")"
  ReDim Preserve EArr(UBound(EArr) + 1) 'add one empty line
  For i = 0 To UBound(EArr)
    lstErrorLog.AddItem Replace(EArr(i), vbLf, " - ") 'some VB-Errors contain only LFs
    If lstErrorLog.ListCount > 6 Then lstErrorLog.RemoveItem 0
  Next i
  Err.Clear 'clear the Err-Object first
End Sub

'average Requests/sec (the timer runs with 500msec, so multiplying
'by 2 is not a cheap trick, to double our performance ;-)
'The timer is also used (triggered from Query_Unload), to wait with the
'Unload of the form for some time, until all running RPC-Activities are
'cancelled.
Private Sub tmRequestCounter_Timer()
  If tmRequestCounter.Tag = "Unload Me" Then
    tmRequestCounter.Enabled = False
    Unload Me
  Else
    lReqPerSec.Caption = RequestCount * 2: RequestCount = 0
  End If
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
  If Not Cnn Is Nothing Then Cnn.Cancel 'cancels all eventually waiting Connect-Attempts or RPCs
  RPCLooping = False 'cancels our eventually running "Reflection-Loop"
  
  If tmRequestCounter.Tag = "" Then
    tmRequestCounter.Enabled = False: tmRequestCounter.Enabled = True 'retrigger the interval
    tmRequestCounter.Tag = "Unload Me"
    Cancel = True
    Me.Hide
  End If
End Sub


