VERSION 5.00
Begin VB.Form fTestdhSQLiteDC 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "dhSQLITE simple (Self-)Binding-Approach"
   ClientHeight    =   6120
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   5355
   Icon            =   "fTestdhSQLiteDC.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6120
   ScaleWidth      =   5355
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CheckBox chkUseBuiltInServerClass 
      Caption         =   "Use BuiltIn Server-Class"
      Height          =   345
      Left            =   120
      TabIndex        =   9
      Top             =   90
      Value           =   1  'Aktiviert
      Width           =   2115
   End
   Begin RPCDBDemo.ucdhSQLiteDC ucdhSQLiteDC1 
      Height          =   345
      Left            =   90
      TabIndex        =   2
      Top             =   5160
      Width           =   5175
      _ExtentX        =   9128
      _ExtentY        =   609
   End
   Begin RPCDBDemo.ucStdPicBinding ucStdPicBinding1 
      Height          =   3390
      Left            =   2250
      TabIndex        =   8
      TabStop         =   0   'False
      Top             =   1590
      Width           =   2940
      _ExtentX        =   5186
      _ExtentY        =   5980
   End
   Begin RPCDBDemo.ucTextBox tFirstName 
      Height          =   330
      Left            =   2250
      TabIndex        =   1
      Top             =   990
      Width           =   2940
      _ExtentX        =   5186
      _ExtentY        =   582
   End
   Begin RPCDBDemo.ucTextBox tLastName 
      Height          =   330
      Left            =   2250
      TabIndex        =   0
      Top             =   570
      Width           =   2940
      _ExtentX        =   5186
      _ExtentY        =   582
   End
   Begin VB.CommandButton bRestore 
      Caption         =   "Restore original Data from EmployeesBackup-Table"
      Height          =   330
      Left            =   105
      TabIndex        =   3
      Top             =   5625
      Width           =   5145
   End
   Begin VB.PictureBox PicUpd 
      AutoRedraw      =   -1  'True
      BackColor       =   &H0080FFFF&
      Height          =   1050
      Left            =   135
      ScaleHeight     =   990
      ScaleWidth      =   1575
      TabIndex        =   4
      TabStop         =   0   'False
      Top             =   1935
      Width           =   1635
   End
   Begin VB.Label lFirstName 
      Caption         =   "FirstName"
      Height          =   240
      Left            =   135
      TabIndex        =   7
      Top             =   1035
      Width           =   1770
   End
   Begin VB.Label lLastName 
      Caption         =   "LastName"
      Height          =   240
      Left            =   135
      TabIndex        =   6
      Top             =   630
      Width           =   1770
   End
   Begin VB.Label lPhoto 
      Caption         =   "Photo"
      Height          =   240
      Left            =   135
      TabIndex        =   5
      Top             =   1620
      Width           =   1770
   End
End
Attribute VB_Name = "fTestdhSQLiteDC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This example avoids the usage of dhSQLites builtin ADO-Databinding-
'capabilities - but working in a way as shown in this form
'(together with ucdhSQLiteDC and cdhSQLiteBindInfo), you
'can ensure binding-comfort without any ADO-Dependencies
'(no Deployment-hazzle and full control in VB-Code).
Option Explicit

Private Const SQLiteDBName$ = "NWind.db"

Private RPCWrapper As cDBAccessWrapper

Private Sub Form_Load()
  'Bind our Controls
  ucdhSQLiteDC1.BindControlTo "LastName", tLastName, "Text", "Change"
  ucdhSQLiteDC1.BindControlTo "FirstName", tFirstName, "Text", "Change"
  ucdhSQLiteDC1.BindControlTo "Photo", ucStdPicBinding1, "Image", "Change"
  
  Set RPCWrapper = New cDBAccessWrapper
  If Not RPCWrapper.Connect(fMain.tHost.Text, fMain.tPort.Text, 2) Then
    MsgBox "Couldn't establish an Appserver-Connection!"
    Set ucdhSQLiteDC1.Recordset = Nothing
    Exit Sub
  End If
  
  'bind Recordset to our simple SQLite-Data-Control
  Set ucdhSQLiteDC1.Recordset = RPCWrapper.GetRsSQLite(SQLiteDBName, "Select * from Employees")

  'prepare a simple ImageSource, to demonstrate Blob-Image-Updates
  PicUpd.AutoRedraw = True
  PicUpd.Print "Click Me, to change"
  PicUpd.Print "Image-Content"
End Sub

Private Sub chkUseBuiltInServerClass_Click()
  RPCWrapper.UseBuiltInServerClass = chkUseBuiltInServerClass.Value
End Sub

Private Sub PicUpd_Click()
  PicUpd.Cls
  PicUpd.Print tLastName.Text
  PicUpd.Print tFirstName.Text
  Set ucStdPicBinding1.Image = PicUpd.Image 'force Update (over the Control into the Rs)
  PicUpd.Cls
  PicUpd.Print "Click Me, to change"
  PicUpd.Print "Image-Content"
End Sub

Private Sub bRestore_Click()
Dim AffectedRows As Long, SQL As String
  If ucdhSQLiteDC1.Recordset Is Nothing Then Exit Sub
  SQL = "DELETE From Employees; " & _
        "Insert Into Employees Select * from EmployeesBackup;"
  AffectedRows = RPCWrapper.ExecuteSQLite(SQLiteDBName, SQL)
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub

  'now let's requery our Recordset
  Set ucdhSQLiteDC1.Recordset = RPCWrapper.GetRsSQLite(SQLiteDBName, "Select * from Employees")
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Set ucdhSQLiteDC1.Recordset = Nothing
  Set RPCWrapper = Nothing
End Sub

Private Sub ucdhSQLiteDC1_ForceUpdateBatch()
Dim RefreshedRs As cRecordset, CurrentID&
  Set RefreshedRs = RPCWrapper.UpdateBatchSQLite(SQLiteDBName, ucdhSQLiteDC1.Recordset)
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub
  
  'ensure the correct Record on our new, updated Data
  If ucdhSQLiteDC1.Recordset.RecordCount > 0 And Not RefreshedRs Is Nothing Then
    CurrentID = ucdhSQLiteDC1.Recordset.Fields("EmployeeID").Value
    RefreshedRs.FindFirst "EmployeeID = " & CurrentID
    Set ucdhSQLiteDC1.Recordset = RefreshedRs
  End If
End Sub
