VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Begin VB.Form fSQLiteAccess 
   Caption         =   "RPC-Demo-SQLite-Access"
   ClientHeight    =   8220
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8865
   Icon            =   "fSQLiteAccess.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   8220
   ScaleWidth      =   8865
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CheckBox chkUseBuiltInServerClass 
      Caption         =   "Use BuiltIn Server-Class"
      Height          =   345
      Left            =   90
      TabIndex        =   12
      Top             =   120
      Value           =   1  'Aktiviert
      Width           =   2115
   End
   Begin VB.Frame fDBHandling 
      Caption         =   "DB-Connection and SQL-Requests"
      Height          =   1140
      Left            =   90
      TabIndex        =   4
      Top             =   1590
      Width           =   8565
      Begin VB.Timer tReqPerSec 
         Interval        =   1000
         Left            =   8100
         Top             =   -30
      End
      Begin VB.CheckBox chkEnterLoop 
         Caption         =   "Enter Loop (Stresstest)"
         Height          =   285
         Left            =   6480
         TabIndex        =   10
         Top             =   300
         Width           =   1995
      End
      Begin VB.CommandButton bGetTables 
         Caption         =   "Get Table- and View-Names ->"
         Height          =   300
         Left            =   120
         TabIndex        =   8
         Top             =   285
         Width           =   2385
      End
      Begin VB.ComboBox cTableList 
         Height          =   315
         Left            =   2595
         Style           =   2  'Dropdown-Liste
         TabIndex        =   7
         Top             =   285
         Width           =   2910
      End
      Begin VB.TextBox tSQL 
         Height          =   300
         Left            =   2595
         TabIndex        =   6
         Top             =   675
         Width           =   5340
      End
      Begin VB.CommandButton bExecuteSQL 
         Caption         =   "Go!"
         Default         =   -1  'True
         Height          =   300
         Left            =   7965
         TabIndex        =   5
         Top             =   675
         Width           =   420
      End
      Begin VB.Label lReqPerSec 
         Caption         =   "Req/s: "
         Height          =   255
         Left            =   5610
         TabIndex        =   11
         Top             =   330
         Width           =   825
      End
      Begin VB.Label lSQL 
         Caption         =   "SQL-String for Rs-Select:"
         Height          =   240
         Left            =   135
         TabIndex        =   9
         Top             =   720
         Width           =   1950
      End
   End
   Begin VB.Frame fIPSettings 
      Caption         =   "(Re-)Connect (to Server and Port, given in the Main-Form)"
      Height          =   825
      Left            =   90
      TabIndex        =   1
      Top             =   600
      Width           =   8565
      Begin VB.CommandButton cmdUpdateBatch 
         Caption         =   "UpdateBatch"
         Height          =   345
         Left            =   6480
         TabIndex        =   13
         Top             =   300
         Width           =   1785
      End
      Begin VB.CommandButton bConnect 
         Caption         =   "(Re-)Connect"
         Height          =   315
         Left            =   120
         Style           =   1  'Grafisch
         TabIndex        =   3
         Top             =   330
         Width           =   1170
      End
      Begin VB.CheckBox chkCompress 
         Caption         =   "Enable Compression"
         Height          =   240
         Left            =   1440
         TabIndex        =   2
         Top             =   390
         Value           =   1  'Aktiviert
         Width           =   1815
      End
   End
   Begin VB.Frame fDG 
      Caption         =   "DataGrid"
      Height          =   5145
      Left            =   150
      TabIndex        =   0
      Top             =   2940
      Width           =   8595
      Begin MSDataGridLib.DataGrid DG 
         Height          =   2385
         Left            =   120
         TabIndex        =   14
         Top             =   240
         Width           =   7635
         _ExtentX        =   13467
         _ExtentY        =   4207
         _Version        =   393216
         HeadLines       =   1
         RowHeight       =   15
         BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ColumnCount     =   2
         BeginProperty Column00 
            DataField       =   ""
            Caption         =   ""
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1031
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column01 
            DataField       =   ""
            Caption         =   ""
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1031
               SubFormatType   =   0
            EndProperty
         EndProperty
         SplitCount      =   1
         BeginProperty Split0 
            BeginProperty Column00 
            EndProperty
            BeginProperty Column01 
            EndProperty
         EndProperty
      End
   End
End
Attribute VB_Name = "fSQLiteAccess"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const SQLiteDBName$ = "NWind.db"

Private WithEvents RPCWrapper As cDBAccessWrapper, Rs As cRecordset, ReqCounter&
Attribute RPCWrapper.VB_VarHelpID = -1

Private Sub bConnect_Click()
  If Not RPCWrapper.Connect(fMain.tHost.Text, fMain.tPort.Text, 2) Then '2 sec-timeout
    MsgBox "Couldn't establish an Appserver-Connection!"
  End If
End Sub

Private Sub cmdUpdateBatch_Click()
  Set Rs = RPCWrapper.UpdateBatchSQLite(SQLiteDBName, Rs)
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub
  
  Set DG.DataSource = Rs.DataSource
End Sub

Private Sub RPCWrapper_Connected()
  bConnect.BackColor = vbGreen
End Sub
Private Sub RPCWrapper_DisConnected()
  bConnect.BackColor = -2147483633
End Sub

Private Sub bExecuteSQL_Click()
Dim T As Single
  T = Timer
  SetBusyState True 'Block User-Interaction and set the HourGlass-MouseIcon
    Set Rs = RPCWrapper.GetRsSQLite(SQLiteDBName, tSQL.Text)
  SetBusyState False
  If Err Then MsgBox Err.Description: Err.Clear: chkEnterLoop.Value = 0: Exit Sub
  If Rs Is Nothing Then Exit Sub
  fDG.Enabled = False 'ensure, nobody is clicking into it, whilst changing Rs-Content
    Set DG.DataSource = Rs.DataSource
  fDG.Enabled = True
  fDG.Caption = "DataGrid: " & Rs.RecordCount & " Records (" & Rs.Fields.Count _
              & " Columns) received after " & CLng((Timer - T) * 1000) & "msec"
  ReqCounter = ReqCounter + 1
End Sub

Private Sub bGetTables_Click()
Dim Rs As cRecordset, i&
  SetBusyState True 'Block User-Interaction and set the HourGlass-MouseIcon
    Set Rs = RPCWrapper.GetTablesSQLite(SQLiteDBName)
  SetBusyState False
  If Err Then MsgBox Err.Description: Err.Clear: Exit Sub
  If Rs Is Nothing Then Exit Sub
  If Rs.RecordCount = 0 Then Exit Sub
  cTableList.Clear
  For i = 0 To Rs.RecordCount - 1
    cTableList.AddItem Rs.ValueMatrix(i, 0)
  Next i
  cTableList.ListIndex = 0
End Sub

Private Sub cTableList_Click()
  tSQL.Text = "Select * From [" & cTableList.Text & "]"
  bExecuteSQL_Click
End Sub

Private Sub chkCompress_Click()
  RPCWrapper.RPCCnn.Compression = (chkCompress.Value = 1)
End Sub

Private Sub chkEnterLoop_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
  Do While chkEnterLoop.Value
    bExecuteSQL_Click
    DoEvents
  Loop
End Sub

Private Sub Form_Load()
  Set RPCWrapper = New cDBAccessWrapper
  RPCWrapper.RPCCnn.Host = fMain.tHost.Text
  RPCWrapper.RPCCnn.Port = fMain.tPort.Text
 
End Sub

Private Sub chkUseBuiltInServerClass_Click()
  RPCWrapper.UseBuiltInServerClass = chkUseBuiltInServerClass.Value
End Sub

Private Sub Form_Resize()
  On Error Resume Next
  fIPSettings.Move 45, 520, ScaleWidth - 90
  fDBHandling.Move 45, 1480, ScaleWidth - 90
  fDG.Move 45, 2740, ScaleWidth - 90, ScaleHeight - 2740
  DG.Move 15, 210, fDG.Width - 45, fDG.Height - 255
  If Err Then Err.Clear
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
  If chkEnterLoop.Value Then chkEnterLoop.Value = 0: Cancel = True
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Set RPCWrapper = Nothing
  Set Rs = Nothing
End Sub

Private Sub SetBusyState(ByVal WaitFlag As Boolean)
  Screen.MousePointer = IIf(WaitFlag, vbArrowHourglass, vbDefault)
  bGetTables.Enabled = Not WaitFlag
  bExecuteSQL.Enabled = Not WaitFlag
End Sub

Private Sub tReqPerSec_Timer()
  lReqPerSec = "Req/s: " & ReqCounter: ReqCounter = 0
End Sub
