VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cDBAccess"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Path$

Private Sub Class_Initialize()
  'here we assume, that the SQLite-DB-File is placed beside this Dll
  Path = App.Path
  If Right(Path, 1) <> "\" Then Path = Path & "\"
End Sub

Public Function GetRs(ByVal ThreadCollection As Collection, DBName As String, SQL As String) As cRecordset
Dim Rs As cRecordset
  On Error Resume Next
  Set Rs = GetPooledSQLiteRs(ThreadCollection, DBName)
  If Err Then Exit Function 'this way the error from GetPooledSQLiteRs can bubble up
  
  Rs.OpenRecordset SQL
  Set GetRs = Rs
End Function

Public Function UpdateBatch(ByVal ThreadCollection As Collection, DBName As String, RsContent) As Long
Dim Rs As cRecordset, ContentBytes() As Byte, dhF As cFactory
  On Error Resume Next
  
  Set dhF = ThreadCollection("dh_Factory")
  If Err Then Exit Function 'report an eventual instancing-error to the client

  Set Rs = dhF.C.Recordset(GetPooledSQLiteRs(ThreadCollection, DBName).ActiveConnection)
  If Err Then Exit Function 'report an eventual instancing-error to the client

  ContentBytes = RsContent 'get the "pure" ByteArray from the Variant
  Rs.Content = ContentBytes 'now initialize our new created Rs with these Bytes
  If Err Then Exit Function 'report an eventual Deserializing-Error to the client
  
  Rs.UpdateBatch 'here we try, to write all changes (inserts, updates or deletes) into the DB
  If Err Then Exit Function 'report an UpdateBatch-Error to the client

  UpdateBatch = Rs.ActiveConnection.AffectedRows  'return the RowCount
End Function

Public Function UpdateBatchAndRequery(ByVal ThreadCollection As Collection, DBName As String, RsContent) As cRecordset
Dim RsForRequery As cRecordset, Rs As cRecordset, ContentBytes() As Byte, dhF As cFactory
  On Error Resume Next
  
  Set dhF = ThreadCollection("dh_Factory")
  If Err Then Exit Function 'report an eventual instancing-error to the client

  Set Rs = dhF.C.Recordset
  If Err Then Exit Function 'report an eventual instancing-error to the client

  ContentBytes = RsContent 'get the "pure" ByteArray from the Variant
  Rs.Content = ContentBytes 'now initialize our new created Rs with these Bytes
  If Err Then Exit Function 'report an eventual Deserializing-Error to the client
  
  Set RsForRequery = GetPooledSQLiteRs(ThreadCollection, DBName)
  If Err Then Exit Function 'this way the error from GetPooledSQLiteRs can bubble up
  
  Set Rs.ActiveConnection = RsForRequery.ActiveConnection
  Rs.UpdateBatch 'here we try, to write all changes (inserts, updates or deletes) into the DB
  If Err Then Exit Function 'report an UpdateBatch-Error to the client

  RsForRequery.OpenRecordset Rs.SQL 'requery with the original SQL-String (now that the new Data is in the DB)
  Set UpdateBatchAndRequery = RsForRequery 'RsForRequery.Content 'return the refreshed Rs-Content to the Client
End Function

Public Function Execute(ByVal ThreadCollection As Collection, DBName As String, SQL As String) As Long
Dim Rs As cRecordset
  On Error Resume Next
  Set Rs = GetPooledSQLiteRs(ThreadCollection, DBName)
  If Err Then Exit Function 'this way the error from GetPooledSQLiteRs can bubble up

  Rs.ActiveConnection.BeginTrans
    Rs.ActiveConnection.Execute SQL 'dhSQLite-Execute supports multiple, semicolon-delimited SQL-Statements
  If Err Then
    Rs.ActiveConnection.RollbackTrans
  Else
    Rs.ActiveConnection.CommitTrans
    Execute = Rs.ActiveConnection.AffectedRows
  End If
End Function

'a small helper-function, which demonstrates the usage of the RPCServers
'ThreadPool-Collection - used inside here, to ensure Connection-Pooling for SQLite too
'(for ADO-Connections this is already ensured by the Windows-OS)
Private Function GetPooledSQLiteRs(ThreadCollection As Collection, DBName As String) As cRecordset
Dim dhF As cFactory, Rs As cRecordset
  On Error Resume Next
  
  Set GetPooledSQLiteRs = ThreadCollection(Path & DBName)
  
  If Err Then
    Err.Clear
    Set dhF = ThreadCollection("dh_Factory")
    If Err Then Exit Function 'report an eventual error to the client
    
    Set Rs = dhF.C.Recordset(dhF.C.Connection(Path & DBName))

    If Err = 0 Then ThreadCollection.Add Rs, Path & DBName
    Set GetPooledSQLiteRs = Rs
  End If
End Function
