VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cDBAccessWrapper"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'This is the small RPC-wrapper-class for the "real workhorse" -> cDBAccess
'(already implemented inside dhRichClient.dll), but I've also included
'the sourcecode of the serverside Class in a SubFolder to this project,
'called: "Server-Dll"
'You can switch between the two serverside Implementations using a
'Public Property of this class, called: "UseBuiltInServerClass"
Option Explicit

Event Connected()
Event DisConnected()

Public UseBuiltInServerClass As Boolean
'the Consts for the "builtin-Operation-Mode"
Private Const SrvDllNameBuiltIn As String = "dhRichClient3.Dll"
Private Const SrvClassNameBuiltIn As String = "cDBAccess"
'and the same Consts for "I-use-my-own-Dll-Operation-Mode"
Private Const SrvDllNameYourOwn As String = "DBServer.Dll"
Private Const SrvClassNameYourOwn As String = "cDBAccess"

Private ThreadCollectionParam As Variant, Path As String 'our App-Path

'this is the client-part of our RPCServer, which does all the socket-
'communication- and Serializing/Deserializing-stuff for us
Public WithEvents RPCCnn As cRPCConnection
Attribute RPCCnn.VB_VarHelpID = -1

Private Sub Class_Initialize()
  UseBuiltInServerClass = True
  ThreadCollectionParam = "dh_ThreadCollection" 'init ThreadCollection-Replacement-Var
  Path = App.Path
  'here we instantiate the RPC-Cnn without using the registry
  Set RPCCnn = New_c.RPCConnection
  'set Connection-Defaults
  RPCCnn.KeepAlive = True 'keep socket-connections alive (no reconnect needed, before calling an RPC)
  RPCCnn.Compression = True 'for DB-Stuff this switch is useful, even in 100MBit-LANs (for GBit-LANs you can switch this off)
End Sub

Public Function Connect(Host As String, Port As Long, Optional ByVal TimeOut As Double) As Boolean
  On Error Resume Next
  RPCCnn.Host = Host: RPCCnn.Port = Port
'  RPCCnn.UserName = "Windows-Username known at the serverside"
'  RPCCnn.Password = "The appropriate User-Password"
'  RPCCnn.DomainName = "." 'if you want to authenticate against a Domain, replace the '.'
'  RPCCnn.ServerAuthentication = True
'  RPCCnn.Encryption = True
  Connect = RPCCnn.Connect(TimeOut)
  If Err Then Err.Clear
End Function

Private Sub RPCCnn_Connected() 'Event-Delegation for the Connect-State
  RaiseEvent Connected
End Sub
Private Sub RPCCnn_DisConnected() 'Event-Delegation for the Connect-State
  RaiseEvent DisConnected
End Sub


'*********** Begin of the Wrapper-Functions for SQLite **************
Public Function GetTablesSQLite(DBName As String) As cRecordset
Dim SQL$
  SQL = "Select name from sqlite_master where type='table' or type='view' order by name"
  Set GetTablesSQLite = GetRsSQLite(DBName, SQL)
End Function

Public Function GetRsSQLite(DBName As String, SQL As String) As cRecordset
  On Error Resume Next

  'Now the RPC with a TimeOut of 10 seconds...
  If UseBuiltInServerClass Then
    Set GetRsSQLite = RPCCnn.RPC(SrvDllNameBuiltIn, SrvClassNameBuiltIn, "GetRs", 10, ThreadCollectionParam, DBName, SQL)
  Else
    Set GetRsSQLite = RPCCnn.RPC(SrvDllNameYourOwn, SrvClassNameYourOwn, "GetRs", 10, ThreadCollectionParam, DBName, SQL)
  End If
End Function

Public Function UpdateBatchSQLite(DBName As String, Rs As cRecordset) As cRecordset
'Dim B() As Byte
  If Rs Is Nothing Then Exit Function
  If Not Rs.ContainsChanges Then Exit Function
  
  On Error Resume Next
  'Now the RPC with a TimeOut of 10 seconds...
  If UseBuiltInServerClass Then
    Set UpdateBatchSQLite = RPCCnn.RPC(SrvDllNameBuiltIn, SrvClassNameBuiltIn, "UpdateBatchAndRequery", 10, ThreadCollectionParam, DBName, Rs.ContentChangesOnly)
  Else
    Set UpdateBatchSQLite = RPCCnn.RPC(SrvDllNameYourOwn, SrvClassNameYourOwn, "UpdateBatchAndRequery", 10, ThreadCollectionParam, DBName, Rs.ContentChangesOnly)
  End If
  If Err Then Exit Function
'  Set UpdateBatchSQLite = New_c.Recordset
'  UpdateBatchSQLite.Content = B
End Function

Public Function ExecuteSQLite(DBName As String, SQL As String) As Long
  On Error Resume Next
  'If RPCCnn.DebugMode Then DBName = "Bin\" & DBName
  
  'Now the RPC with a TimeOut of 10 seconds...
  If UseBuiltInServerClass Then
    ExecuteSQLite = RPCCnn.RPC(SrvDllNameBuiltIn, SrvClassNameBuiltIn, "Execute", 10, ThreadCollectionParam, DBName, SQL)
  Else
    ExecuteSQLite = RPCCnn.RPC(SrvDllNameYourOwn, SrvClassNameYourOwn, "Execute", 10, ThreadCollectionParam, DBName, SQL)
  End If
End Function
'*********** End of the Wrapper-Functions for SQLite **************



