VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "Form1"
   ClientHeight    =   6732
   ClientLeft      =   72
   ClientTop       =   396
   ClientWidth     =   12348
   BeginProperty Font 
      Name            =   "DejaVu Sans Mono"
      Size            =   9
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   561
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   1029
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton cmdTest 
      Caption         =   "Run test"
      Height          =   372
      Left            =   5700
      TabIndex        =   6
      ToolTipText     =   $"frmMain.frx":0000
      Top             =   360
      Width           =   2052
   End
   Begin VB.TextBox txtOut 
      BackColor       =   &H00C0E0FF&
      Height          =   2592
      Left            =   0
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Beides
      TabIndex        =   5
      Text            =   "frmMain.frx":008B
      ToolTipText     =   "Shows test run messages"
      Top             =   3480
      Width           =   2112
   End
   Begin VB.TextBox txtRC3Status 
      BackColor       =   &H00C0E0FF&
      Height          =   2652
      Left            =   0
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Beides
      TabIndex        =   4
      Text            =   "frmMain.frx":0093
      ToolTipText     =   "Shows the current modRC3 status and the load status of the framework dlls"
      Top             =   780
      Width           =   2112
   End
   Begin VB.CommandButton cmdDeInit 
      Caption         =   "Call gRC3_DeInit"
      Height          =   372
      Left            =   3600
      TabIndex        =   3
      ToolTipText     =   "Immediately calls gRC3_DeInit"
      Top             =   360
      Width           =   2052
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Call gRC3_Init"
      Height          =   372
      Left            =   1500
      TabIndex        =   2
      ToolTipText     =   "Immediately calls gRC3_Init"
      Top             =   360
      Width           =   2052
   End
   Begin VB.CheckBox chkForceRegFree 
      Caption         =   "Reg free"
      Height          =   372
      Left            =   0
      TabIndex        =   1
      ToolTipText     =   "When checked, calls to gRC3_Init have ForceRegFree set to True"
      Top             =   360
      Width           =   1392
   End
   Begin VB.TextBox txtFrameworkPath 
      Height          =   312
      Left            =   0
      TabIndex        =   0
      Text            =   "Text1"
      ToolTipText     =   "This path is used as framework path when calling gRC3_Init. Double click to restore the default path"
      Top             =   0
      Width           =   2112
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'*******************************************************************************
'* Private apis
'*******************************************************************************

Private Declare Function GetModuleHandle Lib "kernel32.dll" Alias "GetModuleHandleW" _
                  (ByVal DllName As Long) As Long

Private Declare Function GetModuleFileName Lib "kernel32.dll" Alias "GetModuleFileNameW" _
                  (ByVal hModule As Long, _
                   ByRef lpFileName As Byte, _
                   ByVal nSize As Long) As Long


'*******************************************************************************
'* Private members
'*******************************************************************************

Private mDefaultFrameworkPath As String
Private mFrameworkPath As String
Private mForceRegFree As Boolean

Private mInitInFormLoad
Private mBlockEvents As Boolean

Private mSA() As String, mSC As Long


'*******************************************************************************
'* Public startup method
'*******************************************************************************

Public Sub ShowDialog(ByVal DefaultFrameworkPath As String, _
             Optional ByVal InitInFormLoad As Boolean = False, _
             Optional ByVal ForceRegFree As Boolean = False)
mBlockEvents = True

mDefaultFrameworkPath = DefaultFrameworkPath
mFrameworkPath = DefaultFrameworkPath
mForceRegFree = ForceRegFree
mInitInFormLoad = InitInFormLoad
Load Me

Init
mBlockEvents = False
Me.Show
End Sub


'*******************************************************************************
'* Private form events
'*******************************************************************************

Private Sub Form_Load()
On Error GoTo MethodError
If mInitInFormLoad Then gRC3_Init mFrameworkPath, mForceRegFree
Exit Sub
MethodError:
  gErrShow
End Sub

Private Sub Form_Resize()
Dim H As Long
txtFrameworkPath.Width = ScaleWidth
With txtRC3Status
  .Width = ScaleWidth
  H = ScaleHeight - (.Top + .Height) - 3
  If H < 40 Then H = 40
End With
With txtOut
  .Width = ScaleWidth
  .Height = H
End With
End Sub


'*******************************************************************************
'* Private control events
'*******************************************************************************

Private Sub chkForceRegFree_Click()
If mBlockEvents Then Exit Sub
mForceRegFree = (chkForceRegFree.Value = vbChecked)
End Sub

Private Sub txtFrameworkPath_Change()
If mBlockEvents Then Exit Sub
mFrameworkPath = txtFrameworkPath.Text
End Sub

Private Sub txtFrameworkPath_DblClick()
txtFrameworkPath.Text = mDefaultFrameworkPath
End Sub

Private Sub cmdInit_Click()
On Error GoTo MethodError
gRC3_Init mFrameworkPath, mForceRegFree
ShowRC3Status
Exit Sub
MethodError:
  ShowRC3Status
  gErrShow
End Sub

Private Sub cmdDeInit_Click()
On Error GoTo MethodError
gRC3_DeInit
ShowRC3Status
Exit Sub
MethodError:
  ShowRC3Status
  gErrShow
End Sub

Private Sub cmdTest_Click()
On Error GoTo MethodError
Test
AddMTestResult "Test passed."
OutM
ShowRC3Status
Exit Sub
MethodError:
  AddMTestResult "Test failed!" & vbCrLf & Err.Number & ": " & Err.Description
  OutM
  ShowRC3Status
  gErrShow
End Sub


'*******************************************************************************
'* Private main helpers
'*******************************************************************************

Private Sub Init()
Caption = App.EXEName
txtFrameworkPath.Text = mFrameworkPath
If mForceRegFree Then
  chkForceRegFree.Value = vbChecked
Else
  chkForceRegFree.Value = vbUnchecked
End If
OutClear
ShowRC3Status
End Sub

'Instantiate some classes and do something with them to ensure that initialization
'gRC3_Init was successfull and therefore we can access it.

Private Sub Test()
Dim sa() As String, sc As Long
Dim Col As cCollection, i As Long, DOM As cSimpleDOM

OutClear
AddMClear

AddM 0, "* Set Col = gRC3_New.Collection"
Set Col = gRC3_New.Collection
AddM 2, "OK": AddM 0

AddM 0, "* Adding 10000 items to cCollection: .Add ""Item "" & i, ""Key "" & i"
With Col
  For i = 0 To 9999
    .Add "Item " & i, "Key " & i
  Next i
End With
AddM 2, "OK": AddM 0

AddM 0, "* Show: Col.KeyByIndex(2), Col.Item(Col.KeyByIndex(2))"
AddM 2, Col.KeyByIndex(2), Col.Item(Col.KeyByIndex(2)): AddM 0

AddM 0, "* Col.Item(Col.KeyByIndex(2)) = Col.Item(Col.KeyByIndex(2)) & "" - changed"""
Col.Item(Col.KeyByIndex(2)) = Col.Item(Col.KeyByIndex(2)) & " - changed"
AddM 2, "OK": AddM 0

AddM 0, "* Show: Col.KeyByIndex(2), Col.Item(Col.KeyByIndex(2))"
AddM 2, Col.KeyByIndex(2), Col.Item(Col.KeyByIndex(2)): AddM 0

AddM 0, "* Set DOM = gRC3_New.SimpleDOM"
Set DOM = gRC3_New.SimpleDOM
AddM 2, "OK": AddM 0

AddM 0, "* DOM.XML = ""<root><sub></sub></root>"""
DOM.XML = "<root><sub></sub></root>"
AddM 2, "OK": AddM 0

AddM 0, "* Show: DOM.XML"
AddM 2, DOM.XML: AddM 0

AddM 0, "* Show: DOM.ElementsTotal"
AddM 2, DOM.ElementsTotal: AddM 0

AddM 0, "* Show: DOM.Elements.Item(0).BaseName"
AddM 2, DOM.Elements.Item(0).BaseName

End Sub

Private Sub ShowRC3Status()
Const cPL As Long = 32
Dim sa() As String, sc As Long

Add sa, sc, FieldR("IsInitialized", cPL), ToBool(gRC3_IsInitialized)
If gRC3_IsInitialized Then
  Add sa, sc, FieldR("UsesRegistered", cPL), ToBool(gRC3_UsesRegistered)
  If gRC3_UsesRegistered Then
    Add sa, sc, FieldR("Frameworkpath (not used)", cPL), gRC3_FrameworkPath
  Else
    Add sa, sc, FieldR("Frameworkpath", cPL), gRC3_FrameworkPath
  End If
End If

Add sa, sc
AddModuleStatus sa, sc, cPL, gcRC3_DirectCOM_DLLNAME
AddModuleStatus sa, sc, cPL, gcRC3_RichClient3_DLLNAME
AddModuleStatus sa, sc, cPL, gcRC3_SQLite_DLLNAME

txtRC3Status.Text = Join$(sa, vbCrLf)
End Sub

Private Sub AddModuleStatus(ByRef sa() As String, ByRef sc As Long, ByVal PadLen As Long, ByVal DllName As String)
Dim IsLoaded As Boolean, PathLoadedFrom As String

GetModuleInformation DllName, IsLoaded, PathLoadedFrom
Add sa, sc, FieldR(DllName & " loaded", PadLen) & ToBool(IsLoaded)
If IsLoaded Then
  Add sa, sc, FieldR(DllName & " loaded from", PadLen) & PathLoadedFrom
End If
End Sub


'*******************************************************************************
'* Private api helpers
'*******************************************************************************

Private Sub GetModuleInformation(ByVal Name As String, _
                                 ByRef IsLoaded As Boolean, _
                                 ByRef PathLoadedFrom As String)
Const cMaxChars As Long = 2 ^ 15 - 1
Dim hModule As Long, Res As Long, Buf() As Byte

ReDim Buf(0 To cMaxChars * 2 - 1)
hModule = GetModuleHandle(StrPtr(Name))
If hModule <> 0 Then
  IsLoaded = True
  Res = GetModuleFileName(hModule, Buf(0), cMaxChars)
  If Res > 0 Then
    ReDim Preserve Buf(0 To Res * 2 - 1)
    PathLoadedFrom = Buf
  Else
    PathLoadedFrom = "Error: could not determine path"
  End If
Else
  IsLoaded = False
  PathLoadedFrom = vbNullString
End If
End Sub


'*******************************************************************************
'* Private misc helpers
'*******************************************************************************

Private Function FieldR(ByVal Msg As String, _
               Optional ByVal PadLen As Long = 20, _
               Optional ByVal FieldSep As String = ": ", _
               Optional ByVal PadChar As String = " ") As String
FieldR = PadR(Msg, PadLen, PadChar) & FieldSep
End Function

Private Function PadR(ByVal Msg As String, _
             Optional ByVal PadLen As Long = 20, _
             Optional ByVal PadChar As String = " ") As String
Dim l As Long
l = Len(Msg)
If l < PadLen Then
  PadR = Msg & String$(PadLen - l, PadChar)
Else
  PadR = Msg
End If
End Function

Private Function ToBool(ByVal Value As Boolean, _
               Optional ByVal Text As String = "Yes|No") As String
Dim sa() As String
sa = Split(Text, "|")
If Value Then ToBool = sa(0) Else ToBool = sa(1)
End Function

Private Sub OutClear()
txtOut.Text = vbNullString
End Sub

Private Sub Out(Optional ByVal Msg As String)
With txtOut
  .SelLength = 0
  .SelStart = Len(.Text)
  .SelText = Msg & vbCrLf
End With
End Sub

Private Sub OutM()
Out Join$(mSA, vbCrLf)
End Sub

Private Sub AddMTestResult(ByVal Msg As String)
AddM 0
AddM 0, String$(50, "-")
AddM 0, Msg
End Sub

Private Sub AddMClear()
Erase mSA: mSC = 0
End Sub

Private Sub AddM(ByVal Indent As Long, ParamArray Msgs() As Variant)
ReDim Preserve mSA(0 To mSC)
If UBound(Msgs) >= 0 Then
  Msgs(0) = Space$(Indent) & Msgs(0)
  mSA(mSC) = Join$(Msgs, vbTab)
End If
mSC = mSC + 1
End Sub

Private Sub Add(ByRef sa() As String, ByRef sc As Long, ParamArray Msgs() As Variant)
ReDim Preserve sa(0 To sc)
If UBound(Msgs) >= 0 Then sa(sc) = Join$(Msgs, vbNullString)
sc = sc + 1
End Sub
